/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.mysql.model.DbSystem;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDbSystemsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private Boolean isAnalyticsClusterAttached;
    private Boolean isHeatWaveClusterAttached;
    private String dbSystemId;
    private String displayName;
    private DbSystem.LifecycleState lifecycleState;
    private String configurationId;
    private Boolean isUpToDate;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;

    @ConstructorProperties(value={"compartmentId", "opcRequestId", "isAnalyticsClusterAttached", "isHeatWaveClusterAttached", "dbSystemId", "displayName", "lifecycleState", "configurationId", "isUpToDate", "sortBy", "sortOrder", "limit", "page"})
    ListDbSystemsRequest(String compartmentId, String opcRequestId, Boolean isAnalyticsClusterAttached, Boolean isHeatWaveClusterAttached, String dbSystemId, String displayName, DbSystem.LifecycleState lifecycleState, String configurationId, Boolean isUpToDate, SortBy sortBy, SortOrder sortOrder, Integer limit, String page) {
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.isAnalyticsClusterAttached = isAnalyticsClusterAttached;
        this.isHeatWaveClusterAttached = isHeatWaveClusterAttached;
        this.dbSystemId = dbSystemId;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.configurationId = configurationId;
        this.isUpToDate = isUpToDate;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsAnalyticsClusterAttached() {
        return this.isAnalyticsClusterAttached;
    }

    public Boolean getIsHeatWaveClusterAttached() {
        return this.isHeatWaveClusterAttached;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DbSystem.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public Boolean getIsUpToDate() {
        return this.isUpToDate;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbSystemsRequest, Void> {
        private String compartmentId;
        private String opcRequestId;
        private Boolean isAnalyticsClusterAttached;
        private Boolean isHeatWaveClusterAttached;
        private String dbSystemId;
        private String displayName;
        private DbSystem.LifecycleState lifecycleState;
        private String configurationId;
        private Boolean isUpToDate;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbSystemsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.isAnalyticsClusterAttached(o.getIsAnalyticsClusterAttached());
            this.isHeatWaveClusterAttached(o.getIsHeatWaveClusterAttached());
            this.dbSystemId(o.getDbSystemId());
            this.displayName(o.getDisplayName());
            this.lifecycleState(o.getLifecycleState());
            this.configurationId(o.getConfigurationId());
            this.isUpToDate(o.getIsUpToDate());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbSystemsRequest build() {
            ListDbSystemsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isAnalyticsClusterAttached(Boolean isAnalyticsClusterAttached) {
            this.isAnalyticsClusterAttached = isAnalyticsClusterAttached;
            return this;
        }

        public Builder isHeatWaveClusterAttached(Boolean isHeatWaveClusterAttached) {
            this.isHeatWaveClusterAttached = isHeatWaveClusterAttached;
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder lifecycleState(DbSystem.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public Builder isUpToDate(Boolean isUpToDate) {
            this.isUpToDate = isUpToDate;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListDbSystemsRequest buildWithoutInvocationCallback() {
            return new ListDbSystemsRequest(this.compartmentId, this.opcRequestId, this.isAnalyticsClusterAttached, this.isHeatWaveClusterAttached, this.dbSystemId, this.displayName, this.lifecycleState, this.configurationId, this.isUpToDate, this.sortBy, this.sortOrder, this.limit, this.page);
        }

        public String toString() {
            return "ListDbSystemsRequest.Builder(compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", isAnalyticsClusterAttached=" + this.isAnalyticsClusterAttached + ", isHeatWaveClusterAttached=" + this.isHeatWaveClusterAttached + ", dbSystemId=" + this.dbSystemId + ", displayName=" + this.displayName + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", configurationId=" + this.configurationId + ", isUpToDate=" + this.isUpToDate + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        DisplayName("displayName"),
        TimeCreated("timeCreated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

