/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.mysql.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListShapesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private List<IsSupportedFor> isSupportedFor;
    private String availabilityDomain;
    private String name;

    @ConstructorProperties(value={"compartmentId", "opcRequestId", "isSupportedFor", "availabilityDomain", "name"})
    ListShapesRequest(String compartmentId, String opcRequestId, List<IsSupportedFor> isSupportedFor, String availabilityDomain, String name) {
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.isSupportedFor = isSupportedFor;
        this.availabilityDomain = availabilityDomain;
        this.name = name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<IsSupportedFor> getIsSupportedFor() {
        return this.isSupportedFor;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getName() {
        return this.name;
    }

    public static class Builder
    implements BmcRequest.Builder<ListShapesRequest, Void> {
        private String compartmentId;
        private String opcRequestId;
        private List<IsSupportedFor> isSupportedFor;
        private String availabilityDomain;
        private String name;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListShapesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.isSupportedFor(o.getIsSupportedFor());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.name(o.getName());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListShapesRequest build() {
            ListShapesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isSupportedFor(List<IsSupportedFor> isSupportedFor) {
            this.isSupportedFor = isSupportedFor;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public ListShapesRequest buildWithoutInvocationCallback() {
            return new ListShapesRequest(this.compartmentId, this.opcRequestId, this.isSupportedFor, this.availabilityDomain, this.name);
        }

        public String toString() {
            return "ListShapesRequest.Builder(compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", isSupportedFor=" + this.isSupportedFor + ", availabilityDomain=" + this.availabilityDomain + ", name=" + this.name + ")";
        }
    }

    public static enum IsSupportedFor {
        Dbsystem("DBSYSTEM"),
        Analyticscluster("ANALYTICSCLUSTER"),
        Heatwavecluster("HEATWAVECLUSTER");

        private final String value;
        private static Map<String, IsSupportedFor> map;

        private IsSupportedFor(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsSupportedFor create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IsSupportedFor: " + key);
        }

        static {
            map = new HashMap<String, IsSupportedFor>();
            for (IsSupportedFor v : IsSupportedFor.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

