/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.networkloadbalancer.NetworkLoadBalancerAsync;
import com.oracle.bmc.networkloadbalancer.internal.http.ChangeNetworkLoadBalancerCompartmentConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.CreateBackendConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.CreateBackendSetConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.CreateListenerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.CreateNetworkLoadBalancerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.DeleteBackendConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.DeleteBackendSetConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.DeleteListenerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.DeleteNetworkLoadBalancerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetBackendConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetBackendHealthConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetBackendSetConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetBackendSetHealthConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetHealthCheckerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetListenerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetNetworkLoadBalancerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetNetworkLoadBalancerHealthConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListBackendSetsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListBackendsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListListenersConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListNetworkLoadBalancerHealthsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListNetworkLoadBalancersConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListNetworkLoadBalancersPoliciesConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListNetworkLoadBalancersProtocolsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateBackendConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateBackendSetConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateHealthCheckerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateListenerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateNetworkLoadBalancerConverter;
import com.oracle.bmc.networkloadbalancer.internal.http.UpdateNetworkSecurityGroupsConverter;
import com.oracle.bmc.networkloadbalancer.requests.ChangeNetworkLoadBalancerCompartmentRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.CreateNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.DeleteNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendHealthRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendSetHealthRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetHealthCheckerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetNetworkLoadBalancerHealthRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.GetWorkRequestRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListBackendSetsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListBackendsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListListenersRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancerHealthsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersPoliciesRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersProtocolsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListNetworkLoadBalancersRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.networkloadbalancer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateBackendRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateBackendSetRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateHealthCheckerRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateListenerRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateNetworkLoadBalancerRequest;
import com.oracle.bmc.networkloadbalancer.requests.UpdateNetworkSecurityGroupsRequest;
import com.oracle.bmc.networkloadbalancer.responses.ChangeNetworkLoadBalancerCompartmentResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.CreateNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.DeleteNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendHealthResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendSetHealthResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetHealthCheckerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetNetworkLoadBalancerHealthResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.GetWorkRequestResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListBackendSetsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListBackendsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListListenersResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancerHealthsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersPoliciesResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersProtocolsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListNetworkLoadBalancersResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.networkloadbalancer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateBackendResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateBackendSetResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateHealthCheckerResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateListenerResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateNetworkLoadBalancerResponse;
import com.oracle.bmc.networkloadbalancer.responses.UpdateNetworkSecurityGroupsResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkLoadBalancerAsyncClient
implements NetworkLoadBalancerAsync {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkLoadBalancerAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NETWORKLOADBALANCER").serviceEndpointPrefix("").serviceEndpointTemplate("https://network-load-balancer-api.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public NetworkLoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public NetworkLoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public NetworkLoadBalancerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public NetworkLoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public NetworkLoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public NetworkLoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public NetworkLoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public NetworkLoadBalancerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeNetworkLoadBalancerCompartmentResponse> changeNetworkLoadBalancerCompartment(ChangeNetworkLoadBalancerCompartmentRequest request, AsyncHandler<ChangeNetworkLoadBalancerCompartmentRequest, ChangeNetworkLoadBalancerCompartmentResponse> handler) {
        LOG.trace("Called async changeNetworkLoadBalancerCompartment");
        ChangeNetworkLoadBalancerCompartmentRequest interceptedRequest = ChangeNetworkLoadBalancerCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeNetworkLoadBalancerCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeNetworkLoadBalancerCompartmentResponse> transformer = ChangeNetworkLoadBalancerCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeNetworkLoadBalancerCompartmentRequest, ChangeNetworkLoadBalancerCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeNetworkLoadBalancerCompartmentRequest, ChangeNetworkLoadBalancerCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateBackendResponse> createBackend(CreateBackendRequest request, AsyncHandler<CreateBackendRequest, CreateBackendResponse> handler) {
        LOG.trace("Called async createBackend");
        CreateBackendRequest interceptedRequest = CreateBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBackendResponse> transformer = CreateBackendConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateBackendRequest, CreateBackendResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateBackendRequest, CreateBackendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateBackendSetResponse> createBackendSet(CreateBackendSetRequest request, AsyncHandler<CreateBackendSetRequest, CreateBackendSetResponse> handler) {
        LOG.trace("Called async createBackendSet");
        CreateBackendSetRequest interceptedRequest = CreateBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBackendSetResponse> transformer = CreateBackendSetConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateBackendSetRequest, CreateBackendSetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateBackendSetRequest, CreateBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateListenerResponse> createListener(CreateListenerRequest request, AsyncHandler<CreateListenerRequest, CreateListenerResponse> handler) {
        LOG.trace("Called async createListener");
        CreateListenerRequest interceptedRequest = CreateListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateListenerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateListenerResponse> transformer = CreateListenerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateListenerRequest, CreateListenerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateListenerRequest, CreateListenerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateNetworkLoadBalancerResponse> createNetworkLoadBalancer(CreateNetworkLoadBalancerRequest request, AsyncHandler<CreateNetworkLoadBalancerRequest, CreateNetworkLoadBalancerResponse> handler) {
        LOG.trace("Called async createNetworkLoadBalancer");
        CreateNetworkLoadBalancerRequest interceptedRequest = CreateNetworkLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNetworkLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateNetworkLoadBalancerResponse> transformer = CreateNetworkLoadBalancerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateNetworkLoadBalancerRequest, CreateNetworkLoadBalancerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateNetworkLoadBalancerRequest, CreateNetworkLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteBackendResponse> deleteBackend(DeleteBackendRequest request, AsyncHandler<DeleteBackendRequest, DeleteBackendResponse> handler) {
        LOG.trace("Called async deleteBackend");
        DeleteBackendRequest interceptedRequest = DeleteBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBackendResponse> transformer = DeleteBackendConverter.fromResponse();
        AsyncHandler<DeleteBackendRequest, DeleteBackendResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteBackendRequest, DeleteBackendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteBackendSetResponse> deleteBackendSet(DeleteBackendSetRequest request, AsyncHandler<DeleteBackendSetRequest, DeleteBackendSetResponse> handler) {
        LOG.trace("Called async deleteBackendSet");
        DeleteBackendSetRequest interceptedRequest = DeleteBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBackendSetResponse> transformer = DeleteBackendSetConverter.fromResponse();
        AsyncHandler<DeleteBackendSetRequest, DeleteBackendSetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteBackendSetRequest, DeleteBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteListenerResponse> deleteListener(DeleteListenerRequest request, AsyncHandler<DeleteListenerRequest, DeleteListenerResponse> handler) {
        LOG.trace("Called async deleteListener");
        DeleteListenerRequest interceptedRequest = DeleteListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteListenerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteListenerResponse> transformer = DeleteListenerConverter.fromResponse();
        AsyncHandler<DeleteListenerRequest, DeleteListenerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteListenerRequest, DeleteListenerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteNetworkLoadBalancerResponse> deleteNetworkLoadBalancer(DeleteNetworkLoadBalancerRequest request, AsyncHandler<DeleteNetworkLoadBalancerRequest, DeleteNetworkLoadBalancerResponse> handler) {
        LOG.trace("Called async deleteNetworkLoadBalancer");
        DeleteNetworkLoadBalancerRequest interceptedRequest = DeleteNetworkLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNetworkLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteNetworkLoadBalancerResponse> transformer = DeleteNetworkLoadBalancerConverter.fromResponse();
        AsyncHandler<DeleteNetworkLoadBalancerRequest, DeleteNetworkLoadBalancerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteNetworkLoadBalancerRequest, DeleteNetworkLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBackendResponse> getBackend(GetBackendRequest request, AsyncHandler<GetBackendRequest, GetBackendResponse> handler) {
        LOG.trace("Called async getBackend");
        GetBackendRequest interceptedRequest = GetBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendResponse> transformer = GetBackendConverter.fromResponse();
        AsyncHandler<GetBackendRequest, GetBackendResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBackendRequest, GetBackendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBackendHealthResponse> getBackendHealth(GetBackendHealthRequest request, AsyncHandler<GetBackendHealthRequest, GetBackendHealthResponse> handler) {
        LOG.trace("Called async getBackendHealth");
        GetBackendHealthRequest interceptedRequest = GetBackendHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendHealthConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendHealthResponse> transformer = GetBackendHealthConverter.fromResponse();
        AsyncHandler<GetBackendHealthRequest, GetBackendHealthResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBackendHealthRequest, GetBackendHealthResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBackendSetResponse> getBackendSet(GetBackendSetRequest request, AsyncHandler<GetBackendSetRequest, GetBackendSetResponse> handler) {
        LOG.trace("Called async getBackendSet");
        GetBackendSetRequest interceptedRequest = GetBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendSetResponse> transformer = GetBackendSetConverter.fromResponse();
        AsyncHandler<GetBackendSetRequest, GetBackendSetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBackendSetRequest, GetBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBackendSetHealthResponse> getBackendSetHealth(GetBackendSetHealthRequest request, AsyncHandler<GetBackendSetHealthRequest, GetBackendSetHealthResponse> handler) {
        LOG.trace("Called async getBackendSetHealth");
        GetBackendSetHealthRequest interceptedRequest = GetBackendSetHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackendSetHealthConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackendSetHealthResponse> transformer = GetBackendSetHealthConverter.fromResponse();
        AsyncHandler<GetBackendSetHealthRequest, GetBackendSetHealthResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBackendSetHealthRequest, GetBackendSetHealthResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetHealthCheckerResponse> getHealthChecker(GetHealthCheckerRequest request, AsyncHandler<GetHealthCheckerRequest, GetHealthCheckerResponse> handler) {
        LOG.trace("Called async getHealthChecker");
        GetHealthCheckerRequest interceptedRequest = GetHealthCheckerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHealthCheckerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHealthCheckerResponse> transformer = GetHealthCheckerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<GetHealthCheckerRequest, GetHealthCheckerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetHealthCheckerRequest, GetHealthCheckerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetListenerResponse> getListener(GetListenerRequest request, AsyncHandler<GetListenerRequest, GetListenerResponse> handler) {
        LOG.trace("Called async getListener");
        GetListenerRequest interceptedRequest = GetListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetListenerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetListenerResponse> transformer = GetListenerConverter.fromResponse();
        AsyncHandler<GetListenerRequest, GetListenerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetListenerRequest, GetListenerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetNetworkLoadBalancerResponse> getNetworkLoadBalancer(GetNetworkLoadBalancerRequest request, AsyncHandler<GetNetworkLoadBalancerRequest, GetNetworkLoadBalancerResponse> handler) {
        LOG.trace("Called async getNetworkLoadBalancer");
        GetNetworkLoadBalancerRequest interceptedRequest = GetNetworkLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNetworkLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNetworkLoadBalancerResponse> transformer = GetNetworkLoadBalancerConverter.fromResponse();
        AsyncHandler<GetNetworkLoadBalancerRequest, GetNetworkLoadBalancerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetNetworkLoadBalancerRequest, GetNetworkLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetNetworkLoadBalancerHealthResponse> getNetworkLoadBalancerHealth(GetNetworkLoadBalancerHealthRequest request, AsyncHandler<GetNetworkLoadBalancerHealthRequest, GetNetworkLoadBalancerHealthResponse> handler) {
        LOG.trace("Called async getNetworkLoadBalancerHealth");
        GetNetworkLoadBalancerHealthRequest interceptedRequest = GetNetworkLoadBalancerHealthConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNetworkLoadBalancerHealthConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNetworkLoadBalancerHealthResponse> transformer = GetNetworkLoadBalancerHealthConverter.fromResponse();
        AsyncHandler<GetNetworkLoadBalancerHealthRequest, GetNetworkLoadBalancerHealthResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetNetworkLoadBalancerHealthRequest, GetNetworkLoadBalancerHealthResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBackendSetsResponse> listBackendSets(ListBackendSetsRequest request, AsyncHandler<ListBackendSetsRequest, ListBackendSetsResponse> handler) {
        LOG.trace("Called async listBackendSets");
        ListBackendSetsRequest interceptedRequest = ListBackendSetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBackendSetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBackendSetsResponse> transformer = ListBackendSetsConverter.fromResponse();
        AsyncHandler<ListBackendSetsRequest, ListBackendSetsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBackendSetsRequest, ListBackendSetsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBackendsResponse> listBackends(ListBackendsRequest request, AsyncHandler<ListBackendsRequest, ListBackendsResponse> handler) {
        LOG.trace("Called async listBackends");
        ListBackendsRequest interceptedRequest = ListBackendsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBackendsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBackendsResponse> transformer = ListBackendsConverter.fromResponse();
        AsyncHandler<ListBackendsRequest, ListBackendsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBackendsRequest, ListBackendsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListListenersResponse> listListeners(ListListenersRequest request, AsyncHandler<ListListenersRequest, ListListenersResponse> handler) {
        LOG.trace("Called async listListeners");
        ListListenersRequest interceptedRequest = ListListenersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListListenersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListListenersResponse> transformer = ListListenersConverter.fromResponse();
        AsyncHandler<ListListenersRequest, ListListenersResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListListenersRequest, ListListenersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListNetworkLoadBalancerHealthsResponse> listNetworkLoadBalancerHealths(ListNetworkLoadBalancerHealthsRequest request, AsyncHandler<ListNetworkLoadBalancerHealthsRequest, ListNetworkLoadBalancerHealthsResponse> handler) {
        LOG.trace("Called async listNetworkLoadBalancerHealths");
        ListNetworkLoadBalancerHealthsRequest interceptedRequest = ListNetworkLoadBalancerHealthsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkLoadBalancerHealthsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkLoadBalancerHealthsResponse> transformer = ListNetworkLoadBalancerHealthsConverter.fromResponse();
        AsyncHandler<ListNetworkLoadBalancerHealthsRequest, ListNetworkLoadBalancerHealthsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListNetworkLoadBalancerHealthsRequest, ListNetworkLoadBalancerHealthsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListNetworkLoadBalancersResponse> listNetworkLoadBalancers(ListNetworkLoadBalancersRequest request, AsyncHandler<ListNetworkLoadBalancersRequest, ListNetworkLoadBalancersResponse> handler) {
        LOG.trace("Called async listNetworkLoadBalancers");
        ListNetworkLoadBalancersRequest interceptedRequest = ListNetworkLoadBalancersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkLoadBalancersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkLoadBalancersResponse> transformer = ListNetworkLoadBalancersConverter.fromResponse();
        AsyncHandler<ListNetworkLoadBalancersRequest, ListNetworkLoadBalancersResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListNetworkLoadBalancersRequest, ListNetworkLoadBalancersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListNetworkLoadBalancersPoliciesResponse> listNetworkLoadBalancersPolicies(ListNetworkLoadBalancersPoliciesRequest request, AsyncHandler<ListNetworkLoadBalancersPoliciesRequest, ListNetworkLoadBalancersPoliciesResponse> handler) {
        LOG.trace("Called async listNetworkLoadBalancersPolicies");
        ListNetworkLoadBalancersPoliciesRequest interceptedRequest = ListNetworkLoadBalancersPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkLoadBalancersPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkLoadBalancersPoliciesResponse> transformer = ListNetworkLoadBalancersPoliciesConverter.fromResponse();
        AsyncHandler<ListNetworkLoadBalancersPoliciesRequest, ListNetworkLoadBalancersPoliciesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListNetworkLoadBalancersPoliciesRequest, ListNetworkLoadBalancersPoliciesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListNetworkLoadBalancersProtocolsResponse> listNetworkLoadBalancersProtocols(ListNetworkLoadBalancersProtocolsRequest request, AsyncHandler<ListNetworkLoadBalancersProtocolsRequest, ListNetworkLoadBalancersProtocolsResponse> handler) {
        LOG.trace("Called async listNetworkLoadBalancersProtocols");
        ListNetworkLoadBalancersProtocolsRequest interceptedRequest = ListNetworkLoadBalancersProtocolsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNetworkLoadBalancersProtocolsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListNetworkLoadBalancersProtocolsResponse> transformer = ListNetworkLoadBalancersProtocolsConverter.fromResponse();
        AsyncHandler<ListNetworkLoadBalancersProtocolsRequest, ListNetworkLoadBalancersProtocolsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListNetworkLoadBalancersProtocolsRequest, ListNetworkLoadBalancersProtocolsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBackendResponse> updateBackend(UpdateBackendRequest request, AsyncHandler<UpdateBackendRequest, UpdateBackendResponse> handler) {
        LOG.trace("Called async updateBackend");
        UpdateBackendRequest interceptedRequest = UpdateBackendConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBackendConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBackendResponse> transformer = UpdateBackendConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateBackendRequest, UpdateBackendResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBackendRequest, UpdateBackendResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBackendSetResponse> updateBackendSet(UpdateBackendSetRequest request, AsyncHandler<UpdateBackendSetRequest, UpdateBackendSetResponse> handler) {
        LOG.trace("Called async updateBackendSet");
        UpdateBackendSetRequest interceptedRequest = UpdateBackendSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBackendSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBackendSetResponse> transformer = UpdateBackendSetConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateBackendSetRequest, UpdateBackendSetResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBackendSetRequest, UpdateBackendSetResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateHealthCheckerResponse> updateHealthChecker(UpdateHealthCheckerRequest request, AsyncHandler<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse> handler) {
        LOG.trace("Called async updateHealthChecker");
        UpdateHealthCheckerRequest interceptedRequest = UpdateHealthCheckerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHealthCheckerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateHealthCheckerResponse> transformer = UpdateHealthCheckerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateHealthCheckerRequest, UpdateHealthCheckerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateListenerResponse> updateListener(UpdateListenerRequest request, AsyncHandler<UpdateListenerRequest, UpdateListenerResponse> handler) {
        LOG.trace("Called async updateListener");
        UpdateListenerRequest interceptedRequest = UpdateListenerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateListenerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateListenerResponse> transformer = UpdateListenerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateListenerRequest, UpdateListenerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateListenerRequest, UpdateListenerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateNetworkLoadBalancerResponse> updateNetworkLoadBalancer(UpdateNetworkLoadBalancerRequest request, AsyncHandler<UpdateNetworkLoadBalancerRequest, UpdateNetworkLoadBalancerResponse> handler) {
        LOG.trace("Called async updateNetworkLoadBalancer");
        UpdateNetworkLoadBalancerRequest interceptedRequest = UpdateNetworkLoadBalancerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNetworkLoadBalancerConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNetworkLoadBalancerResponse> transformer = UpdateNetworkLoadBalancerConverter.fromResponse();
        AsyncHandler<UpdateNetworkLoadBalancerRequest, UpdateNetworkLoadBalancerResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateNetworkLoadBalancerRequest, UpdateNetworkLoadBalancerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateNetworkSecurityGroupsResponse> updateNetworkSecurityGroups(UpdateNetworkSecurityGroupsRequest request, AsyncHandler<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse> handler) {
        LOG.trace("Called async updateNetworkSecurityGroups");
        UpdateNetworkSecurityGroupsRequest interceptedRequest = UpdateNetworkSecurityGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNetworkSecurityGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNetworkSecurityGroupsResponse> transformer = UpdateNetworkSecurityGroupsConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateNetworkSecurityGroupsRequest, UpdateNetworkSecurityGroupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NetworkLoadBalancerAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public NetworkLoadBalancerAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new NetworkLoadBalancerAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

