/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetBackendSetRequest
extends BmcRequest<Void> {
    private String networkLoadBalancerId;
    private String backendSetName;
    private String opcRequestId;
    private String ifNoneMatch;

    @ConstructorProperties(value={"networkLoadBalancerId", "backendSetName", "opcRequestId", "ifNoneMatch"})
    GetBackendSetRequest(String networkLoadBalancerId, String backendSetName, String opcRequestId, String ifNoneMatch) {
        this.networkLoadBalancerId = networkLoadBalancerId;
        this.backendSetName = backendSetName;
        this.opcRequestId = opcRequestId;
        this.ifNoneMatch = ifNoneMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNetworkLoadBalancerId() {
        return this.networkLoadBalancerId;
    }

    public String getBackendSetName() {
        return this.backendSetName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBackendSetRequest, Void> {
        private String networkLoadBalancerId;
        private String backendSetName;
        private String opcRequestId;
        private String ifNoneMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBackendSetRequest o) {
            this.networkLoadBalancerId(o.getNetworkLoadBalancerId());
            this.backendSetName(o.getBackendSetName());
            this.opcRequestId(o.getOpcRequestId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBackendSetRequest build() {
            GetBackendSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder networkLoadBalancerId(String networkLoadBalancerId) {
            this.networkLoadBalancerId = networkLoadBalancerId;
            return this;
        }

        public Builder backendSetName(String backendSetName) {
            this.backendSetName = backendSetName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public GetBackendSetRequest buildWithoutInvocationCallback() {
            return new GetBackendSetRequest(this.networkLoadBalancerId, this.backendSetName, this.opcRequestId, this.ifNoneMatch);
        }

        public String toString() {
            return "GetBackendSetRequest.Builder(networkLoadBalancerId=" + this.networkLoadBalancerId + ", backendSetName=" + this.backendSetName + ", opcRequestId=" + this.opcRequestId + ", ifNoneMatch=" + this.ifNoneMatch + ")";
        }
    }
}

