/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetListenerRequest
extends BmcRequest<Void> {
    private String networkLoadBalancerId;
    private String listenerName;
    private String opcRequestId;
    private String ifNoneMatch;

    @ConstructorProperties(value={"networkLoadBalancerId", "listenerName", "opcRequestId", "ifNoneMatch"})
    GetListenerRequest(String networkLoadBalancerId, String listenerName, String opcRequestId, String ifNoneMatch) {
        this.networkLoadBalancerId = networkLoadBalancerId;
        this.listenerName = listenerName;
        this.opcRequestId = opcRequestId;
        this.ifNoneMatch = ifNoneMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNetworkLoadBalancerId() {
        return this.networkLoadBalancerId;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<GetListenerRequest, Void> {
        private String networkLoadBalancerId;
        private String listenerName;
        private String opcRequestId;
        private String ifNoneMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetListenerRequest o) {
            this.networkLoadBalancerId(o.getNetworkLoadBalancerId());
            this.listenerName(o.getListenerName());
            this.opcRequestId(o.getOpcRequestId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetListenerRequest build() {
            GetListenerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder networkLoadBalancerId(String networkLoadBalancerId) {
            this.networkLoadBalancerId = networkLoadBalancerId;
            return this;
        }

        public Builder listenerName(String listenerName) {
            this.listenerName = listenerName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public GetListenerRequest buildWithoutInvocationCallback() {
            return new GetListenerRequest(this.networkLoadBalancerId, this.listenerName, this.opcRequestId, this.ifNoneMatch);
        }

        public String toString() {
            return "GetListenerRequest.Builder(networkLoadBalancerId=" + this.networkLoadBalancerId + ", listenerName=" + this.listenerName + ", opcRequestId=" + this.opcRequestId + ", ifNoneMatch=" + this.ifNoneMatch + ")";
        }
    }
}

