/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.networkloadbalancer.requests;

import com.oracle.bmc.networkloadbalancer.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListNetworkLoadBalancersPoliciesRequest
extends BmcRequest<Void> {
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"opcRequestId", "limit", "page", "sortOrder"})
    ListNetworkLoadBalancersPoliciesRequest(String opcRequestId, Integer limit, String page, SortOrder sortOrder) {
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder
    implements BmcRequest.Builder<ListNetworkLoadBalancersPoliciesRequest, Void> {
        private String opcRequestId;
        private Integer limit;
        private String page;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListNetworkLoadBalancersPoliciesRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListNetworkLoadBalancersPoliciesRequest build() {
            ListNetworkLoadBalancersPoliciesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListNetworkLoadBalancersPoliciesRequest buildWithoutInvocationCallback() {
            return new ListNetworkLoadBalancersPoliciesRequest(this.opcRequestId, this.limit, this.page, this.sortOrder);
        }

        public String toString() {
            return "ListNetworkLoadBalancersPoliciesRequest.Builder(opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }
}

