/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.nosql.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.nosql.model.Row;
import com.oracle.bmc.nosql.requests.GetRowRequest;
import com.oracle.bmc.nosql.responses.GetRowResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRowConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetRowConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetRowRequest interceptRequest(GetRowRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetRowRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTableNameOrId(), (String)"tableNameOrId must not be blank", (Object[])new Object[0]);
        Validate.notNull(request.getKey(), (String)"key is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190828").path("tables").path(HttpUtils.encodePathSegment((String)request.getTableNameOrId())).path("rows");
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        }
        target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"key", request.getKey(), (CollectionFormatType)CollectionFormatType.Multi);
        if (request.getConsistency() != null) {
            target = target.queryParam("consistency", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getConsistency().getValue())});
        }
        if (request.getTimeoutInMs() != null) {
            target = target.queryParam("timeoutInMs", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeoutInMs())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetRowResponse> fromResponse() {
        Function<Response, GetRowResponse> transformer = new Function<Response, GetRowResponse>(){

            public GetRowResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.nosql.responses.GetRowResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Row.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetRowResponse.Builder builder = GetRowResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.row((Row)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetRowResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

