/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.internal.http.ObjectMetadataInterceptor;
import com.oracle.bmc.objectstorage.model.MultipartUpload;
import com.oracle.bmc.objectstorage.requests.CreateMultipartUploadRequest;
import com.oracle.bmc.objectstorage.responses.CreateMultipartUploadResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateMultipartUploadConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateMultipartUploadConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateMultipartUploadRequest interceptRequest(CreateMultipartUploadRequest request) {
        request = ObjectMetadataInterceptor.intercept(request);
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateMultipartUploadRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateMultipartUploadDetails(), (String)"createMultipartUploadDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment((String)request.getBucketName())).path("u");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getIfNoneMatch() != null) {
            ib.header("if-none-match", (Object)request.getIfNoneMatch());
        }
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", (Object)request.getOpcClientRequestId());
        }
        if (request.getOpcSseCustomerAlgorithm() != null) {
            ib.header("opc-sse-customer-algorithm", (Object)request.getOpcSseCustomerAlgorithm());
        }
        if (request.getOpcSseCustomerKey() != null) {
            ib.header("opc-sse-customer-key", (Object)request.getOpcSseCustomerKey());
        }
        if (request.getOpcSseCustomerKeySha256() != null) {
            ib.header("opc-sse-customer-key-sha256", (Object)request.getOpcSseCustomerKeySha256());
        }
        return ib;
    }

    public static Function<Response, CreateMultipartUploadResponse> fromResponse() {
        Function<Response, CreateMultipartUploadResponse> transformer = new Function<Response, CreateMultipartUploadResponse>(){

            public CreateMultipartUploadResponse apply(Response rawResponse) {
                Optional locationHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.objectstorage.responses.CreateMultipartUploadResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(MultipartUpload.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateMultipartUploadResponse.Builder builder = CreateMultipartUploadResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.multipartUpload((MultipartUpload)response.getItem());
                Optional opcClientRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId((String)HeaderUtils.toValue((String)"opc-client-request-id", (String)((String)((List)opcClientRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((locationHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"Location")).isPresent()) {
                    builder.location((String)HeaderUtils.toValue((String)"Location", (String)((String)((List)locationHeader.get()).get(0)), String.class));
                }
                CreateMultipartUploadResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

