/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListMultipartUploadsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String bucketName;
    private Integer limit;
    private String page;
    private String opcClientRequestId;

    @ConstructorProperties(value={"namespaceName", "bucketName", "limit", "page", "opcClientRequestId"})
    ListMultipartUploadsRequest(String namespaceName, String bucketName, Integer limit, String page, String opcClientRequestId) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.limit = limit;
        this.page = page;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMultipartUploadsRequest, Void> {
        private String namespaceName;
        private String bucketName;
        private Integer limit;
        private String page;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMultipartUploadsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMultipartUploadsRequest build() {
            ListMultipartUploadsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public ListMultipartUploadsRequest buildWithoutInvocationCallback() {
            return new ListMultipartUploadsRequest(this.namespaceName, this.bucketName, this.limit, this.page, this.opcClientRequestId);
        }

        public String toString() {
            return "ListMultipartUploadsRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", limit=" + this.limit + ", page=" + this.page + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

