/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListReplicationPoliciesRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String bucketName;
    private String opcClientRequestId;
    private String page;
    private Integer limit;

    @ConstructorProperties(value={"namespaceName", "bucketName", "opcClientRequestId", "page", "limit"})
    ListReplicationPoliciesRequest(String namespaceName, String bucketName, String opcClientRequestId, String page, Integer limit) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.opcClientRequestId = opcClientRequestId;
        this.page = page;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder
    implements BmcRequest.Builder<ListReplicationPoliciesRequest, Void> {
        private String namespaceName;
        private String bucketName;
        private String opcClientRequestId;
        private String page;
        private Integer limit;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListReplicationPoliciesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListReplicationPoliciesRequest build() {
            ListReplicationPoliciesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListReplicationPoliciesRequest buildWithoutInvocationCallback() {
            return new ListReplicationPoliciesRequest(this.namespaceName, this.bucketName, this.opcClientRequestId, this.page, this.limit);
        }

        public String toString() {
            return "ListReplicationPoliciesRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", opcClientRequestId=" + this.opcClientRequestId + ", page=" + this.page + ", limit=" + this.limit + ")";
        }
    }
}

