/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListRetentionRulesRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String bucketName;
    private String page;

    @ConstructorProperties(value={"namespaceName", "bucketName", "page"})
    ListRetentionRulesRequest(String namespaceName, String bucketName, String page) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.page = page;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRetentionRulesRequest, Void> {
        private String namespaceName;
        private String bucketName;
        private String page;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRetentionRulesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.page(o.getPage());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRetentionRulesRequest build() {
            ListRetentionRulesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public ListRetentionRulesRequest buildWithoutInvocationCallback() {
            return new ListRetentionRulesRequest(this.namespaceName, this.bucketName, this.page);
        }

        public String toString() {
            return "ListRetentionRulesRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", page=" + this.page + ")";
        }
    }
}

