/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListWorkRequestLogsRequest
extends BmcRequest<Void> {
    private String workRequestId;
    private String opcRequestId;
    private String page;
    private Integer limit;

    @ConstructorProperties(value={"workRequestId", "opcRequestId", "page", "limit"})
    ListWorkRequestLogsRequest(String workRequestId, String opcRequestId, String page, Integer limit) {
        this.workRequestId = workRequestId;
        this.opcRequestId = opcRequestId;
        this.page = page;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWorkRequestLogsRequest, Void> {
        private String workRequestId;
        private String opcRequestId;
        private String page;
        private Integer limit;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestLogsRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestLogsRequest build() {
            ListWorkRequestLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListWorkRequestLogsRequest buildWithoutInvocationCallback() {
            return new ListWorkRequestLogsRequest(this.workRequestId, this.opcRequestId, this.page, this.limit);
        }

        public String toString() {
            return "ListWorkRequestLogsRequest.Builder(workRequestId=" + this.workRequestId + ", opcRequestId=" + this.opcRequestId + ", page=" + this.page + ", limit=" + this.limit + ")";
        }
    }
}

