/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.ons.NotificationDataPlaneAsync;
import com.oracle.bmc.ons.internal.http.ChangeSubscriptionCompartmentConverter;
import com.oracle.bmc.ons.internal.http.CreateSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.DeleteSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.GetConfirmSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.GetSubscriptionConverter;
import com.oracle.bmc.ons.internal.http.GetUnsubscriptionConverter;
import com.oracle.bmc.ons.internal.http.ListSubscriptionsConverter;
import com.oracle.bmc.ons.internal.http.PublishMessageConverter;
import com.oracle.bmc.ons.internal.http.ResendSubscriptionConfirmationConverter;
import com.oracle.bmc.ons.internal.http.UpdateSubscriptionConverter;
import com.oracle.bmc.ons.requests.ChangeSubscriptionCompartmentRequest;
import com.oracle.bmc.ons.requests.CreateSubscriptionRequest;
import com.oracle.bmc.ons.requests.DeleteSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetConfirmSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetSubscriptionRequest;
import com.oracle.bmc.ons.requests.GetUnsubscriptionRequest;
import com.oracle.bmc.ons.requests.ListSubscriptionsRequest;
import com.oracle.bmc.ons.requests.PublishMessageRequest;
import com.oracle.bmc.ons.requests.ResendSubscriptionConfirmationRequest;
import com.oracle.bmc.ons.requests.UpdateSubscriptionRequest;
import com.oracle.bmc.ons.responses.ChangeSubscriptionCompartmentResponse;
import com.oracle.bmc.ons.responses.CreateSubscriptionResponse;
import com.oracle.bmc.ons.responses.DeleteSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetConfirmSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetSubscriptionResponse;
import com.oracle.bmc.ons.responses.GetUnsubscriptionResponse;
import com.oracle.bmc.ons.responses.ListSubscriptionsResponse;
import com.oracle.bmc.ons.responses.PublishMessageResponse;
import com.oracle.bmc.ons.responses.ResendSubscriptionConfirmationResponse;
import com.oracle.bmc.ons.responses.UpdateSubscriptionResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationDataPlaneAsyncClient
implements NotificationDataPlaneAsync {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationDataPlaneAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("NOTIFICATIONDATAPLANE").serviceEndpointPrefix("notification").serviceEndpointTemplate("https://notification.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public NotificationDataPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public NotificationDataPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public NotificationDataPlaneAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public NotificationDataPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public NotificationDataPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public NotificationDataPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public NotificationDataPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public NotificationDataPlaneAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeSubscriptionCompartmentResponse> changeSubscriptionCompartment(ChangeSubscriptionCompartmentRequest request, AsyncHandler<ChangeSubscriptionCompartmentRequest, ChangeSubscriptionCompartmentResponse> handler) {
        LOG.trace("Called async changeSubscriptionCompartment");
        ChangeSubscriptionCompartmentRequest interceptedRequest = ChangeSubscriptionCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSubscriptionCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSubscriptionCompartmentResponse> transformer = ChangeSubscriptionCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeSubscriptionCompartmentRequest, ChangeSubscriptionCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeSubscriptionCompartmentRequest, ChangeSubscriptionCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSubscriptionResponse> createSubscription(CreateSubscriptionRequest request, AsyncHandler<CreateSubscriptionRequest, CreateSubscriptionResponse> handler) {
        LOG.trace("Called async createSubscription");
        CreateSubscriptionRequest interceptedRequest = CreateSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSubscriptionResponse> transformer = CreateSubscriptionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateSubscriptionRequest, CreateSubscriptionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSubscriptionRequest, CreateSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSubscriptionResponse> deleteSubscription(DeleteSubscriptionRequest request, AsyncHandler<DeleteSubscriptionRequest, DeleteSubscriptionResponse> handler) {
        LOG.trace("Called async deleteSubscription");
        DeleteSubscriptionRequest interceptedRequest = DeleteSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSubscriptionResponse> transformer = DeleteSubscriptionConverter.fromResponse();
        AsyncHandler<DeleteSubscriptionRequest, DeleteSubscriptionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSubscriptionRequest, DeleteSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConfirmSubscriptionResponse> getConfirmSubscription(GetConfirmSubscriptionRequest request, AsyncHandler<GetConfirmSubscriptionRequest, GetConfirmSubscriptionResponse> handler) {
        LOG.trace("Called async getConfirmSubscription");
        GetConfirmSubscriptionRequest interceptedRequest = GetConfirmSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConfirmSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConfirmSubscriptionResponse> transformer = GetConfirmSubscriptionConverter.fromResponse();
        AsyncHandler<GetConfirmSubscriptionRequest, GetConfirmSubscriptionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConfirmSubscriptionRequest, GetConfirmSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSubscriptionResponse> getSubscription(GetSubscriptionRequest request, AsyncHandler<GetSubscriptionRequest, GetSubscriptionResponse> handler) {
        LOG.trace("Called async getSubscription");
        GetSubscriptionRequest interceptedRequest = GetSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSubscriptionResponse> transformer = GetSubscriptionConverter.fromResponse();
        AsyncHandler<GetSubscriptionRequest, GetSubscriptionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSubscriptionRequest, GetSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetUnsubscriptionResponse> getUnsubscription(GetUnsubscriptionRequest request, AsyncHandler<GetUnsubscriptionRequest, GetUnsubscriptionResponse> handler) {
        LOG.trace("Called async getUnsubscription");
        GetUnsubscriptionRequest interceptedRequest = GetUnsubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUnsubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetUnsubscriptionResponse> transformer = GetUnsubscriptionConverter.fromResponse();
        AsyncHandler<GetUnsubscriptionRequest, GetUnsubscriptionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetUnsubscriptionRequest, GetUnsubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest request, AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResponse> handler) {
        LOG.trace("Called async listSubscriptions");
        ListSubscriptionsRequest interceptedRequest = ListSubscriptionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSubscriptionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSubscriptionsResponse> transformer = ListSubscriptionsConverter.fromResponse();
        AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSubscriptionsRequest, ListSubscriptionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PublishMessageResponse> publishMessage(PublishMessageRequest request, AsyncHandler<PublishMessageRequest, PublishMessageResponse> handler) {
        LOG.trace("Called async publishMessage");
        PublishMessageRequest interceptedRequest = PublishMessageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PublishMessageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PublishMessageResponse> transformer = PublishMessageConverter.fromResponse();
        AsyncHandler<PublishMessageRequest, PublishMessageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PublishMessageRequest, PublishMessageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ResendSubscriptionConfirmationResponse> resendSubscriptionConfirmation(ResendSubscriptionConfirmationRequest request, AsyncHandler<ResendSubscriptionConfirmationRequest, ResendSubscriptionConfirmationResponse> handler) {
        LOG.trace("Called async resendSubscriptionConfirmation");
        ResendSubscriptionConfirmationRequest interceptedRequest = ResendSubscriptionConfirmationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ResendSubscriptionConfirmationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ResendSubscriptionConfirmationResponse> transformer = ResendSubscriptionConfirmationConverter.fromResponse();
        AsyncHandler<ResendSubscriptionConfirmationRequest, ResendSubscriptionConfirmationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ResendSubscriptionConfirmationRequest, ResendSubscriptionConfirmationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateSubscriptionResponse> updateSubscription(UpdateSubscriptionRequest request, AsyncHandler<UpdateSubscriptionRequest, UpdateSubscriptionResponse> handler) {
        LOG.trace("Called async updateSubscription");
        UpdateSubscriptionRequest interceptedRequest = UpdateSubscriptionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSubscriptionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSubscriptionResponse> transformer = UpdateSubscriptionConverter.fromResponse();
        AsyncHandler<UpdateSubscriptionRequest, UpdateSubscriptionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateSubscriptionRequest, UpdateSubscriptionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, NotificationDataPlaneAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public NotificationDataPlaneAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new NotificationDataPlaneAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

