/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.ons.model.PublishResult;
import com.oracle.bmc.ons.requests.PublishMessageRequest;
import com.oracle.bmc.ons.responses.PublishMessageResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishMessageConverter {
    private static final Logger LOG = LoggerFactory.getLogger(PublishMessageConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static PublishMessageRequest interceptRequest(PublishMessageRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, PublishMessageRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTopicId(), (String)"topicId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getMessageDetails(), (String)"messageDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181201").path("topics").path(HttpUtils.encodePathSegment((String)request.getTopicId())).path("messages");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getMessageType() != null) {
            ib.header("messageType", (Object)request.getMessageType().getValue());
        }
        return ib;
    }

    public static Function<Response, PublishMessageResponse> fromResponse() {
        Function<Response, PublishMessageResponse> transformer = new Function<Response, PublishMessageResponse>(){

            public PublishMessageResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.ons.responses.PublishMessageResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(PublishResult.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                PublishMessageResponse.Builder builder = PublishMessageResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.publishResult((PublishResult)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                PublishMessageResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

