/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetSubscriptionRequest
extends BmcRequest<Void> {
    private String subscriptionId;
    private String opcRequestId;

    @ConstructorProperties(value={"subscriptionId", "opcRequestId"})
    GetSubscriptionRequest(String subscriptionId, String opcRequestId) {
        this.subscriptionId = subscriptionId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSubscriptionRequest, Void> {
        private String subscriptionId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSubscriptionRequest o) {
            this.subscriptionId(o.getSubscriptionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSubscriptionRequest build() {
            GetSubscriptionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetSubscriptionRequest buildWithoutInvocationCallback() {
            return new GetSubscriptionRequest(this.subscriptionId, this.opcRequestId);
        }

        public String toString() {
            return "GetSubscriptionRequest.Builder(subscriptionId=" + this.subscriptionId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

