/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListSubscriptionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String topicId;
    private String page;
    private Integer limit;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "topicId", "page", "limit", "opcRequestId"})
    ListSubscriptionsRequest(String compartmentId, String topicId, String page, Integer limit, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.topicId = topicId;
        this.page = page;
        this.limit = limit;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSubscriptionsRequest, Void> {
        private String compartmentId;
        private String topicId;
        private String page;
        private Integer limit;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSubscriptionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.topicId(o.getTopicId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSubscriptionsRequest build() {
            ListSubscriptionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListSubscriptionsRequest buildWithoutInvocationCallback() {
            return new ListSubscriptionsRequest(this.compartmentId, this.topicId, this.page, this.limit, this.opcRequestId);
        }

        public String toString() {
            return "ListSubscriptionsRequest.Builder(compartmentId=" + this.compartmentId + ", topicId=" + this.topicId + ", page=" + this.page + ", limit=" + this.limit + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

