/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcemanager.ResourceManager;
import com.oracle.bmc.resourcemanager.ResourceManagerPaginators;
import com.oracle.bmc.resourcemanager.ResourceManagerWaiters;
import com.oracle.bmc.resourcemanager.internal.http.CancelJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.ChangeConfigurationSourceProviderCompartmentConverter;
import com.oracle.bmc.resourcemanager.internal.http.ChangeStackCompartmentConverter;
import com.oracle.bmc.resourcemanager.internal.http.ChangeTemplateCompartmentConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateConfigurationSourceProviderConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.CreateTemplateConverter;
import com.oracle.bmc.resourcemanager.internal.http.DeleteConfigurationSourceProviderConverter;
import com.oracle.bmc.resourcemanager.internal.http.DeleteStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.DeleteTemplateConverter;
import com.oracle.bmc.resourcemanager.internal.http.DetectStackDriftConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetConfigurationSourceProviderConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobLogsContentConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobLogsConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobTfConfigConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetJobTfStateConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetStackTfConfigConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetStackTfStateConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetTemplateConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetTemplateLogoConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetTemplateTfConfigConverter;
import com.oracle.bmc.resourcemanager.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListConfigurationSourceProvidersConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListJobsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListResourceDiscoveryServicesConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListStackResourceDriftDetailsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListStacksConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListTemplateCategoriesConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListTemplatesConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListTerraformVersionsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.resourcemanager.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateConfigurationSourceProviderConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateJobConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateStackConverter;
import com.oracle.bmc.resourcemanager.internal.http.UpdateTemplateConverter;
import com.oracle.bmc.resourcemanager.requests.CancelJobRequest;
import com.oracle.bmc.resourcemanager.requests.ChangeConfigurationSourceProviderCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.ChangeStackCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.ChangeTemplateCompartmentRequest;
import com.oracle.bmc.resourcemanager.requests.CreateConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.CreateJobRequest;
import com.oracle.bmc.resourcemanager.requests.CreateStackRequest;
import com.oracle.bmc.resourcemanager.requests.CreateTemplateRequest;
import com.oracle.bmc.resourcemanager.requests.DeleteConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.DeleteStackRequest;
import com.oracle.bmc.resourcemanager.requests.DeleteTemplateRequest;
import com.oracle.bmc.resourcemanager.requests.DetectStackDriftRequest;
import com.oracle.bmc.resourcemanager.requests.GetConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsContentRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobLogsRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobTfStateRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackTfStateRequest;
import com.oracle.bmc.resourcemanager.requests.GetTemplateLogoRequest;
import com.oracle.bmc.resourcemanager.requests.GetTemplateRequest;
import com.oracle.bmc.resourcemanager.requests.GetTemplateTfConfigRequest;
import com.oracle.bmc.resourcemanager.requests.GetWorkRequestRequest;
import com.oracle.bmc.resourcemanager.requests.ListConfigurationSourceProvidersRequest;
import com.oracle.bmc.resourcemanager.requests.ListJobsRequest;
import com.oracle.bmc.resourcemanager.requests.ListResourceDiscoveryServicesRequest;
import com.oracle.bmc.resourcemanager.requests.ListStackResourceDriftDetailsRequest;
import com.oracle.bmc.resourcemanager.requests.ListStacksRequest;
import com.oracle.bmc.resourcemanager.requests.ListTemplateCategoriesRequest;
import com.oracle.bmc.resourcemanager.requests.ListTemplatesRequest;
import com.oracle.bmc.resourcemanager.requests.ListTerraformVersionsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcemanager.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateJobRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateStackRequest;
import com.oracle.bmc.resourcemanager.requests.UpdateTemplateRequest;
import com.oracle.bmc.resourcemanager.responses.CancelJobResponse;
import com.oracle.bmc.resourcemanager.responses.ChangeConfigurationSourceProviderCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.ChangeStackCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.ChangeTemplateCompartmentResponse;
import com.oracle.bmc.resourcemanager.responses.CreateConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.CreateJobResponse;
import com.oracle.bmc.resourcemanager.responses.CreateStackResponse;
import com.oracle.bmc.resourcemanager.responses.CreateTemplateResponse;
import com.oracle.bmc.resourcemanager.responses.DeleteConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.DeleteStackResponse;
import com.oracle.bmc.resourcemanager.responses.DeleteTemplateResponse;
import com.oracle.bmc.resourcemanager.responses.DetectStackDriftResponse;
import com.oracle.bmc.resourcemanager.responses.GetConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsContentResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobLogsResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobTfStateResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackTfStateResponse;
import com.oracle.bmc.resourcemanager.responses.GetTemplateLogoResponse;
import com.oracle.bmc.resourcemanager.responses.GetTemplateResponse;
import com.oracle.bmc.resourcemanager.responses.GetTemplateTfConfigResponse;
import com.oracle.bmc.resourcemanager.responses.GetWorkRequestResponse;
import com.oracle.bmc.resourcemanager.responses.ListConfigurationSourceProvidersResponse;
import com.oracle.bmc.resourcemanager.responses.ListJobsResponse;
import com.oracle.bmc.resourcemanager.responses.ListResourceDiscoveryServicesResponse;
import com.oracle.bmc.resourcemanager.responses.ListStackResourceDriftDetailsResponse;
import com.oracle.bmc.resourcemanager.responses.ListStacksResponse;
import com.oracle.bmc.resourcemanager.responses.ListTemplateCategoriesResponse;
import com.oracle.bmc.resourcemanager.responses.ListTemplatesResponse;
import com.oracle.bmc.resourcemanager.responses.ListTerraformVersionsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcemanager.responses.ListWorkRequestsResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateJobResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateStackResponse;
import com.oracle.bmc.resourcemanager.responses.UpdateTemplateResponse;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerClient
implements ResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManagerClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RESOURCEMANAGER").serviceEndpointPrefix("resourcemanager").serviceEndpointTemplate("https://resourcemanager.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ResourceManagerWaiters waiters;
    private final ResourceManagerPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public ResourceManagerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ResourceManagerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ResourceManagerClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected ResourceManagerClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ResourceManager-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ResourceManagerWaiters(executorService, this);
        this.paginators = new ResourceManagerPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CancelJobResponse cancelJob(CancelJobRequest request) {
        LOG.trace("Called cancelJob");
        CancelJobRequest interceptedRequest = CancelJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelJobResponse> transformer = CancelJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CancelJobResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelJobResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (CancelJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeConfigurationSourceProviderCompartmentResponse changeConfigurationSourceProviderCompartment(ChangeConfigurationSourceProviderCompartmentRequest request) {
        LOG.trace("Called changeConfigurationSourceProviderCompartment");
        ChangeConfigurationSourceProviderCompartmentRequest interceptedRequest = ChangeConfigurationSourceProviderCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeConfigurationSourceProviderCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeConfigurationSourceProviderCompartmentResponse> transformer = ChangeConfigurationSourceProviderCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeConfigurationSourceProviderCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeConfigurationSourceProviderCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeConfigurationSourceProviderCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeConfigurationSourceProviderCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeStackCompartmentResponse changeStackCompartment(ChangeStackCompartmentRequest request) {
        LOG.trace("Called changeStackCompartment");
        ChangeStackCompartmentRequest interceptedRequest = ChangeStackCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStackCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeStackCompartmentResponse> transformer = ChangeStackCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeStackCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeStackCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeStackCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeStackCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeTemplateCompartmentResponse changeTemplateCompartment(ChangeTemplateCompartmentRequest request) {
        LOG.trace("Called changeTemplateCompartment");
        ChangeTemplateCompartmentRequest interceptedRequest = ChangeTemplateCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeTemplateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeTemplateCompartmentResponse> transformer = ChangeTemplateCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeTemplateCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeTemplateCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeTemplateCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeTemplateCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateConfigurationSourceProviderResponse createConfigurationSourceProvider(CreateConfigurationSourceProviderRequest request) {
        LOG.trace("Called createConfigurationSourceProvider");
        CreateConfigurationSourceProviderRequest interceptedRequest = CreateConfigurationSourceProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConfigurationSourceProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateConfigurationSourceProviderResponse> transformer = CreateConfigurationSourceProviderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateConfigurationSourceProviderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateConfigurationSourceProviderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateConfigurationSourceProviderDetails(), (BmcRequest)retriedRequest);
                return (CreateConfigurationSourceProviderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) {
        LOG.trace("Called createJob");
        CreateJobRequest interceptedRequest = CreateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateJobResponse> transformer = CreateJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateJobResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateJobResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateJobDetails(), (BmcRequest)retriedRequest);
                return (CreateJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateStackResponse createStack(CreateStackRequest request) {
        LOG.trace("Called createStack");
        CreateStackRequest interceptedRequest = CreateStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateStackResponse> transformer = CreateStackConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateStackResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateStackResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateStackDetails(), (BmcRequest)retriedRequest);
                return (CreateStackResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTemplateResponse createTemplate(CreateTemplateRequest request) {
        LOG.trace("Called createTemplate");
        CreateTemplateRequest interceptedRequest = CreateTemplateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTemplateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTemplateResponse> transformer = CreateTemplateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTemplateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTemplateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTemplateDetails(), (BmcRequest)retriedRequest);
                return (CreateTemplateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteConfigurationSourceProviderResponse deleteConfigurationSourceProvider(DeleteConfigurationSourceProviderRequest request) {
        LOG.trace("Called deleteConfigurationSourceProvider");
        DeleteConfigurationSourceProviderRequest interceptedRequest = DeleteConfigurationSourceProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConfigurationSourceProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteConfigurationSourceProviderResponse> transformer = DeleteConfigurationSourceProviderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteConfigurationSourceProviderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteConfigurationSourceProviderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteConfigurationSourceProviderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteStackResponse deleteStack(DeleteStackRequest request) {
        LOG.trace("Called deleteStack");
        DeleteStackRequest interceptedRequest = DeleteStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteStackResponse> transformer = DeleteStackConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteStackResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteStackResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteStackResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTemplateResponse deleteTemplate(DeleteTemplateRequest request) {
        LOG.trace("Called deleteTemplate");
        DeleteTemplateRequest interceptedRequest = DeleteTemplateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTemplateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTemplateResponse> transformer = DeleteTemplateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTemplateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTemplateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTemplateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DetectStackDriftResponse detectStackDrift(DetectStackDriftRequest request) {
        LOG.trace("Called detectStackDrift");
        DetectStackDriftRequest interceptedRequest = DetectStackDriftConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectStackDriftConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DetectStackDriftResponse> transformer = DetectStackDriftConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DetectStackDriftResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetectStackDriftResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetectStackDriftDetails(), (BmcRequest)retriedRequest);
                return (DetectStackDriftResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetConfigurationSourceProviderResponse getConfigurationSourceProvider(GetConfigurationSourceProviderRequest request) {
        LOG.trace("Called getConfigurationSourceProvider");
        GetConfigurationSourceProviderRequest interceptedRequest = GetConfigurationSourceProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConfigurationSourceProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConfigurationSourceProviderResponse> transformer = GetConfigurationSourceProviderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetConfigurationSourceProviderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetConfigurationSourceProviderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetConfigurationSourceProviderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) {
        LOG.trace("Called getJob");
        GetJobRequest interceptedRequest = GetJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobResponse> transformer = GetJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobLogsResponse getJobLogs(GetJobLogsRequest request) {
        LOG.trace("Called getJobLogs");
        GetJobLogsRequest interceptedRequest = GetJobLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobLogsResponse> transformer = GetJobLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobLogsContentResponse getJobLogsContent(GetJobLogsContentRequest request) {
        LOG.trace("Called getJobLogsContent");
        GetJobLogsContentRequest interceptedRequest = GetJobLogsContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobLogsContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobLogsContentResponse> transformer = GetJobLogsContentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobLogsContentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobLogsContentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobLogsContentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobTfConfigResponse getJobTfConfig(GetJobTfConfigRequest request) {
        LOG.trace("Called getJobTfConfig");
        GetJobTfConfigRequest interceptedRequest = GetJobTfConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobTfConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobTfConfigResponse> transformer = GetJobTfConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobTfConfigResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobTfConfigResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobTfConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobTfStateResponse getJobTfState(GetJobTfStateRequest request) {
        LOG.trace("Called getJobTfState");
        GetJobTfStateRequest interceptedRequest = GetJobTfStateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobTfStateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobTfStateResponse> transformer = GetJobTfStateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobTfStateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobTfStateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobTfStateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetStackResponse getStack(GetStackRequest request) {
        LOG.trace("Called getStack");
        GetStackRequest interceptedRequest = GetStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStackResponse> transformer = GetStackConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetStackResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetStackResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetStackResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetStackTfConfigResponse getStackTfConfig(GetStackTfConfigRequest request) {
        LOG.trace("Called getStackTfConfig");
        GetStackTfConfigRequest interceptedRequest = GetStackTfConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStackTfConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStackTfConfigResponse> transformer = GetStackTfConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetStackTfConfigResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetStackTfConfigResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetStackTfConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetStackTfStateResponse getStackTfState(GetStackTfStateRequest request) {
        LOG.trace("Called getStackTfState");
        GetStackTfStateRequest interceptedRequest = GetStackTfStateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStackTfStateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStackTfStateResponse> transformer = GetStackTfStateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetStackTfStateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetStackTfStateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetStackTfStateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTemplateResponse getTemplate(GetTemplateRequest request) {
        LOG.trace("Called getTemplate");
        GetTemplateRequest interceptedRequest = GetTemplateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTemplateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTemplateResponse> transformer = GetTemplateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTemplateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTemplateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTemplateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTemplateLogoResponse getTemplateLogo(GetTemplateLogoRequest request) {
        LOG.trace("Called getTemplateLogo");
        GetTemplateLogoRequest interceptedRequest = GetTemplateLogoConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTemplateLogoConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTemplateLogoResponse> transformer = GetTemplateLogoConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTemplateLogoResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTemplateLogoResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTemplateLogoResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTemplateTfConfigResponse getTemplateTfConfig(GetTemplateTfConfigRequest request) {
        LOG.trace("Called getTemplateTfConfig");
        GetTemplateTfConfigRequest interceptedRequest = GetTemplateTfConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTemplateTfConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTemplateTfConfigResponse> transformer = GetTemplateTfConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTemplateTfConfigResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTemplateTfConfigResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTemplateTfConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListConfigurationSourceProvidersResponse listConfigurationSourceProviders(ListConfigurationSourceProvidersRequest request) {
        LOG.trace("Called listConfigurationSourceProviders");
        ListConfigurationSourceProvidersRequest interceptedRequest = ListConfigurationSourceProvidersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConfigurationSourceProvidersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConfigurationSourceProvidersResponse> transformer = ListConfigurationSourceProvidersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListConfigurationSourceProvidersResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListConfigurationSourceProvidersResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListConfigurationSourceProvidersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) {
        LOG.trace("Called listJobs");
        ListJobsRequest interceptedRequest = ListJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobsResponse> transformer = ListJobsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListJobsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListResourceDiscoveryServicesResponse listResourceDiscoveryServices(ListResourceDiscoveryServicesRequest request) {
        LOG.trace("Called listResourceDiscoveryServices");
        ListResourceDiscoveryServicesRequest interceptedRequest = ListResourceDiscoveryServicesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListResourceDiscoveryServicesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListResourceDiscoveryServicesResponse> transformer = ListResourceDiscoveryServicesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListResourceDiscoveryServicesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListResourceDiscoveryServicesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListResourceDiscoveryServicesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListStackResourceDriftDetailsResponse listStackResourceDriftDetails(ListStackResourceDriftDetailsRequest request) {
        LOG.trace("Called listStackResourceDriftDetails");
        ListStackResourceDriftDetailsRequest interceptedRequest = ListStackResourceDriftDetailsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStackResourceDriftDetailsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStackResourceDriftDetailsResponse> transformer = ListStackResourceDriftDetailsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListStackResourceDriftDetailsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListStackResourceDriftDetailsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ListStackResourceDriftDetailsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListStacksResponse listStacks(ListStacksRequest request) {
        LOG.trace("Called listStacks");
        ListStacksRequest interceptedRequest = ListStacksConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStacksConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStacksResponse> transformer = ListStacksConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListStacksResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListStacksResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListStacksResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTemplateCategoriesResponse listTemplateCategories(ListTemplateCategoriesRequest request) {
        LOG.trace("Called listTemplateCategories");
        ListTemplateCategoriesRequest interceptedRequest = ListTemplateCategoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTemplateCategoriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTemplateCategoriesResponse> transformer = ListTemplateCategoriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTemplateCategoriesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTemplateCategoriesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTemplateCategoriesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTemplatesResponse listTemplates(ListTemplatesRequest request) {
        LOG.trace("Called listTemplates");
        ListTemplatesRequest interceptedRequest = ListTemplatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTemplatesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTemplatesResponse> transformer = ListTemplatesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTemplatesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTemplatesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTemplatesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTerraformVersionsResponse listTerraformVersions(ListTerraformVersionsRequest request) {
        LOG.trace("Called listTerraformVersions");
        ListTerraformVersionsRequest interceptedRequest = ListTerraformVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTerraformVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTerraformVersionsResponse> transformer = ListTerraformVersionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTerraformVersionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTerraformVersionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTerraformVersionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateConfigurationSourceProviderResponse updateConfigurationSourceProvider(UpdateConfigurationSourceProviderRequest request) {
        LOG.trace("Called updateConfigurationSourceProvider");
        UpdateConfigurationSourceProviderRequest interceptedRequest = UpdateConfigurationSourceProviderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConfigurationSourceProviderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateConfigurationSourceProviderResponse> transformer = UpdateConfigurationSourceProviderConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateConfigurationSourceProviderResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateConfigurationSourceProviderResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateConfigurationSourceProviderDetails(), (BmcRequest)retriedRequest);
                return (UpdateConfigurationSourceProviderResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) {
        LOG.trace("Called updateJob");
        UpdateJobRequest interceptedRequest = UpdateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateJobResponse> transformer = UpdateJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateJobResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateJobResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateJobDetails(), (BmcRequest)retriedRequest);
                return (UpdateJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateStackResponse updateStack(UpdateStackRequest request) {
        LOG.trace("Called updateStack");
        UpdateStackRequest interceptedRequest = UpdateStackConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStackConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateStackResponse> transformer = UpdateStackConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateStackResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateStackResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateStackDetails(), (BmcRequest)retriedRequest);
                return (UpdateStackResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTemplateResponse updateTemplate(UpdateTemplateRequest request) {
        LOG.trace("Called updateTemplate");
        UpdateTemplateRequest interceptedRequest = UpdateTemplateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTemplateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTemplateResponse> transformer = UpdateTemplateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTemplateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTemplateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTemplateDetails(), (BmcRequest)retriedRequest);
                return (UpdateTemplateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ResourceManagerWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ResourceManagerPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ResourceManagerClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ResourceManagerClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ResourceManagerClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

