/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.resourcemanager.requests.GetTemplateLogoRequest;
import com.oracle.bmc.resourcemanager.responses.GetTemplateLogoResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTemplateLogoConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetTemplateLogoConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetTemplateLogoRequest interceptRequest(GetTemplateLogoRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetTemplateLogoRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getTemplateId(), (String)"templateId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180917").path("templates").path(HttpUtils.encodePathSegment((String)request.getTemplateId())).path("logo");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"image/png"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetTemplateLogoResponse> fromResponse() {
        Function<Response, GetTemplateLogoResponse> transformer = new Function<Response, GetTemplateLogoResponse>(){

            public GetTemplateLogoResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.resourcemanager.responses.GetTemplateLogoResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetTemplateLogoResponse.Builder builder = GetTemplateLogoResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.inputStream((InputStream)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetTemplateLogoResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

