/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetStackTfConfigRequest
extends BmcRequest<Void> {
    private String stackId;
    private String opcRequestId;

    @ConstructorProperties(value={"stackId", "opcRequestId"})
    GetStackTfConfigRequest(String stackId, String opcRequestId) {
        this.stackId = stackId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStackId() {
        return this.stackId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStackTfConfigRequest, Void> {
        private String stackId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStackTfConfigRequest o) {
            this.stackId(o.getStackId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStackTfConfigRequest build() {
            GetStackTfConfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetStackTfConfigRequest buildWithoutInvocationCallback() {
            return new GetStackTfConfigRequest(this.stackId, this.opcRequestId);
        }

        public String toString() {
            return "GetStackTfConfigRequest.Builder(stackId=" + this.stackId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

