/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetTemplateLogoRequest
extends BmcRequest<Void> {
    private String templateId;
    private String opcRequestId;

    @ConstructorProperties(value={"templateId", "opcRequestId"})
    GetTemplateLogoRequest(String templateId, String opcRequestId) {
        this.templateId = templateId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTemplateLogoRequest, Void> {
        private String templateId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTemplateLogoRequest o) {
            this.templateId(o.getTemplateId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTemplateLogoRequest build() {
            GetTemplateLogoRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetTemplateLogoRequest buildWithoutInvocationCallback() {
            return new GetTemplateLogoRequest(this.templateId, this.opcRequestId);
        }

        public String toString() {
            return "GetTemplateLogoRequest.Builder(templateId=" + this.templateId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

