/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.rover.RoverClusterAsync;
import com.oracle.bmc.rover.internal.http.ChangeRoverClusterCompartmentConverter;
import com.oracle.bmc.rover.internal.http.CreateRoverClusterConverter;
import com.oracle.bmc.rover.internal.http.DeleteRoverClusterConverter;
import com.oracle.bmc.rover.internal.http.GetRoverClusterCertificateConverter;
import com.oracle.bmc.rover.internal.http.GetRoverClusterConverter;
import com.oracle.bmc.rover.internal.http.ListRoverClustersConverter;
import com.oracle.bmc.rover.internal.http.UpdateRoverClusterConverter;
import com.oracle.bmc.rover.requests.ChangeRoverClusterCompartmentRequest;
import com.oracle.bmc.rover.requests.CreateRoverClusterRequest;
import com.oracle.bmc.rover.requests.DeleteRoverClusterRequest;
import com.oracle.bmc.rover.requests.GetRoverClusterCertificateRequest;
import com.oracle.bmc.rover.requests.GetRoverClusterRequest;
import com.oracle.bmc.rover.requests.ListRoverClustersRequest;
import com.oracle.bmc.rover.requests.UpdateRoverClusterRequest;
import com.oracle.bmc.rover.responses.ChangeRoverClusterCompartmentResponse;
import com.oracle.bmc.rover.responses.CreateRoverClusterResponse;
import com.oracle.bmc.rover.responses.DeleteRoverClusterResponse;
import com.oracle.bmc.rover.responses.GetRoverClusterCertificateResponse;
import com.oracle.bmc.rover.responses.GetRoverClusterResponse;
import com.oracle.bmc.rover.responses.ListRoverClustersResponse;
import com.oracle.bmc.rover.responses.UpdateRoverClusterResponse;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverClusterAsyncClient
implements RoverClusterAsync {
    private static final Logger LOG = LoggerFactory.getLogger(RoverClusterAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERCLUSTER").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public RoverClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public RoverClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public RoverClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public RoverClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public RoverClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public RoverClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public RoverClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public RoverClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeRoverClusterCompartmentResponse> changeRoverClusterCompartment(ChangeRoverClusterCompartmentRequest request, AsyncHandler<ChangeRoverClusterCompartmentRequest, ChangeRoverClusterCompartmentResponse> handler) {
        LOG.trace("Called async changeRoverClusterCompartment");
        ChangeRoverClusterCompartmentRequest interceptedRequest = ChangeRoverClusterCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeRoverClusterCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeRoverClusterCompartmentResponse> transformer = ChangeRoverClusterCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeRoverClusterCompartmentRequest, ChangeRoverClusterCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeRoverClusterCompartmentRequest, ChangeRoverClusterCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateRoverClusterResponse> createRoverCluster(CreateRoverClusterRequest request, AsyncHandler<CreateRoverClusterRequest, CreateRoverClusterResponse> handler) {
        LOG.trace("Called async createRoverCluster");
        CreateRoverClusterRequest interceptedRequest = CreateRoverClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRoverClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRoverClusterResponse> transformer = CreateRoverClusterConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateRoverClusterRequest, CreateRoverClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateRoverClusterRequest, CreateRoverClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteRoverClusterResponse> deleteRoverCluster(DeleteRoverClusterRequest request, AsyncHandler<DeleteRoverClusterRequest, DeleteRoverClusterResponse> handler) {
        LOG.trace("Called async deleteRoverCluster");
        DeleteRoverClusterRequest interceptedRequest = DeleteRoverClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRoverClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRoverClusterResponse> transformer = DeleteRoverClusterConverter.fromResponse();
        AsyncHandler<DeleteRoverClusterRequest, DeleteRoverClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteRoverClusterRequest, DeleteRoverClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRoverClusterResponse> getRoverCluster(GetRoverClusterRequest request, AsyncHandler<GetRoverClusterRequest, GetRoverClusterResponse> handler) {
        LOG.trace("Called async getRoverCluster");
        GetRoverClusterRequest interceptedRequest = GetRoverClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverClusterResponse> transformer = GetRoverClusterConverter.fromResponse();
        AsyncHandler<GetRoverClusterRequest, GetRoverClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRoverClusterRequest, GetRoverClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRoverClusterCertificateResponse> getRoverClusterCertificate(GetRoverClusterCertificateRequest request, AsyncHandler<GetRoverClusterCertificateRequest, GetRoverClusterCertificateResponse> handler) {
        LOG.trace("Called async getRoverClusterCertificate");
        GetRoverClusterCertificateRequest interceptedRequest = GetRoverClusterCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverClusterCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverClusterCertificateResponse> transformer = GetRoverClusterCertificateConverter.fromResponse();
        AsyncHandler<GetRoverClusterCertificateRequest, GetRoverClusterCertificateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRoverClusterCertificateRequest, GetRoverClusterCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRoverClustersResponse> listRoverClusters(ListRoverClustersRequest request, AsyncHandler<ListRoverClustersRequest, ListRoverClustersResponse> handler) {
        LOG.trace("Called async listRoverClusters");
        ListRoverClustersRequest interceptedRequest = ListRoverClustersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRoverClustersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRoverClustersResponse> transformer = ListRoverClustersConverter.fromResponse();
        AsyncHandler<ListRoverClustersRequest, ListRoverClustersResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRoverClustersRequest, ListRoverClustersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateRoverClusterResponse> updateRoverCluster(UpdateRoverClusterRequest request, AsyncHandler<UpdateRoverClusterRequest, UpdateRoverClusterResponse> handler) {
        LOG.trace("Called async updateRoverCluster");
        UpdateRoverClusterRequest interceptedRequest = UpdateRoverClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRoverClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRoverClusterResponse> transformer = UpdateRoverClusterConverter.fromResponse();
        AsyncHandler<UpdateRoverClusterRequest, UpdateRoverClusterResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateRoverClusterRequest, UpdateRoverClusterResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverClusterAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public RoverClusterAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new RoverClusterAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

