/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.rover.RoverCluster;
import com.oracle.bmc.rover.model.LifecycleState;
import com.oracle.bmc.rover.requests.GetRoverClusterRequest;
import com.oracle.bmc.rover.responses.GetRoverClusterResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class RoverClusterWaiters {
    private final ExecutorService executorService;
    private final RoverCluster client;

    public Waiter<GetRoverClusterRequest, GetRoverClusterResponse> forRoverCluster(GetRoverClusterRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRoverCluster(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRoverClusterRequest, GetRoverClusterResponse> forRoverCluster(GetRoverClusterRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRoverCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRoverClusterRequest, GetRoverClusterResponse> forRoverCluster(GetRoverClusterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRoverCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRoverClusterRequest, GetRoverClusterResponse> forRoverCluster(BmcGenericWaiter waiter, GetRoverClusterRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetRoverClusterRequest, GetRoverClusterResponse>(){

            public GetRoverClusterResponse apply(GetRoverClusterRequest request) {
                return RoverClusterWaiters.this.client.getRoverCluster(request);
            }
        }, (Predicate)new Predicate<GetRoverClusterResponse>(){

            public boolean apply(GetRoverClusterResponse response) {
                return targetStatesSet.contains((Object)response.getRoverCluster().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public RoverClusterWaiters(ExecutorService executorService, RoverCluster client) {
        this.executorService = executorService;
        this.client = client;
    }
}

