/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.rover.RoverEntitlementAsync;
import com.oracle.bmc.rover.internal.http.ChangeRoverEntitlementCompartmentConverter;
import com.oracle.bmc.rover.internal.http.CreateRoverEntitlementConverter;
import com.oracle.bmc.rover.internal.http.DeleteRoverEntitlementConverter;
import com.oracle.bmc.rover.internal.http.GetRoverEntitlementConverter;
import com.oracle.bmc.rover.internal.http.ListRoverEntitlementsConverter;
import com.oracle.bmc.rover.internal.http.UpdateRoverEntitlementConverter;
import com.oracle.bmc.rover.requests.ChangeRoverEntitlementCompartmentRequest;
import com.oracle.bmc.rover.requests.CreateRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.DeleteRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.GetRoverEntitlementRequest;
import com.oracle.bmc.rover.requests.ListRoverEntitlementsRequest;
import com.oracle.bmc.rover.requests.UpdateRoverEntitlementRequest;
import com.oracle.bmc.rover.responses.ChangeRoverEntitlementCompartmentResponse;
import com.oracle.bmc.rover.responses.CreateRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.DeleteRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.GetRoverEntitlementResponse;
import com.oracle.bmc.rover.responses.ListRoverEntitlementsResponse;
import com.oracle.bmc.rover.responses.UpdateRoverEntitlementResponse;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverEntitlementAsyncClient
implements RoverEntitlementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(RoverEntitlementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERENTITLEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public RoverEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public RoverEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public RoverEntitlementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public RoverEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public RoverEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public RoverEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public RoverEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public RoverEntitlementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeRoverEntitlementCompartmentResponse> changeRoverEntitlementCompartment(ChangeRoverEntitlementCompartmentRequest request, AsyncHandler<ChangeRoverEntitlementCompartmentRequest, ChangeRoverEntitlementCompartmentResponse> handler) {
        LOG.trace("Called async changeRoverEntitlementCompartment");
        ChangeRoverEntitlementCompartmentRequest interceptedRequest = ChangeRoverEntitlementCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeRoverEntitlementCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeRoverEntitlementCompartmentResponse> transformer = ChangeRoverEntitlementCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeRoverEntitlementCompartmentRequest, ChangeRoverEntitlementCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeRoverEntitlementCompartmentRequest, ChangeRoverEntitlementCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateRoverEntitlementResponse> createRoverEntitlement(CreateRoverEntitlementRequest request, AsyncHandler<CreateRoverEntitlementRequest, CreateRoverEntitlementResponse> handler) {
        LOG.trace("Called async createRoverEntitlement");
        CreateRoverEntitlementRequest interceptedRequest = CreateRoverEntitlementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRoverEntitlementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRoverEntitlementResponse> transformer = CreateRoverEntitlementConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateRoverEntitlementRequest, CreateRoverEntitlementResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateRoverEntitlementRequest, CreateRoverEntitlementResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteRoverEntitlementResponse> deleteRoverEntitlement(DeleteRoverEntitlementRequest request, AsyncHandler<DeleteRoverEntitlementRequest, DeleteRoverEntitlementResponse> handler) {
        LOG.trace("Called async deleteRoverEntitlement");
        DeleteRoverEntitlementRequest interceptedRequest = DeleteRoverEntitlementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRoverEntitlementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRoverEntitlementResponse> transformer = DeleteRoverEntitlementConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<DeleteRoverEntitlementRequest, DeleteRoverEntitlementResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteRoverEntitlementRequest, DeleteRoverEntitlementResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRoverEntitlementResponse> getRoverEntitlement(GetRoverEntitlementRequest request, AsyncHandler<GetRoverEntitlementRequest, GetRoverEntitlementResponse> handler) {
        LOG.trace("Called async getRoverEntitlement");
        GetRoverEntitlementRequest interceptedRequest = GetRoverEntitlementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverEntitlementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverEntitlementResponse> transformer = GetRoverEntitlementConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<GetRoverEntitlementRequest, GetRoverEntitlementResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRoverEntitlementRequest, GetRoverEntitlementResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRoverEntitlementsResponse> listRoverEntitlements(ListRoverEntitlementsRequest request, AsyncHandler<ListRoverEntitlementsRequest, ListRoverEntitlementsResponse> handler) {
        LOG.trace("Called async listRoverEntitlements");
        ListRoverEntitlementsRequest interceptedRequest = ListRoverEntitlementsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRoverEntitlementsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRoverEntitlementsResponse> transformer = ListRoverEntitlementsConverter.fromResponse();
        AsyncHandler<ListRoverEntitlementsRequest, ListRoverEntitlementsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRoverEntitlementsRequest, ListRoverEntitlementsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateRoverEntitlementResponse> updateRoverEntitlement(UpdateRoverEntitlementRequest request, AsyncHandler<UpdateRoverEntitlementRequest, UpdateRoverEntitlementResponse> handler) {
        LOG.trace("Called async updateRoverEntitlement");
        UpdateRoverEntitlementRequest interceptedRequest = UpdateRoverEntitlementConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRoverEntitlementConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRoverEntitlementResponse> transformer = UpdateRoverEntitlementConverter.fromResponse();
        AsyncHandler<UpdateRoverEntitlementRequest, UpdateRoverEntitlementResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateRoverEntitlementRequest, UpdateRoverEntitlementResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverEntitlementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public RoverEntitlementAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new RoverEntitlementAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

