/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.rover.RoverEntitlement;
import com.oracle.bmc.rover.model.RoverEntitlementSummary;
import com.oracle.bmc.rover.requests.ListRoverEntitlementsRequest;
import com.oracle.bmc.rover.responses.ListRoverEntitlementsResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class RoverEntitlementPaginators {
    private final RoverEntitlement client;

    public Iterable<ListRoverEntitlementsResponse> listRoverEntitlementsResponseIterator(final ListRoverEntitlementsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRoverEntitlementsRequest.Builder>(){

            public ListRoverEntitlementsRequest.Builder get() {
                return ListRoverEntitlementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverEntitlementsResponse, String>(){

            public String apply(ListRoverEntitlementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverEntitlementsRequest.Builder>, ListRoverEntitlementsRequest>(){

            public ListRoverEntitlementsRequest apply(RequestBuilderAndToken<ListRoverEntitlementsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRoverEntitlementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverEntitlementsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRoverEntitlementsRequest, ListRoverEntitlementsResponse>(){

            public ListRoverEntitlementsResponse apply(ListRoverEntitlementsRequest request) {
                return RoverEntitlementPaginators.this.client.listRoverEntitlements(request);
            }
        });
    }

    public Iterable<RoverEntitlementSummary> listRoverEntitlementsRecordIterator(final ListRoverEntitlementsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRoverEntitlementsRequest.Builder>(){

            public ListRoverEntitlementsRequest.Builder get() {
                return ListRoverEntitlementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverEntitlementsResponse, String>(){

            public String apply(ListRoverEntitlementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverEntitlementsRequest.Builder>, ListRoverEntitlementsRequest>(){

            public ListRoverEntitlementsRequest apply(RequestBuilderAndToken<ListRoverEntitlementsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRoverEntitlementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverEntitlementsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRoverEntitlementsRequest, ListRoverEntitlementsResponse>(){

            public ListRoverEntitlementsResponse apply(ListRoverEntitlementsRequest request) {
                return RoverEntitlementPaginators.this.client.listRoverEntitlements(request);
            }
        }, (Function)new Function<ListRoverEntitlementsResponse, List<RoverEntitlementSummary>>(){

            public List<RoverEntitlementSummary> apply(ListRoverEntitlementsResponse response) {
                return response.getRoverEntitlementCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public RoverEntitlementPaginators(RoverEntitlement client) {
        this.client = client;
    }
}

