/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.rover.RoverNodeAsync;
import com.oracle.bmc.rover.internal.http.ChangeRoverNodeCompartmentConverter;
import com.oracle.bmc.rover.internal.http.CreateRoverNodeConverter;
import com.oracle.bmc.rover.internal.http.DeleteRoverNodeConverter;
import com.oracle.bmc.rover.internal.http.GetRoverNodeCertificateConverter;
import com.oracle.bmc.rover.internal.http.GetRoverNodeConverter;
import com.oracle.bmc.rover.internal.http.GetRoverNodeEncryptionKeyConverter;
import com.oracle.bmc.rover.internal.http.GetRoverNodeGetRptConverter;
import com.oracle.bmc.rover.internal.http.ListRoverNodesConverter;
import com.oracle.bmc.rover.internal.http.RoverNodeActionSetKeyConverter;
import com.oracle.bmc.rover.internal.http.UpdateRoverNodeConverter;
import com.oracle.bmc.rover.requests.ChangeRoverNodeCompartmentRequest;
import com.oracle.bmc.rover.requests.CreateRoverNodeRequest;
import com.oracle.bmc.rover.requests.DeleteRoverNodeRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeCertificateRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeEncryptionKeyRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeGetRptRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeRequest;
import com.oracle.bmc.rover.requests.ListRoverNodesRequest;
import com.oracle.bmc.rover.requests.RoverNodeActionSetKeyRequest;
import com.oracle.bmc.rover.requests.UpdateRoverNodeRequest;
import com.oracle.bmc.rover.responses.ChangeRoverNodeCompartmentResponse;
import com.oracle.bmc.rover.responses.CreateRoverNodeResponse;
import com.oracle.bmc.rover.responses.DeleteRoverNodeResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeCertificateResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeEncryptionKeyResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeGetRptResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeResponse;
import com.oracle.bmc.rover.responses.ListRoverNodesResponse;
import com.oracle.bmc.rover.responses.RoverNodeActionSetKeyResponse;
import com.oracle.bmc.rover.responses.UpdateRoverNodeResponse;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverNodeAsyncClient
implements RoverNodeAsync {
    private static final Logger LOG = LoggerFactory.getLogger(RoverNodeAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERNODE").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public RoverNodeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public RoverNodeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public RoverNodeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public RoverNodeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public RoverNodeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public RoverNodeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public RoverNodeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public RoverNodeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeRoverNodeCompartmentResponse> changeRoverNodeCompartment(ChangeRoverNodeCompartmentRequest request, AsyncHandler<ChangeRoverNodeCompartmentRequest, ChangeRoverNodeCompartmentResponse> handler) {
        LOG.trace("Called async changeRoverNodeCompartment");
        ChangeRoverNodeCompartmentRequest interceptedRequest = ChangeRoverNodeCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeRoverNodeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeRoverNodeCompartmentResponse> transformer = ChangeRoverNodeCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeRoverNodeCompartmentRequest, ChangeRoverNodeCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeRoverNodeCompartmentRequest, ChangeRoverNodeCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateRoverNodeResponse> createRoverNode(CreateRoverNodeRequest request, AsyncHandler<CreateRoverNodeRequest, CreateRoverNodeResponse> handler) {
        LOG.trace("Called async createRoverNode");
        CreateRoverNodeRequest interceptedRequest = CreateRoverNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRoverNodeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRoverNodeResponse> transformer = CreateRoverNodeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateRoverNodeRequest, CreateRoverNodeResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateRoverNodeRequest, CreateRoverNodeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteRoverNodeResponse> deleteRoverNode(DeleteRoverNodeRequest request, AsyncHandler<DeleteRoverNodeRequest, DeleteRoverNodeResponse> handler) {
        LOG.trace("Called async deleteRoverNode");
        DeleteRoverNodeRequest interceptedRequest = DeleteRoverNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRoverNodeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRoverNodeResponse> transformer = DeleteRoverNodeConverter.fromResponse();
        AsyncHandler<DeleteRoverNodeRequest, DeleteRoverNodeResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteRoverNodeRequest, DeleteRoverNodeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRoverNodeResponse> getRoverNode(GetRoverNodeRequest request, AsyncHandler<GetRoverNodeRequest, GetRoverNodeResponse> handler) {
        LOG.trace("Called async getRoverNode");
        GetRoverNodeRequest interceptedRequest = GetRoverNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverNodeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverNodeResponse> transformer = GetRoverNodeConverter.fromResponse();
        AsyncHandler<GetRoverNodeRequest, GetRoverNodeResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRoverNodeRequest, GetRoverNodeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRoverNodeCertificateResponse> getRoverNodeCertificate(GetRoverNodeCertificateRequest request, AsyncHandler<GetRoverNodeCertificateRequest, GetRoverNodeCertificateResponse> handler) {
        LOG.trace("Called async getRoverNodeCertificate");
        GetRoverNodeCertificateRequest interceptedRequest = GetRoverNodeCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverNodeCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverNodeCertificateResponse> transformer = GetRoverNodeCertificateConverter.fromResponse();
        AsyncHandler<GetRoverNodeCertificateRequest, GetRoverNodeCertificateResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRoverNodeCertificateRequest, GetRoverNodeCertificateResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRoverNodeEncryptionKeyResponse> getRoverNodeEncryptionKey(GetRoverNodeEncryptionKeyRequest request, AsyncHandler<GetRoverNodeEncryptionKeyRequest, GetRoverNodeEncryptionKeyResponse> handler) {
        LOG.trace("Called async getRoverNodeEncryptionKey");
        GetRoverNodeEncryptionKeyRequest interceptedRequest = GetRoverNodeEncryptionKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverNodeEncryptionKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverNodeEncryptionKeyResponse> transformer = GetRoverNodeEncryptionKeyConverter.fromResponse();
        AsyncHandler<GetRoverNodeEncryptionKeyRequest, GetRoverNodeEncryptionKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRoverNodeEncryptionKeyRequest, GetRoverNodeEncryptionKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRoverNodeGetRptResponse> getRoverNodeGetRpt(GetRoverNodeGetRptRequest request, AsyncHandler<GetRoverNodeGetRptRequest, GetRoverNodeGetRptResponse> handler) {
        LOG.trace("Called async getRoverNodeGetRpt");
        GetRoverNodeGetRptRequest interceptedRequest = GetRoverNodeGetRptConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverNodeGetRptConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverNodeGetRptResponse> transformer = GetRoverNodeGetRptConverter.fromResponse();
        AsyncHandler<GetRoverNodeGetRptRequest, GetRoverNodeGetRptResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRoverNodeGetRptRequest, GetRoverNodeGetRptResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRoverNodesResponse> listRoverNodes(ListRoverNodesRequest request, AsyncHandler<ListRoverNodesRequest, ListRoverNodesResponse> handler) {
        LOG.trace("Called async listRoverNodes");
        ListRoverNodesRequest interceptedRequest = ListRoverNodesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRoverNodesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRoverNodesResponse> transformer = ListRoverNodesConverter.fromResponse();
        AsyncHandler<ListRoverNodesRequest, ListRoverNodesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRoverNodesRequest, ListRoverNodesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RoverNodeActionSetKeyResponse> roverNodeActionSetKey(RoverNodeActionSetKeyRequest request, AsyncHandler<RoverNodeActionSetKeyRequest, RoverNodeActionSetKeyResponse> handler) {
        LOG.trace("Called async roverNodeActionSetKey");
        RoverNodeActionSetKeyRequest interceptedRequest = RoverNodeActionSetKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RoverNodeActionSetKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RoverNodeActionSetKeyResponse> transformer = RoverNodeActionSetKeyConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RoverNodeActionSetKeyRequest, RoverNodeActionSetKeyResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RoverNodeActionSetKeyRequest, RoverNodeActionSetKeyResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateRoverNodeResponse> updateRoverNode(UpdateRoverNodeRequest request, AsyncHandler<UpdateRoverNodeRequest, UpdateRoverNodeResponse> handler) {
        LOG.trace("Called async updateRoverNode");
        UpdateRoverNodeRequest interceptedRequest = UpdateRoverNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRoverNodeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRoverNodeResponse> transformer = UpdateRoverNodeConverter.fromResponse();
        AsyncHandler<UpdateRoverNodeRequest, UpdateRoverNodeResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateRoverNodeRequest, UpdateRoverNodeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverNodeAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public RoverNodeAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new RoverNodeAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

