/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.rover.RoverNode;
import com.oracle.bmc.rover.RoverNodePaginators;
import com.oracle.bmc.rover.RoverNodeWaiters;
import com.oracle.bmc.rover.internal.http.ChangeRoverNodeCompartmentConverter;
import com.oracle.bmc.rover.internal.http.CreateRoverNodeConverter;
import com.oracle.bmc.rover.internal.http.DeleteRoverNodeConverter;
import com.oracle.bmc.rover.internal.http.GetRoverNodeCertificateConverter;
import com.oracle.bmc.rover.internal.http.GetRoverNodeConverter;
import com.oracle.bmc.rover.internal.http.GetRoverNodeEncryptionKeyConverter;
import com.oracle.bmc.rover.internal.http.GetRoverNodeGetRptConverter;
import com.oracle.bmc.rover.internal.http.ListRoverNodesConverter;
import com.oracle.bmc.rover.internal.http.RoverNodeActionSetKeyConverter;
import com.oracle.bmc.rover.internal.http.UpdateRoverNodeConverter;
import com.oracle.bmc.rover.requests.ChangeRoverNodeCompartmentRequest;
import com.oracle.bmc.rover.requests.CreateRoverNodeRequest;
import com.oracle.bmc.rover.requests.DeleteRoverNodeRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeCertificateRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeEncryptionKeyRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeGetRptRequest;
import com.oracle.bmc.rover.requests.GetRoverNodeRequest;
import com.oracle.bmc.rover.requests.ListRoverNodesRequest;
import com.oracle.bmc.rover.requests.RoverNodeActionSetKeyRequest;
import com.oracle.bmc.rover.requests.UpdateRoverNodeRequest;
import com.oracle.bmc.rover.responses.ChangeRoverNodeCompartmentResponse;
import com.oracle.bmc.rover.responses.CreateRoverNodeResponse;
import com.oracle.bmc.rover.responses.DeleteRoverNodeResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeCertificateResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeEncryptionKeyResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeGetRptResponse;
import com.oracle.bmc.rover.responses.GetRoverNodeResponse;
import com.oracle.bmc.rover.responses.ListRoverNodesResponse;
import com.oracle.bmc.rover.responses.RoverNodeActionSetKeyResponse;
import com.oracle.bmc.rover.responses.UpdateRoverNodeResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverNodeClient
implements RoverNode {
    private static final Logger LOG = LoggerFactory.getLogger(RoverNodeClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERNODE").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final RoverNodeWaiters waiters;
    private final RoverNodePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public RoverNodeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public RoverNodeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public RoverNodeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public RoverNodeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public RoverNodeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public RoverNodeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public RoverNodeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public RoverNodeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected RoverNodeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("RoverNode-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new RoverNodeWaiters(executorService, this);
        this.paginators = new RoverNodePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeRoverNodeCompartmentResponse changeRoverNodeCompartment(ChangeRoverNodeCompartmentRequest request) {
        LOG.trace("Called changeRoverNodeCompartment");
        ChangeRoverNodeCompartmentRequest interceptedRequest = ChangeRoverNodeCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeRoverNodeCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeRoverNodeCompartmentResponse> transformer = ChangeRoverNodeCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeRoverNodeCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeRoverNodeCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeRoverNodeCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeRoverNodeCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateRoverNodeResponse createRoverNode(CreateRoverNodeRequest request) {
        LOG.trace("Called createRoverNode");
        CreateRoverNodeRequest interceptedRequest = CreateRoverNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRoverNodeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRoverNodeResponse> transformer = CreateRoverNodeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateRoverNodeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateRoverNodeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateRoverNodeDetails(), (BmcRequest)retriedRequest);
                return (CreateRoverNodeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteRoverNodeResponse deleteRoverNode(DeleteRoverNodeRequest request) {
        LOG.trace("Called deleteRoverNode");
        DeleteRoverNodeRequest interceptedRequest = DeleteRoverNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRoverNodeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRoverNodeResponse> transformer = DeleteRoverNodeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteRoverNodeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteRoverNodeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteRoverNodeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRoverNodeResponse getRoverNode(GetRoverNodeRequest request) {
        LOG.trace("Called getRoverNode");
        GetRoverNodeRequest interceptedRequest = GetRoverNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverNodeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverNodeResponse> transformer = GetRoverNodeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRoverNodeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRoverNodeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRoverNodeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRoverNodeCertificateResponse getRoverNodeCertificate(GetRoverNodeCertificateRequest request) {
        LOG.trace("Called getRoverNodeCertificate");
        GetRoverNodeCertificateRequest interceptedRequest = GetRoverNodeCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverNodeCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverNodeCertificateResponse> transformer = GetRoverNodeCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRoverNodeCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRoverNodeCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRoverNodeCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRoverNodeEncryptionKeyResponse getRoverNodeEncryptionKey(GetRoverNodeEncryptionKeyRequest request) {
        LOG.trace("Called getRoverNodeEncryptionKey");
        GetRoverNodeEncryptionKeyRequest interceptedRequest = GetRoverNodeEncryptionKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverNodeEncryptionKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverNodeEncryptionKeyResponse> transformer = GetRoverNodeEncryptionKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRoverNodeEncryptionKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRoverNodeEncryptionKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRoverNodeEncryptionKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRoverNodeGetRptResponse getRoverNodeGetRpt(GetRoverNodeGetRptRequest request) {
        LOG.trace("Called getRoverNodeGetRpt");
        GetRoverNodeGetRptRequest interceptedRequest = GetRoverNodeGetRptConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRoverNodeGetRptConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRoverNodeGetRptResponse> transformer = GetRoverNodeGetRptConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRoverNodeGetRptResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRoverNodeGetRptResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRoverNodeGetRptResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRoverNodesResponse listRoverNodes(ListRoverNodesRequest request) {
        LOG.trace("Called listRoverNodes");
        ListRoverNodesRequest interceptedRequest = ListRoverNodesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRoverNodesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRoverNodesResponse> transformer = ListRoverNodesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRoverNodesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRoverNodesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRoverNodesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RoverNodeActionSetKeyResponse roverNodeActionSetKey(RoverNodeActionSetKeyRequest request) {
        LOG.trace("Called roverNodeActionSetKey");
        RoverNodeActionSetKeyRequest interceptedRequest = RoverNodeActionSetKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RoverNodeActionSetKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RoverNodeActionSetKeyResponse> transformer = RoverNodeActionSetKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RoverNodeActionSetKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RoverNodeActionSetKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRoverNodeActionSetKeyDetails(), (BmcRequest)retriedRequest);
                return (RoverNodeActionSetKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRoverNodeResponse updateRoverNode(UpdateRoverNodeRequest request) {
        LOG.trace("Called updateRoverNode");
        UpdateRoverNodeRequest interceptedRequest = UpdateRoverNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRoverNodeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRoverNodeResponse> transformer = UpdateRoverNodeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateRoverNodeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateRoverNodeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateRoverNodeDetails(), (BmcRequest)retriedRequest);
                return (UpdateRoverNodeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RoverNodeWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public RoverNodePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverNodeClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RoverNodeClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new RoverNodeClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

