/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.rover.model.RoverNodeCertificate;
import com.oracle.bmc.rover.requests.GetRoverNodeCertificateRequest;
import com.oracle.bmc.rover.responses.GetRoverNodeCertificateResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRoverNodeCertificateConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetRoverNodeCertificateConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetRoverNodeCertificateRequest interceptRequest(GetRoverNodeCertificateRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetRoverNodeCertificateRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRoverNodeId(), (String)"roverNodeId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20201210").path("roverNodes").path(HttpUtils.encodePathSegment((String)request.getRoverNodeId())).path("certificate");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetRoverNodeCertificateResponse> fromResponse() {
        Function<Response, GetRoverNodeCertificateResponse> transformer = new Function<Response, GetRoverNodeCertificateResponse>(){

            public GetRoverNodeCertificateResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.rover.responses.GetRoverNodeCertificateResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(RoverNodeCertificate.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetRoverNodeCertificateResponse.Builder builder = GetRoverNodeCertificateResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.roverNodeCertificate((RoverNodeCertificate)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetRoverNodeCertificateResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

