/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetRoverEntitlementRequest
extends BmcRequest<Void> {
    private String roverEntitlementId;
    private String compartmentId;
    private String opcRetryToken;
    private String opcRequestId;

    @ConstructorProperties(value={"roverEntitlementId", "compartmentId", "opcRetryToken", "opcRequestId"})
    GetRoverEntitlementRequest(String roverEntitlementId, String compartmentId, String opcRetryToken, String opcRequestId) {
        this.roverEntitlementId = roverEntitlementId;
        this.compartmentId = compartmentId;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRoverEntitlementId() {
        return this.roverEntitlementId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRoverEntitlementRequest, Void> {
        private String roverEntitlementId;
        private String compartmentId;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRoverEntitlementRequest o) {
            this.roverEntitlementId(o.getRoverEntitlementId());
            this.compartmentId(o.getCompartmentId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRoverEntitlementRequest build() {
            GetRoverEntitlementRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder roverEntitlementId(String roverEntitlementId) {
            this.roverEntitlementId = roverEntitlementId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetRoverEntitlementRequest buildWithoutInvocationCallback() {
            return new GetRoverEntitlementRequest(this.roverEntitlementId, this.compartmentId, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "GetRoverEntitlementRequest.Builder(roverEntitlementId=" + this.roverEntitlementId + ", compartmentId=" + this.compartmentId + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

