/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.oracle.bmc.Service;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.streaming.model.Stream;
import com.oracle.bmc.streaming.model.StreamSummary;

public abstract class AbstractStreamBasedClientBuilder<B extends AbstractStreamBasedClientBuilder, C>
extends ClientBuilderBase<B, C> {
    protected Stream stream = null;
    protected StreamSummary streamSummary = null;

    public B stream(Stream stream) {
        this.stream = stream;
        return (B)((Object)this);
    }

    public B streamSummary(StreamSummary streamSummary) {
        this.streamSummary = streamSummary;
        return (B)((Object)this);
    }

    public AbstractStreamBasedClientBuilder(Service service) {
        super(service);
    }

    protected String getEndpoint() {
        String streamEndpoint = null;
        int endpointsProvided = 0;
        if (this.stream != null) {
            ++endpointsProvided;
        }
        if (this.streamSummary != null) {
            ++endpointsProvided;
        }
        if (this.endpoint != null) {
            ++endpointsProvided;
        }
        if (endpointsProvided != 1) {
            throw new IllegalArgumentException("Must provide exactly one of stream, stream summary, or endpoint");
        }
        if (this.stream != null) {
            streamEndpoint = this.stream.getMessagesEndpoint();
        }
        if (this.streamSummary != null) {
            streamEndpoint = this.streamSummary.getMessagesEndpoint();
        }
        if (this.endpoint != null) {
            streamEndpoint = this.endpoint;
        }
        return streamEndpoint;
    }
}

