/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.streaming.StreamAdminAsync;
import com.oracle.bmc.streaming.internal.http.ChangeConnectHarnessCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.ChangeStreamCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.ChangeStreamPoolCompartmentConverter;
import com.oracle.bmc.streaming.internal.http.CreateConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.CreateStreamConverter;
import com.oracle.bmc.streaming.internal.http.CreateStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.DeleteConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.DeleteStreamConverter;
import com.oracle.bmc.streaming.internal.http.DeleteStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.GetConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.GetStreamConverter;
import com.oracle.bmc.streaming.internal.http.GetStreamPoolConverter;
import com.oracle.bmc.streaming.internal.http.ListConnectHarnessesConverter;
import com.oracle.bmc.streaming.internal.http.ListStreamPoolsConverter;
import com.oracle.bmc.streaming.internal.http.ListStreamsConverter;
import com.oracle.bmc.streaming.internal.http.UpdateConnectHarnessConverter;
import com.oracle.bmc.streaming.internal.http.UpdateStreamConverter;
import com.oracle.bmc.streaming.internal.http.UpdateStreamPoolConverter;
import com.oracle.bmc.streaming.requests.ChangeConnectHarnessCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamCompartmentRequest;
import com.oracle.bmc.streaming.requests.ChangeStreamPoolCompartmentRequest;
import com.oracle.bmc.streaming.requests.CreateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.CreateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.CreateStreamRequest;
import com.oracle.bmc.streaming.requests.DeleteConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamPoolRequest;
import com.oracle.bmc.streaming.requests.DeleteStreamRequest;
import com.oracle.bmc.streaming.requests.GetConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.GetStreamPoolRequest;
import com.oracle.bmc.streaming.requests.GetStreamRequest;
import com.oracle.bmc.streaming.requests.ListConnectHarnessesRequest;
import com.oracle.bmc.streaming.requests.ListStreamPoolsRequest;
import com.oracle.bmc.streaming.requests.ListStreamsRequest;
import com.oracle.bmc.streaming.requests.UpdateConnectHarnessRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamPoolRequest;
import com.oracle.bmc.streaming.requests.UpdateStreamRequest;
import com.oracle.bmc.streaming.responses.ChangeConnectHarnessCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamCompartmentResponse;
import com.oracle.bmc.streaming.responses.ChangeStreamPoolCompartmentResponse;
import com.oracle.bmc.streaming.responses.CreateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.CreateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.CreateStreamResponse;
import com.oracle.bmc.streaming.responses.DeleteConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamPoolResponse;
import com.oracle.bmc.streaming.responses.DeleteStreamResponse;
import com.oracle.bmc.streaming.responses.GetConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.GetStreamPoolResponse;
import com.oracle.bmc.streaming.responses.GetStreamResponse;
import com.oracle.bmc.streaming.responses.ListConnectHarnessesResponse;
import com.oracle.bmc.streaming.responses.ListStreamPoolsResponse;
import com.oracle.bmc.streaming.responses.ListStreamsResponse;
import com.oracle.bmc.streaming.responses.UpdateConnectHarnessResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamPoolResponse;
import com.oracle.bmc.streaming.responses.UpdateStreamResponse;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAdminAsyncClient
implements StreamAdminAsync {
    private static final Logger LOG = LoggerFactory.getLogger(StreamAdminAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("STREAMADMIN").serviceEndpointPrefix("streams").serviceEndpointTemplate("https://streaming.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public StreamAdminAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public StreamAdminAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeConnectHarnessCompartmentResponse> changeConnectHarnessCompartment(ChangeConnectHarnessCompartmentRequest request, AsyncHandler<ChangeConnectHarnessCompartmentRequest, ChangeConnectHarnessCompartmentResponse> handler) {
        LOG.trace("Called async changeConnectHarnessCompartment");
        ChangeConnectHarnessCompartmentRequest interceptedRequest = ChangeConnectHarnessCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeConnectHarnessCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeConnectHarnessCompartmentResponse> transformer = ChangeConnectHarnessCompartmentConverter.fromResponse();
        AsyncHandler<ChangeConnectHarnessCompartmentRequest, ChangeConnectHarnessCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeConnectHarnessCompartmentRequest, ChangeConnectHarnessCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeStreamCompartmentResponse> changeStreamCompartment(ChangeStreamCompartmentRequest request, AsyncHandler<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse> handler) {
        LOG.trace("Called async changeStreamCompartment");
        ChangeStreamCompartmentRequest interceptedRequest = ChangeStreamCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStreamCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeStreamCompartmentResponse> transformer = ChangeStreamCompartmentConverter.fromResponse();
        AsyncHandler<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeStreamCompartmentRequest, ChangeStreamCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeStreamPoolCompartmentResponse> changeStreamPoolCompartment(ChangeStreamPoolCompartmentRequest request, AsyncHandler<ChangeStreamPoolCompartmentRequest, ChangeStreamPoolCompartmentResponse> handler) {
        LOG.trace("Called async changeStreamPoolCompartment");
        ChangeStreamPoolCompartmentRequest interceptedRequest = ChangeStreamPoolCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeStreamPoolCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeStreamPoolCompartmentResponse> transformer = ChangeStreamPoolCompartmentConverter.fromResponse();
        AsyncHandler<ChangeStreamPoolCompartmentRequest, ChangeStreamPoolCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeStreamPoolCompartmentRequest, ChangeStreamPoolCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateConnectHarnessResponse> createConnectHarness(CreateConnectHarnessRequest request, AsyncHandler<CreateConnectHarnessRequest, CreateConnectHarnessResponse> handler) {
        LOG.trace("Called async createConnectHarness");
        CreateConnectHarnessRequest interceptedRequest = CreateConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateConnectHarnessResponse> transformer = CreateConnectHarnessConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateConnectHarnessRequest, CreateConnectHarnessResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateConnectHarnessRequest, CreateConnectHarnessResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateStreamResponse> createStream(CreateStreamRequest request, AsyncHandler<CreateStreamRequest, CreateStreamResponse> handler) {
        LOG.trace("Called async createStream");
        CreateStreamRequest interceptedRequest = CreateStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateStreamResponse> transformer = CreateStreamConverter.fromResponse();
        AsyncHandler<CreateStreamRequest, CreateStreamResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateStreamRequest, CreateStreamResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateStreamPoolResponse> createStreamPool(CreateStreamPoolRequest request, AsyncHandler<CreateStreamPoolRequest, CreateStreamPoolResponse> handler) {
        LOG.trace("Called async createStreamPool");
        CreateStreamPoolRequest interceptedRequest = CreateStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateStreamPoolResponse> transformer = CreateStreamPoolConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateStreamPoolRequest, CreateStreamPoolResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateStreamPoolRequest, CreateStreamPoolResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteConnectHarnessResponse> deleteConnectHarness(DeleteConnectHarnessRequest request, AsyncHandler<DeleteConnectHarnessRequest, DeleteConnectHarnessResponse> handler) {
        LOG.trace("Called async deleteConnectHarness");
        DeleteConnectHarnessRequest interceptedRequest = DeleteConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteConnectHarnessResponse> transformer = DeleteConnectHarnessConverter.fromResponse();
        AsyncHandler<DeleteConnectHarnessRequest, DeleteConnectHarnessResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteConnectHarnessRequest, DeleteConnectHarnessResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteStreamResponse> deleteStream(DeleteStreamRequest request, AsyncHandler<DeleteStreamRequest, DeleteStreamResponse> handler) {
        LOG.trace("Called async deleteStream");
        DeleteStreamRequest interceptedRequest = DeleteStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteStreamResponse> transformer = DeleteStreamConverter.fromResponse();
        AsyncHandler<DeleteStreamRequest, DeleteStreamResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteStreamRequest, DeleteStreamResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteStreamPoolResponse> deleteStreamPool(DeleteStreamPoolRequest request, AsyncHandler<DeleteStreamPoolRequest, DeleteStreamPoolResponse> handler) {
        LOG.trace("Called async deleteStreamPool");
        DeleteStreamPoolRequest interceptedRequest = DeleteStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteStreamPoolResponse> transformer = DeleteStreamPoolConverter.fromResponse();
        AsyncHandler<DeleteStreamPoolRequest, DeleteStreamPoolResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteStreamPoolRequest, DeleteStreamPoolResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConnectHarnessResponse> getConnectHarness(GetConnectHarnessRequest request, AsyncHandler<GetConnectHarnessRequest, GetConnectHarnessResponse> handler) {
        LOG.trace("Called async getConnectHarness");
        GetConnectHarnessRequest interceptedRequest = GetConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetConnectHarnessResponse> transformer = GetConnectHarnessConverter.fromResponse();
        AsyncHandler<GetConnectHarnessRequest, GetConnectHarnessResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConnectHarnessRequest, GetConnectHarnessResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetStreamResponse> getStream(GetStreamRequest request, AsyncHandler<GetStreamRequest, GetStreamResponse> handler) {
        LOG.trace("Called async getStream");
        GetStreamRequest interceptedRequest = GetStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStreamResponse> transformer = GetStreamConverter.fromResponse();
        AsyncHandler<GetStreamRequest, GetStreamResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetStreamRequest, GetStreamResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetStreamPoolResponse> getStreamPool(GetStreamPoolRequest request, AsyncHandler<GetStreamPoolRequest, GetStreamPoolResponse> handler) {
        LOG.trace("Called async getStreamPool");
        GetStreamPoolRequest interceptedRequest = GetStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetStreamPoolResponse> transformer = GetStreamPoolConverter.fromResponse();
        AsyncHandler<GetStreamPoolRequest, GetStreamPoolResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetStreamPoolRequest, GetStreamPoolResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListConnectHarnessesResponse> listConnectHarnesses(ListConnectHarnessesRequest request, AsyncHandler<ListConnectHarnessesRequest, ListConnectHarnessesResponse> handler) {
        LOG.trace("Called async listConnectHarnesses");
        ListConnectHarnessesRequest interceptedRequest = ListConnectHarnessesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectHarnessesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListConnectHarnessesResponse> transformer = ListConnectHarnessesConverter.fromResponse();
        AsyncHandler<ListConnectHarnessesRequest, ListConnectHarnessesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListConnectHarnessesRequest, ListConnectHarnessesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListStreamPoolsResponse> listStreamPools(ListStreamPoolsRequest request, AsyncHandler<ListStreamPoolsRequest, ListStreamPoolsResponse> handler) {
        LOG.trace("Called async listStreamPools");
        ListStreamPoolsRequest interceptedRequest = ListStreamPoolsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStreamPoolsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStreamPoolsResponse> transformer = ListStreamPoolsConverter.fromResponse();
        AsyncHandler<ListStreamPoolsRequest, ListStreamPoolsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListStreamPoolsRequest, ListStreamPoolsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListStreamsResponse> listStreams(ListStreamsRequest request, AsyncHandler<ListStreamsRequest, ListStreamsResponse> handler) {
        LOG.trace("Called async listStreams");
        ListStreamsRequest interceptedRequest = ListStreamsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListStreamsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListStreamsResponse> transformer = ListStreamsConverter.fromResponse();
        AsyncHandler<ListStreamsRequest, ListStreamsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListStreamsRequest, ListStreamsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateConnectHarnessResponse> updateConnectHarness(UpdateConnectHarnessRequest request, AsyncHandler<UpdateConnectHarnessRequest, UpdateConnectHarnessResponse> handler) {
        LOG.trace("Called async updateConnectHarness");
        UpdateConnectHarnessRequest interceptedRequest = UpdateConnectHarnessConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConnectHarnessConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateConnectHarnessResponse> transformer = UpdateConnectHarnessConverter.fromResponse();
        AsyncHandler<UpdateConnectHarnessRequest, UpdateConnectHarnessResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateConnectHarnessRequest, UpdateConnectHarnessResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateStreamResponse> updateStream(UpdateStreamRequest request, AsyncHandler<UpdateStreamRequest, UpdateStreamResponse> handler) {
        LOG.trace("Called async updateStream");
        UpdateStreamRequest interceptedRequest = UpdateStreamConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStreamConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateStreamResponse> transformer = UpdateStreamConverter.fromResponse();
        AsyncHandler<UpdateStreamRequest, UpdateStreamResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateStreamRequest, UpdateStreamResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateStreamPoolResponse> updateStreamPool(UpdateStreamPoolRequest request, AsyncHandler<UpdateStreamPoolRequest, UpdateStreamPoolResponse> handler) {
        LOG.trace("Called async updateStreamPool");
        UpdateStreamPoolRequest interceptedRequest = UpdateStreamPoolConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateStreamPoolConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateStreamPoolResponse> transformer = UpdateStreamPoolConverter.fromResponse();
        AsyncHandler<UpdateStreamPoolRequest, UpdateStreamPoolResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateStreamPoolRequest, UpdateStreamPoolResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, StreamAdminAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public StreamAdminAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new StreamAdminAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

