/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.tenantmanagercontrolplane.model.Domain;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateDomainResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDomainConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateDomainConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateDomainRequest interceptRequest(CreateDomainRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateDomainRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateDomainDetails(), (String)"createDomainDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200801").path("domains");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, CreateDomainResponse> fromResponse() {
        Function<Response, CreateDomainResponse> transformer = new Function<Response, CreateDomainResponse>(){

            public CreateDomainResponse apply(Response rawResponse) {
                Optional etagHeader;
                Optional opcWorkRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.tenantmanagercontrolplane.responses.CreateDomainResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Domain.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateDomainResponse.Builder builder = CreateDomainResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.domain((Domain)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                CreateDomainResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

