/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.usageapi.UsageapiAsync;
import com.oracle.bmc.usageapi.internal.http.CreateQueryConverter;
import com.oracle.bmc.usageapi.internal.http.DeleteQueryConverter;
import com.oracle.bmc.usageapi.internal.http.GetQueryConverter;
import com.oracle.bmc.usageapi.internal.http.ListQueriesConverter;
import com.oracle.bmc.usageapi.internal.http.RequestSummarizedConfigurationsConverter;
import com.oracle.bmc.usageapi.internal.http.RequestSummarizedUsagesConverter;
import com.oracle.bmc.usageapi.internal.http.UpdateQueryConverter;
import com.oracle.bmc.usageapi.requests.CreateQueryRequest;
import com.oracle.bmc.usageapi.requests.DeleteQueryRequest;
import com.oracle.bmc.usageapi.requests.GetQueryRequest;
import com.oracle.bmc.usageapi.requests.ListQueriesRequest;
import com.oracle.bmc.usageapi.requests.RequestSummarizedConfigurationsRequest;
import com.oracle.bmc.usageapi.requests.RequestSummarizedUsagesRequest;
import com.oracle.bmc.usageapi.requests.UpdateQueryRequest;
import com.oracle.bmc.usageapi.responses.CreateQueryResponse;
import com.oracle.bmc.usageapi.responses.DeleteQueryResponse;
import com.oracle.bmc.usageapi.responses.GetQueryResponse;
import com.oracle.bmc.usageapi.responses.ListQueriesResponse;
import com.oracle.bmc.usageapi.responses.RequestSummarizedConfigurationsResponse;
import com.oracle.bmc.usageapi.responses.RequestSummarizedUsagesResponse;
import com.oracle.bmc.usageapi.responses.UpdateQueryResponse;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageapiAsyncClient
implements UsageapiAsync {
    private static final Logger LOG = LoggerFactory.getLogger(UsageapiAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("USAGEAPI").serviceEndpointPrefix("").serviceEndpointTemplate("https://usageapi.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public UsageapiAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public UsageapiAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public UsageapiAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public UsageapiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public UsageapiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public UsageapiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public UsageapiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public UsageapiAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CreateQueryResponse> createQuery(CreateQueryRequest request, AsyncHandler<CreateQueryRequest, CreateQueryResponse> handler) {
        LOG.trace("Called async createQuery");
        CreateQueryRequest interceptedRequest = CreateQueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateQueryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateQueryResponse> transformer = CreateQueryConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateQueryRequest, CreateQueryResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateQueryRequest, CreateQueryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteQueryResponse> deleteQuery(DeleteQueryRequest request, AsyncHandler<DeleteQueryRequest, DeleteQueryResponse> handler) {
        LOG.trace("Called async deleteQuery");
        DeleteQueryRequest interceptedRequest = DeleteQueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteQueryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteQueryResponse> transformer = DeleteQueryConverter.fromResponse();
        AsyncHandler<DeleteQueryRequest, DeleteQueryResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteQueryRequest, DeleteQueryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetQueryResponse> getQuery(GetQueryRequest request, AsyncHandler<GetQueryRequest, GetQueryResponse> handler) {
        LOG.trace("Called async getQuery");
        GetQueryRequest interceptedRequest = GetQueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetQueryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetQueryResponse> transformer = GetQueryConverter.fromResponse();
        AsyncHandler<GetQueryRequest, GetQueryResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetQueryRequest, GetQueryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListQueriesResponse> listQueries(ListQueriesRequest request, AsyncHandler<ListQueriesRequest, ListQueriesResponse> handler) {
        LOG.trace("Called async listQueries");
        ListQueriesRequest interceptedRequest = ListQueriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListQueriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListQueriesResponse> transformer = ListQueriesConverter.fromResponse();
        AsyncHandler<ListQueriesRequest, ListQueriesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListQueriesRequest, ListQueriesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSummarizedConfigurationsResponse> requestSummarizedConfigurations(RequestSummarizedConfigurationsRequest request, AsyncHandler<RequestSummarizedConfigurationsRequest, RequestSummarizedConfigurationsResponse> handler) {
        LOG.trace("Called async requestSummarizedConfigurations");
        RequestSummarizedConfigurationsRequest interceptedRequest = RequestSummarizedConfigurationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedConfigurationsResponse> transformer = RequestSummarizedConfigurationsConverter.fromResponse();
        AsyncHandler<RequestSummarizedConfigurationsRequest, RequestSummarizedConfigurationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSummarizedConfigurationsRequest, RequestSummarizedConfigurationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RequestSummarizedUsagesResponse> requestSummarizedUsages(RequestSummarizedUsagesRequest request, AsyncHandler<RequestSummarizedUsagesRequest, RequestSummarizedUsagesResponse> handler) {
        LOG.trace("Called async requestSummarizedUsages");
        RequestSummarizedUsagesRequest interceptedRequest = RequestSummarizedUsagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RequestSummarizedUsagesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RequestSummarizedUsagesResponse> transformer = RequestSummarizedUsagesConverter.fromResponse();
        AsyncHandler<RequestSummarizedUsagesRequest, RequestSummarizedUsagesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RequestSummarizedUsagesRequest, RequestSummarizedUsagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateQueryResponse> updateQuery(UpdateQueryRequest request, AsyncHandler<UpdateQueryRequest, UpdateQueryResponse> handler) {
        LOG.trace("Called async updateQuery");
        UpdateQueryRequest interceptedRequest = UpdateQueryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateQueryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateQueryResponse> transformer = UpdateQueryConverter.fromResponse();
        AsyncHandler<UpdateQueryRequest, UpdateQueryResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateQueryRequest, UpdateQueryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, UsageapiAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public UsageapiAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new UsageapiAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

