/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.usageapi.Usageapi;
import com.oracle.bmc.usageapi.model.QuerySummary;
import com.oracle.bmc.usageapi.requests.ListQueriesRequest;
import com.oracle.bmc.usageapi.responses.ListQueriesResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class UsageapiPaginators {
    private final Usageapi client;

    public Iterable<ListQueriesResponse> listQueriesResponseIterator(final ListQueriesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListQueriesRequest.Builder>(){

            public ListQueriesRequest.Builder get() {
                return ListQueriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListQueriesResponse, String>(){

            public String apply(ListQueriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListQueriesRequest.Builder>, ListQueriesRequest>(){

            public ListQueriesRequest apply(RequestBuilderAndToken<ListQueriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListQueriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListQueriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListQueriesRequest, ListQueriesResponse>(){

            public ListQueriesResponse apply(ListQueriesRequest request) {
                return UsageapiPaginators.this.client.listQueries(request);
            }
        });
    }

    public Iterable<QuerySummary> listQueriesRecordIterator(final ListQueriesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListQueriesRequest.Builder>(){

            public ListQueriesRequest.Builder get() {
                return ListQueriesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListQueriesResponse, String>(){

            public String apply(ListQueriesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListQueriesRequest.Builder>, ListQueriesRequest>(){

            public ListQueriesRequest apply(RequestBuilderAndToken<ListQueriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListQueriesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListQueriesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListQueriesRequest, ListQueriesResponse>(){

            public ListQueriesResponse apply(ListQueriesRequest request) {
                return UsageapiPaginators.this.client.listQueries(request);
            }
        }, (Function)new Function<ListQueriesResponse, List<QuerySummary>>(){

            public List<QuerySummary> apply(ListQueriesResponse response) {
                return response.getQueryCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public UsageapiPaginators(Usageapi client) {
        this.client = client;
    }
}

