/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetQueryRequest
extends BmcRequest<Void> {
    private String queryId;
    private String opcRequestId;

    @ConstructorProperties(value={"queryId", "opcRequestId"})
    GetQueryRequest(String queryId, String opcRequestId) {
        this.queryId = queryId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetQueryRequest, Void> {
        private String queryId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetQueryRequest o) {
            this.queryId(o.getQueryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetQueryRequest build() {
            GetQueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetQueryRequest buildWithoutInvocationCallback() {
            return new GetQueryRequest(this.queryId, this.opcRequestId);
        }

        public String toString() {
            return "GetQueryRequest.Builder(queryId=" + this.queryId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

