/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.usageapi.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class RequestSummarizedConfigurationsRequest
extends BmcRequest<Void> {
    private String tenantId;
    private String opcRequestId;

    @ConstructorProperties(value={"tenantId", "opcRequestId"})
    RequestSummarizedConfigurationsRequest(String tenantId, String opcRequestId) {
        this.tenantId = tenantId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestSummarizedConfigurationsRequest, Void> {
        private String tenantId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestSummarizedConfigurationsRequest o) {
            this.tenantId(o.getTenantId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestSummarizedConfigurationsRequest build() {
            RequestSummarizedConfigurationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public RequestSummarizedConfigurationsRequest buildWithoutInvocationCallback() {
            return new RequestSummarizedConfigurationsRequest(this.tenantId, this.opcRequestId);
        }

        public String toString() {
            return "RequestSummarizedConfigurationsRequest.Builder(tenantId=" + this.tenantId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

