/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.vault.Vaults;
import com.oracle.bmc.vault.model.SecretSummary;
import com.oracle.bmc.vault.model.SecretVersionSummary;
import com.oracle.bmc.vault.requests.ListSecretVersionsRequest;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.responses.ListSecretVersionsResponse;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class VaultsPaginators {
    private final Vaults client;

    public Iterable<ListSecretVersionsResponse> listSecretVersionsResponseIterator(final ListSecretVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSecretVersionsRequest.Builder>(){

            public ListSecretVersionsRequest.Builder get() {
                return ListSecretVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretVersionsResponse, String>(){

            public String apply(ListSecretVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretVersionsRequest.Builder>, ListSecretVersionsRequest>(){

            public ListSecretVersionsRequest apply(RequestBuilderAndToken<ListSecretVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSecretVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSecretVersionsRequest, ListSecretVersionsResponse>(){

            public ListSecretVersionsResponse apply(ListSecretVersionsRequest request) {
                return VaultsPaginators.this.client.listSecretVersions(request);
            }
        });
    }

    public Iterable<SecretVersionSummary> listSecretVersionsRecordIterator(final ListSecretVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSecretVersionsRequest.Builder>(){

            public ListSecretVersionsRequest.Builder get() {
                return ListSecretVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretVersionsResponse, String>(){

            public String apply(ListSecretVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretVersionsRequest.Builder>, ListSecretVersionsRequest>(){

            public ListSecretVersionsRequest apply(RequestBuilderAndToken<ListSecretVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSecretVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSecretVersionsRequest, ListSecretVersionsResponse>(){

            public ListSecretVersionsResponse apply(ListSecretVersionsRequest request) {
                return VaultsPaginators.this.client.listSecretVersions(request);
            }
        }, (Function)new Function<ListSecretVersionsResponse, List<SecretVersionSummary>>(){

            public List<SecretVersionSummary> apply(ListSecretVersionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSecretsResponse> listSecretsResponseIterator(final ListSecretsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSecretsRequest.Builder>(){

            public ListSecretsRequest.Builder get() {
                return ListSecretsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretsResponse, String>(){

            public String apply(ListSecretsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretsRequest.Builder>, ListSecretsRequest>(){

            public ListSecretsRequest apply(RequestBuilderAndToken<ListSecretsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSecretsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSecretsRequest, ListSecretsResponse>(){

            public ListSecretsResponse apply(ListSecretsRequest request) {
                return VaultsPaginators.this.client.listSecrets(request);
            }
        });
    }

    public Iterable<SecretSummary> listSecretsRecordIterator(final ListSecretsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSecretsRequest.Builder>(){

            public ListSecretsRequest.Builder get() {
                return ListSecretsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretsResponse, String>(){

            public String apply(ListSecretsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretsRequest.Builder>, ListSecretsRequest>(){

            public ListSecretsRequest apply(RequestBuilderAndToken<ListSecretsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSecretsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSecretsRequest, ListSecretsResponse>(){

            public ListSecretsResponse apply(ListSecretsRequest request) {
                return VaultsPaginators.this.client.listSecrets(request);
            }
        }, (Function)new Function<ListSecretsResponse, List<SecretSummary>>(){

            public List<SecretSummary> apply(ListSecretsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public VaultsPaginators(Vaults client) {
        this.client = client;
    }
}

