/**
 * Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.waas;

import com.oracle.bmc.waas.requests.*;
import com.oracle.bmc.waas.responses.*;

/**
 * OCI Web Application Acceleration and Security Services
 */
@javax.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20181116")
public interface Waas extends AutoCloseable {

    /**
     * Sets the endpoint to call (ex, https://www.example.com).
     * @param endpoint The endpoint of the service.
     */
    void setEndpoint(String endpoint);

    /**
     * Gets the set endpoint for REST call (ex, https://www.example.com)
     */
    String getEndpoint();

    /**
     * Sets the region to call (ex, Region.US_PHOENIX_1).
     * <p>
     * Note, this will call {@link #setEndpoint(String) setEndpoint} after resolving the endpoint.  If the service is not available in this Region, however, an IllegalArgumentException will be raised.
     * @param region The region of the service.
     */
    void setRegion(com.oracle.bmc.Region region);

    /**
     * Sets the region to call (ex, 'us-phoenix-1').
     * <p>
     * Note, this will first try to map the region ID to a known Region and call
     * {@link #setRegion(Region) setRegion}.
     * <p>
     * If no known Region could be determined, it will create an endpoint based on the
     * default endpoint format ({@link com.oracle.bmc.Region#formatDefaultRegionEndpoint(Service, String)}
     * and then call {@link #setEndpoint(String) setEndpoint}.
     * @param regionId The public region ID.
     */
    void setRegion(String regionId);

    /**
     * Accepts a list of recommended Web Application Firewall protection rules. Web Application Firewall protection rule recommendations are sets of rules generated by observed traffic patterns through the Web Application Firewall and are meant to optimize the Web Application Firewall's security profile. Only the rules specified in the request body will be updated; all other rules will remain unchanged.
     * <p>
     * Use the `GET /waasPolicies/{waasPolicyId}/wafConfig/recommendations` method to view a list of recommended Web Application Firewall protection rules. For more information, see [WAF Protection Rules](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/wafprotectionrules.htm).
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/AcceptRecommendationsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use AcceptRecommendations API.
     */
    AcceptRecommendationsResponse acceptRecommendations(AcceptRecommendationsRequest request);

    /**
     * Cancels a specified work request.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/CancelWorkRequestExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use CancelWorkRequest API.
     */
    CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request);

    /**
     * Moves address list into a different compartment. When provided, If-Match
     * is checked against ETag values of the address list. For information about moving
     * resources between compartments, see [Moving Resources to a Different Compartment](https://docs.cloud.oracle.com/iaas/Content/Identity/Tasks/managingcompartments.htm#moveRes).
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ChangeAddressListCompartmentExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ChangeAddressListCompartment API.
     */
    ChangeAddressListCompartmentResponse changeAddressListCompartment(
            ChangeAddressListCompartmentRequest request);

    /**
     * Moves certificate into a different compartment. When provided, If-Match is checked against ETag values of the certificate.
     * For information about moving resources between compartments, see [Moving Resources to a Different Compartment](https://docs.cloud.oracle.com/iaas/Content/Identity/Tasks/managingcompartments.htm#moveRes).
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ChangeCertificateCompartmentExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ChangeCertificateCompartment API.
     */
    ChangeCertificateCompartmentResponse changeCertificateCompartment(
            ChangeCertificateCompartmentRequest request);

    /**
     * Moves a custom protection rule into a different compartment within the same tenancy. When provided, If-Match is checked against ETag values of the custom protection rule. For information about moving resources between compartments, see [Moving Resources to a Different Compartment](https://docs.cloud.oracle.com/iaas/Content/Identity/Tasks/managingcompartments.htm#moveRes).
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ChangeCustomProtectionRuleCompartmentExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ChangeCustomProtectionRuleCompartment API.
     */
    ChangeCustomProtectionRuleCompartmentResponse changeCustomProtectionRuleCompartment(
            ChangeCustomProtectionRuleCompartmentRequest request);

    /**
     * Moves WAAS policy into a different compartment. When provided, If-Match is checked against ETag values of the WAAS policy.
     * For information about moving resources between compartments, see [Moving Resources to a Different Compartment](https://docs.cloud.oracle.com/iaas/Content/Identity/Tasks/managingcompartments.htm#moveRes).
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ChangeWaasPolicyCompartmentExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ChangeWaasPolicyCompartment API.
     */
    ChangeWaasPolicyCompartmentResponse changeWaasPolicyCompartment(
            ChangeWaasPolicyCompartmentRequest request);

    /**
     * Creates an address list in a set compartment and allows it to be used in a WAAS policy and referenced by access rules. Addresses can be IP addresses and CIDR notations.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/CreateAddressListExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use CreateAddressList API.
     */
    CreateAddressListResponse createAddressList(CreateAddressListRequest request);

    /**
     * Allows an SSL certificate to be added to a WAAS policy. The Web Application Firewall terminates SSL connections to inspect requests in runtime, and then re-encrypts requests before sending them to the origin for fulfillment.
     * <p>
     * For more information, see [WAF Settings](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/wafsettings.htm).
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/CreateCertificateExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use CreateCertificate API.
     */
    CreateCertificateResponse createCertificate(CreateCertificateRequest request);

    /**
     * Creates a new custom protection rule in the specified compartment.
     * <p>
     * Custom protection rules allow you to create rules in addition to the rulesets provided by the Web Application Firewall service, including rules from [ModSecurity](https://modsecurity.org/). The syntax for custom rules is based on the ModSecurity syntax. For more information about custom protection rules, see [Custom Protection Rules](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/customprotectionrules.htm).
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/CreateCustomProtectionRuleExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use CreateCustomProtectionRule API.
     */
    CreateCustomProtectionRuleResponse createCustomProtectionRule(
            CreateCustomProtectionRuleRequest request);

    /**
     * Creates a new Web Application Acceleration and Security (WAAS) policy in the specified compartment. A WAAS policy must be established before creating Web Application Firewall (WAF) rules. To use WAF rules, your web application's origin servers must defined in the `WaasPolicy` schema.
     * <p>
     * A domain name must be specified when creating a WAAS policy. The domain name should be different from the origins specified in your `WaasPolicy`. Once domain name is entered and stored, it is unchangeable.
     * <p>
     * Use the record data returned in the `cname` field of the `WaasPolicy` object to create a CNAME record in your DNS configuration that will direct your domain's traffic through the WAF.
     * <p>
     * For the purposes of access control, you must provide the OCID of the compartment where you want the service to reside. For information about access control and compartments, see [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).
     * <p>
     * You must specify a display name and domain for the WAAS policy. The display name does not have to be unique and can be changed. The domain name should be different from every origin specified in `WaasPolicy`.
     * <p>
     * All Oracle Cloud Infrastructure resources, including WAAS policies, receive a unique, Oracle-assigned ID called an Oracle Cloud Identifier (OCID). When a resource is created, you can find its OCID in the response. You can also retrieve a resource's OCID by using a list API operation for that resource type, or by viewing the resource in the Console. Fore more information, see [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
     * <p>
     **Note:** After sending the POST request, the new object's state will temporarily be `CREATING`. Ensure that the resource's state has changed to `ACTIVE` before use.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/CreateWaasPolicyExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use CreateWaasPolicy API.
     */
    CreateWaasPolicyResponse createWaasPolicy(CreateWaasPolicyRequest request);

    /**
     * Deletes the address list from the compartment if it is not used.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/DeleteAddressListExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use DeleteAddressList API.
     */
    DeleteAddressListResponse deleteAddressList(DeleteAddressListRequest request);

    /**
     * Deletes an SSL certificate from the WAAS service.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/DeleteCertificateExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use DeleteCertificate API.
     */
    DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest request);

    /**
     * Deletes a Custom Protection rule.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/DeleteCustomProtectionRuleExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use DeleteCustomProtectionRule API.
     */
    DeleteCustomProtectionRuleResponse deleteCustomProtectionRule(
            DeleteCustomProtectionRuleRequest request);

    /**
     * Deletes a policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/DeleteWaasPolicyExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use DeleteWaasPolicy API.
     */
    DeleteWaasPolicyResponse deleteWaasPolicy(DeleteWaasPolicyRequest request);

    /**
     * Gets the details of an address list.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetAddressListExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetAddressList API.
     */
    GetAddressListResponse getAddressList(GetAddressListRequest request);

    /**
     * Gets the details of an SSL certificate.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetCertificateExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetCertificate API.
     */
    GetCertificateResponse getCertificate(GetCertificateRequest request);

    /**
     * Gets the details of a custom protection rule.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetCustomProtectionRuleExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetCustomProtectionRule API.
     */
    GetCustomProtectionRuleResponse getCustomProtectionRule(GetCustomProtectionRuleRequest request);

    /**
     * Gets the device fingerprint challenge settings in the Web Application Firewall configuration for a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetDeviceFingerprintChallengeExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetDeviceFingerprintChallenge API.
     */
    GetDeviceFingerprintChallengeResponse getDeviceFingerprintChallenge(
            GetDeviceFingerprintChallengeRequest request);

    /**
     * Gets the human interaction challenge settings in the Web Application Firewall configuration for a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetHumanInteractionChallengeExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetHumanInteractionChallenge API.
     */
    GetHumanInteractionChallengeResponse getHumanInteractionChallenge(
            GetHumanInteractionChallengeRequest request);

    /**
     * Gets the JavaScript challenge settings in the Web Application Firewall configuration for a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetJsChallengeExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetJsChallenge API.
     */
    GetJsChallengeResponse getJsChallenge(GetJsChallengeRequest request);

    /**
     * Gets the configuration of a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetPolicyConfigExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetPolicyConfig API.
     */
    GetPolicyConfigResponse getPolicyConfig(GetPolicyConfigRequest request);

    /**
     * Gets the details of a protection rule in the Web Application Firewall configuration for a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetProtectionRuleExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetProtectionRule API.
     */
    GetProtectionRuleResponse getProtectionRule(GetProtectionRuleRequest request);

    /**
     * Gets the protection settings in the Web Application Firewall configuration for a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetProtectionSettingsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetProtectionSettings API.
     */
    GetProtectionSettingsResponse getProtectionSettings(GetProtectionSettingsRequest request);

    /**
     * Gets the details of a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetWaasPolicyExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetWaasPolicy API.
     */
    GetWaasPolicyResponse getWaasPolicy(GetWaasPolicyRequest request);

    /**
     * Gets the address rate limiting settings of the Web Application Firewall configuration for a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetWafAddressRateLimitingExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetWafAddressRateLimiting API.
     */
    GetWafAddressRateLimitingResponse getWafAddressRateLimiting(
            GetWafAddressRateLimitingRequest request);

    /**
     * Gets the Web Application Firewall configuration details for a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetWafConfigExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetWafConfig API.
     */
    GetWafConfigResponse getWafConfig(GetWafConfigRequest request);

    /**
     * Gets the details of a specified work request.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/GetWorkRequestExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use GetWorkRequest API.
     */
    GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request);

    /**
     * Gets the currently configured access rules for the Web Application Firewall configuration of a specified WAAS policy.
     * The order of the access rules is important. The rules will be checked in the order they are specified and the first matching rule will be used.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListAccessRulesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListAccessRules API.
     */
    ListAccessRulesResponse listAccessRules(ListAccessRulesRequest request);

    /**
     * Gets a list of address lists that can be used in a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListAddressListsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListAddressLists API.
     */
    ListAddressListsResponse listAddressLists(ListAddressListsRequest request);

    /**
     * Gets the currently configured caching rules for the Web Application Firewall configuration of a specified WAAS policy.
     * The rules are processed in the order they are specified in and the first matching rule will be used when processing a request.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListCachingRulesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListCachingRules API.
     */
    ListCachingRulesResponse listCachingRules(ListCachingRulesRequest request);

    /**
     * Gets the list of currently configured CAPTCHA challenges in the Web
     * Application Firewall configuration of a WAAS policy.
     * <p>
     * The order of the CAPTCHA challenges is important. The URL for each
     * CAPTCHA will be checked in the order they are created.
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListCaptchasExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListCaptchas API.
     */
    ListCaptchasResponse listCaptchas(ListCaptchasRequest request);

    /**
     * Gets a list of SSL certificates that can be used in a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListCertificatesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListCertificates API.
     */
    ListCertificatesResponse listCertificates(ListCertificatesRequest request);

    /**
     * Gets a list of custom protection rules for the specified Web Application Firewall.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListCustomProtectionRulesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListCustomProtectionRules API.
     */
    ListCustomProtectionRulesResponse listCustomProtectionRules(
            ListCustomProtectionRulesRequest request);

    /**
     * Return the list of the tenant's edge node subnets. Use these CIDR blocks to restrict incoming traffic to your origin. These subnets are owned by OCI and forward traffic to customer origins. They are not associated with specific regions or compartments.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListEdgeSubnetsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListEdgeSubnets API.
     */
    ListEdgeSubnetsResponse listEdgeSubnets(ListEdgeSubnetsRequest request);

    /**
     * Gets the list of good bots defined in the Web Application Firewall configuration for a WAAS policy.
     * <p>
     * The list is sorted by `key`, in ascending order.
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListGoodBotsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListGoodBots API.
     */
    ListGoodBotsResponse listGoodBots(ListGoodBotsRequest request);

    /**
     * Gets the list of available protection rules for a WAAS policy. Use the `GetWafConfig` operation to view a list of currently configured protection rules for the Web Application Firewall, or use the `ListRecommendations` operation to get a list of recommended protection rules for the Web Application Firewall.
     * The list is sorted by `key`, in ascending order.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListProtectionRulesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListProtectionRules API.
     */
    ListProtectionRulesResponse listProtectionRules(ListProtectionRulesRequest request);

    /**
     * Gets the list of recommended Web Application Firewall protection rules.
     * <p>
     * Use the `POST /waasPolicies/{waasPolicyId}/actions/acceptWafConfigRecommendations` method to accept recommended Web Application Firewall protection rules. For more information, see [WAF Protection Rules](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/wafprotectionrules.htm).
     * The list is sorted by `key`, in ascending order.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListRecommendationsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListRecommendations API.
     */
    ListRecommendationsResponse listRecommendations(ListRecommendationsRequest request);

    /**
     * Gets the list of available web application threat intelligence feeds
     * and the actions set for each feed. The list is sorted by `key`,
     * in ascending order.
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListThreatFeedsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListThreatFeeds API.
     */
    ListThreatFeedsResponse listThreatFeeds(ListThreatFeedsRequest request);

    /**
     * Gets a list of WAAS policies.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListWaasPoliciesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListWaasPolicies API.
     */
    ListWaasPoliciesResponse listWaasPolicies(ListWaasPoliciesRequest request);

    /**
     * Gets the list of currently configured custom protection rules for a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListWaasPolicyCustomProtectionRulesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListWaasPolicyCustomProtectionRules API.
     */
    ListWaasPolicyCustomProtectionRulesResponse listWaasPolicyCustomProtectionRules(
            ListWaasPolicyCustomProtectionRulesRequest request);

    /**
     * Gets the number of blocked requests by a Web Application Firewall feature in five minute blocks, sorted by `timeObserved` in ascending order (starting from oldest data).
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListWafBlockedRequestsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListWafBlockedRequests API.
     */
    ListWafBlockedRequestsResponse listWafBlockedRequests(ListWafBlockedRequestsRequest request);

    /**
     * Gets structured Web Application Firewall event logs for a WAAS
     * policy. Sorted by the `timeObserved` in ascending order (starting from the
     * oldest recorded event).
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListWafLogsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListWafLogs API.
     */
    ListWafLogsResponse listWafLogs(ListWafLogsRequest request);

    /**
     * Gets the number of requests managed by a Web Application Firewall
     * over a specified period of time, including blocked requests. Sorted
     * by `timeObserved` in ascending order (starting from oldest requests).
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListWafRequestsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListWafRequests API.
     */
    ListWafRequestsResponse listWafRequests(ListWafRequestsRequest request);

    /**
     * Gets the Web Application Firewall traffic data for a WAAS policy.
     * Sorted by `timeObserved` in ascending order (starting from oldest data).
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListWafTrafficExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListWafTraffic API.
     */
    ListWafTrafficResponse listWafTraffic(ListWafTrafficRequest request);

    /**
     * Gets the list of whitelists defined in the Web Application Firewall configuration for a WAAS policy.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListWhitelistsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListWhitelists API.
     */
    ListWhitelistsResponse listWhitelists(ListWhitelistsRequest request);

    /**
     * Gets a list of subnets (CIDR notation) from which the WAAS EDGE may make requests. The subnets are owned by OCI and forward traffic to your origins. Allow traffic from these subnets to your origins. They are not associated with specific regions or compartments.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/ListWorkRequestsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use ListWorkRequests API.
     */
    ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request);

    /**
     * Performs a purge of the cache for each specified resource. If no resources are passed, the cache for the entire Web Application Firewall will be purged.
     * For more information, see [Caching Rules](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/cachingrules.htm#purge).
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/PurgeCacheExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use PurgeCache API.
     */
    PurgeCacheResponse purgeCache(PurgeCacheRequest request);

    /**
     * Updates the list of access rules in the Web Application Firewall configuration for a specified WAAS policy. Access rules allow explicit actions to be defined and executed for requests that meet various conditions. A rule action can be set to allow, detect, or block requests. The detect setting allows the request to pass through the Web Application Firewall and is tagged with a `DETECT` flag in the Web Application Firewall's log.
     * <p>
     * This operation can create, delete, update, and/or reorder access rules depending on the structure of the request body.
     * <p>
     * Access rules can be updated by changing the properties of the access rule object with the rule's key specified in the key field. Access rules can be reordered by changing the order of the access rules in the list when updating.
     * <p>
     * Access rules can be created by adding a new access rule object to the list without a `key` property specified. A `key` will be generated for the new access rule upon update.
     * <p>
     * Any existing access rules that are not specified with a `key` in the list of access rules will be deleted upon update.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateAccessRulesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateAccessRules API.
     */
    UpdateAccessRulesResponse updateAccessRules(UpdateAccessRulesRequest request);

    /**
     * Updates the details of an address list. Only the fields specified in the request body will be updated; all other properties will remain unchanged.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateAddressListExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateAddressList API.
     */
    UpdateAddressListResponse updateAddressList(UpdateAddressListRequest request);

    /**
     * Updates the configuration for each specified caching rule.
     * <p>
     * Caching rules WAF policies allow you to selectively cache content on Oracle Cloud Infrastructure's edge servers, such as webpages or certain file types. For more information about caching rules, see [Caching Rules](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/cachingrules.htm).
     * <p>
     * This operation can create, delete, update, and/or reorder caching rules depending on the structure of the request body. Caching rules can be updated by changing the properties of the caching rule object with the rule's key specified in the key field. Any existing caching rules that are not specified with a key in the list of access rules will be deleted upon update.
     * <p>
     * The order the caching rules are specified in is important. The rules are processed in the order they are specified and the first matching rule will be used when processing a request. Use `ListCachingRules` to view a list of all available caching rules in a compartment.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateCachingRulesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateCachingRules API.
     */
    UpdateCachingRulesResponse updateCachingRules(UpdateCachingRulesRequest request);

    /**
     * Updates the list of CAPTCHA challenges in the Web Application Firewall configuration for a WAAS policy.
     * This operation can create, update, or delete CAPTCHAs depending on the structure of the request body.
     * CAPTCHA challenges can be updated by changing the properties of the CAPTCHA object with the rule's key specified in the key field. CAPTCHA challenges can be reordered by changing the order of the CAPTCHA challenges in the list when updating.
     * <p>
     * CAPTCHA challenges can be created by adding a new access rule object to the list without a `key` property specified. A `key` will be generated for the new CAPTCHA challenges upon update.
     * <p>
     * Any existing CAPTCHA challenges that are not specified with a `key` in the list of CAPTCHA challenges will be deleted upon update.
     * <p>
     * Query parameters are allowed in CAPTCHA URL.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateCaptchasExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateCaptchas API.
     */
    UpdateCaptchasResponse updateCaptchas(UpdateCaptchasRequest request);

    /**
     * It is not possible to update a certificate, only create and delete. Therefore, this operation can only update the display name, freeform tags, and defined tags of a certificate.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateCertificateExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateCertificate API.
     */
    UpdateCertificateResponse updateCertificate(UpdateCertificateRequest request);

    /**
     * Updates the configuration of a custom protection rule. Only the fields specified in the request body will be updated; all other properties will remain unchanged.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateCustomProtectionRuleExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateCustomProtectionRule API.
     */
    UpdateCustomProtectionRuleResponse updateCustomProtectionRule(
            UpdateCustomProtectionRuleRequest request);

    /**
     * Updates the Device Fingerprint Challenge (DFC) settings in the Web Application Firewall configuration for a policy. The DFC generates a hashed signature of both virtual and real browsers based on 50+ attributes. These proprietary signatures are then leveraged for real-time correlation to identify and block malicious bots.
     * <p>
     * The signature is based on a library of attributes detected via JavaScript listeners; the attributes include OS, screen resolution, fonts, UserAgent, IP address, etc. We are constantly making improvements and considering new libraries to include in our DFC build. We can also exclude attributes from the signature as needed.
     * <p>
     * DFC collects attributes to generate a hashed signature about a client - if a fingerprint is not possible, then it will result in a block or alert action. Actions can be enforced across multiple devices if they share they have the same fingerprint.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateDeviceFingerprintChallengeExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateDeviceFingerprintChallenge API.
     */
    UpdateDeviceFingerprintChallengeResponse updateDeviceFingerprintChallenge(
            UpdateDeviceFingerprintChallengeRequest request);

    /**
     * Updates the list of good bots in the Web Application Firewall configuration for a policy. Only the fields specified in the request body will be updated, all other configuration properties will remain unchanged.
     * <p>
     * Good bots allows you to manage access for bots from known providers, such as Google or Baidu. For more information about good bots, see [Bot Management](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/botmanagement.htm).
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateGoodBotsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateGoodBots API.
     */
    UpdateGoodBotsResponse updateGoodBots(UpdateGoodBotsRequest request);

    /**
     * Updates the Human Interaction Challenge (HIC) settings in the Web Application Firewall configuration for a WAAS policy. HIC is a countermeasure that allows the proxy to check the user's browser for various behaviors that distinguish a human presence from a bot.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateHumanInteractionChallengeExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateHumanInteractionChallenge API.
     */
    UpdateHumanInteractionChallengeResponse updateHumanInteractionChallenge(
            UpdateHumanInteractionChallengeRequest request);

    /**
     * Updates the JavaScript challenge settings in the Web Application Firewall configuration for a WAAS policy. JavaScript Challenge validates that the client can accept JavaScript with a binary decision. For more information, see [Bot Management](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/botmanagement.htm).
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateJsChallengeExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateJsChallenge API.
     */
    UpdateJsChallengeResponse updateJsChallenge(UpdateJsChallengeRequest request);

    /**
     * Updates the configuration for a WAAS policy. Only the fields specified in the request body will be updated; all other properties will remain unchanged.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdatePolicyConfigExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdatePolicyConfig API.
     */
    UpdatePolicyConfigResponse updatePolicyConfig(UpdatePolicyConfigRequest request);

    /**
     * Updates the action for each specified protection rule. Requests can either be allowed, blocked, or trigger an alert if they meet the parameters of an applied rule. For more information on protection rules, see [WAF Protection Rules](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/wafprotectionrules.htm).
     * This operation can update or disable protection rules depending on the structure of the request body.
     * Protection rules can be updated by changing the properties of the protection rule object with the rule's key specified in the key field.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateProtectionRulesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateProtectionRules API.
     */
    UpdateProtectionRulesResponse updateProtectionRules(UpdateProtectionRulesRequest request);

    /**
     * Updates the protection settings in the Web Application Firewall configuration for a WAAS policy. Protection settings allow you define what action is taken when a request is blocked by the Web Application Firewall, such as returning a response code or block page. Only the fields specified in the request body will be updated; all other fields will remain unchanged.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateProtectionSettingsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateProtectionSettings API.
     */
    UpdateProtectionSettingsResponse updateProtectionSettings(
            UpdateProtectionSettingsRequest request);

    /**
     * Updates the action to take when a request's IP address matches an address in the specified threat intelligence feed. Threat intelligence feeds are compiled lists of IP addresses with malicious reputations based on internet intelligence. Only the threat feeds specified in the request body will be updated; all other threat feeds will remain unchanged.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateThreatFeedsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateThreatFeeds API.
     */
    UpdateThreatFeedsResponse updateThreatFeeds(UpdateThreatFeedsRequest request);

    /**
     * Updates the details of a WAAS policy, including origins and tags. Only the fields specified in the request body will be updated; all other properties will remain unchanged.
     * To update platform provided resources such as `GoodBots`, `ProtectionRules`, and `ThreatFeeds`, first retrieve the list of available resources with the related list operation such as `GetThreatFeeds` or `GetProtectionRules`.
     * The returned list will contain objects with `key` properties that can be used to update the resource during the `UpdateWaasPolicy` request.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateWaasPolicyExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateWaasPolicy API.
     */
    UpdateWaasPolicyResponse updateWaasPolicy(UpdateWaasPolicyRequest request);

    /**
     * Updates the action for each specified custom protection rule. Only the `DETECT` and `BLOCK` actions can be set. Disabled rules should not be included in the list. For more information on protection rules, see [WAF Protection Rules](https://docs.cloud.oracle.com/iaas/Content/WAF/Tasks/wafprotectionrules.htm).
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateWaasPolicyCustomProtectionRulesExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateWaasPolicyCustomProtectionRules API.
     */
    UpdateWaasPolicyCustomProtectionRulesResponse updateWaasPolicyCustomProtectionRules(
            UpdateWaasPolicyCustomProtectionRulesRequest request);

    /**
     * Updates the address rate limiting settings in the Web Application Firewall configuration for a policy. Rate limiting allows you to configure a threshold for the number of requests from a unique IP address for the given period. You can also define the response code for the requests from the same address that exceed the threshold.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateWafAddressRateLimitingExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateWafAddressRateLimiting API.
     */
    UpdateWafAddressRateLimitingResponse updateWafAddressRateLimiting(
            UpdateWafAddressRateLimitingRequest request);

    /**
     * Updates the Web Application Firewall configuration for a specified WAAS policy.
     * <p>
     * To update platform provided resources such as `GoodBots`, `ProtectionRules`, and `ThreatFeeds`,
     * first retrieve the list of available resources with the related list operation, such as
     * `GetThreatFeeds` or `GetProtectionRules`.
     * <p>
     * The returned list will contain objects with `key` properties that can be used to update the
     * resource during the `UpdateWafConfig` request.
     *
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateWafConfigExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateWafConfig API.
     */
    UpdateWafConfigResponse updateWafConfig(UpdateWafConfigRequest request);

    /**
     * Updates the list of IP addresses that bypass the Web Application Firewall for a WAAS policy. Supports single IP addresses, subnet masks (CIDR notation) and Address Lists.
     * <p>
     * This operation can create, delete, update, and/or reorder whitelists depending on the structure of the request body.
     * <p>
     * Whitelists can be updated by changing the properties of the whitelist object with the rule's key specified in the `key` field. Whitelists can be reordered by changing the order of the whitelists in the list of objects when updating.
     * <p>
     * Whitelists can be created by adding a new whitelist object to the list without a `key` property specified. A `key` will be generated for the new whitelist upon update.
     * <p>
     * Whitelists can be deleted by removing the existing whitelist object from the list. Any existing whitelists that are not specified with a `key` in the list of access rules will be deleted upon update.
     * @param request The request object containing the details to send
     * @return A response object containing details about the completed operation
     * @throws BmcException when an error occurs.
     *
     * <b>Example: </b>Click <a href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/waas/UpdateWhitelistsExample.java.html" target="_blank" rel="noopener noreferrer" >here</a> to see how to use UpdateWhitelists API.
     */
    UpdateWhitelistsResponse updateWhitelists(UpdateWhitelistsRequest request);

    /**
     * Gets the pre-configured waiters available for resources for this service.
     *
     * @return The service waiters.
     */
    WaasWaiters getWaiters();

    /**
     * Gets the pre-configured paginators available for list operations in this service which may return multiple
     * pages of data. These paginators provide an {@link java.lang.Iterable} interface so that service responses, or
     * resources/records, can be iterated through without having to manually deal with pagination and page tokens.
     *
     * @return The service paginators.
     */
    WaasPaginators getPaginators();
}
