/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.waas.Redirect;
import com.oracle.bmc.waas.RedirectPaginators;
import com.oracle.bmc.waas.RedirectWaiters;
import com.oracle.bmc.waas.internal.http.ChangeHttpRedirectCompartmentConverter;
import com.oracle.bmc.waas.internal.http.CreateHttpRedirectConverter;
import com.oracle.bmc.waas.internal.http.DeleteHttpRedirectConverter;
import com.oracle.bmc.waas.internal.http.GetHttpRedirectConverter;
import com.oracle.bmc.waas.internal.http.ListHttpRedirectsConverter;
import com.oracle.bmc.waas.internal.http.UpdateHttpRedirectConverter;
import com.oracle.bmc.waas.requests.ChangeHttpRedirectCompartmentRequest;
import com.oracle.bmc.waas.requests.CreateHttpRedirectRequest;
import com.oracle.bmc.waas.requests.DeleteHttpRedirectRequest;
import com.oracle.bmc.waas.requests.GetHttpRedirectRequest;
import com.oracle.bmc.waas.requests.ListHttpRedirectsRequest;
import com.oracle.bmc.waas.requests.UpdateHttpRedirectRequest;
import com.oracle.bmc.waas.responses.ChangeHttpRedirectCompartmentResponse;
import com.oracle.bmc.waas.responses.CreateHttpRedirectResponse;
import com.oracle.bmc.waas.responses.DeleteHttpRedirectResponse;
import com.oracle.bmc.waas.responses.GetHttpRedirectResponse;
import com.oracle.bmc.waas.responses.ListHttpRedirectsResponse;
import com.oracle.bmc.waas.responses.UpdateHttpRedirectResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectClient
implements Redirect {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("REDIRECT").serviceEndpointPrefix("waas").serviceEndpointTemplate("https://waas.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final RedirectWaiters waiters;
    private final RedirectPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public RedirectClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public RedirectClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public RedirectClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public RedirectClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public RedirectClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public RedirectClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public RedirectClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public RedirectClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected RedirectClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Redirect-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new RedirectWaiters(executorService, this);
        this.paginators = new RedirectPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeHttpRedirectCompartmentResponse changeHttpRedirectCompartment(ChangeHttpRedirectCompartmentRequest request) {
        LOG.trace("Called changeHttpRedirectCompartment");
        ChangeHttpRedirectCompartmentRequest interceptedRequest = ChangeHttpRedirectCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeHttpRedirectCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeHttpRedirectCompartmentResponse> transformer = ChangeHttpRedirectCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeHttpRedirectCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeHttpRedirectCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeHttpRedirectCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeHttpRedirectCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateHttpRedirectResponse createHttpRedirect(CreateHttpRedirectRequest request) {
        LOG.trace("Called createHttpRedirect");
        CreateHttpRedirectRequest interceptedRequest = CreateHttpRedirectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateHttpRedirectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateHttpRedirectResponse> transformer = CreateHttpRedirectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateHttpRedirectResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateHttpRedirectResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateHttpRedirectDetails(), (BmcRequest)retriedRequest);
                return (CreateHttpRedirectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteHttpRedirectResponse deleteHttpRedirect(DeleteHttpRedirectRequest request) {
        LOG.trace("Called deleteHttpRedirect");
        DeleteHttpRedirectRequest interceptedRequest = DeleteHttpRedirectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteHttpRedirectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteHttpRedirectResponse> transformer = DeleteHttpRedirectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteHttpRedirectResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteHttpRedirectResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteHttpRedirectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetHttpRedirectResponse getHttpRedirect(GetHttpRedirectRequest request) {
        LOG.trace("Called getHttpRedirect");
        GetHttpRedirectRequest interceptedRequest = GetHttpRedirectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHttpRedirectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHttpRedirectResponse> transformer = GetHttpRedirectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetHttpRedirectResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetHttpRedirectResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetHttpRedirectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListHttpRedirectsResponse listHttpRedirects(ListHttpRedirectsRequest request) {
        LOG.trace("Called listHttpRedirects");
        ListHttpRedirectsRequest interceptedRequest = ListHttpRedirectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListHttpRedirectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListHttpRedirectsResponse> transformer = ListHttpRedirectsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListHttpRedirectsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListHttpRedirectsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListHttpRedirectsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateHttpRedirectResponse updateHttpRedirect(UpdateHttpRedirectRequest request) {
        LOG.trace("Called updateHttpRedirect");
        UpdateHttpRedirectRequest interceptedRequest = UpdateHttpRedirectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHttpRedirectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateHttpRedirectResponse> transformer = UpdateHttpRedirectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateHttpRedirectResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateHttpRedirectResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateHttpRedirectDetails(), (BmcRequest)retriedRequest);
                return (UpdateHttpRedirectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RedirectWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public RedirectPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RedirectClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RedirectClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new RedirectClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

