/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.waas.Redirect;
import com.oracle.bmc.waas.model.HttpRedirectSummary;
import com.oracle.bmc.waas.requests.ListHttpRedirectsRequest;
import com.oracle.bmc.waas.responses.ListHttpRedirectsResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class RedirectPaginators {
    private final Redirect client;

    public Iterable<ListHttpRedirectsResponse> listHttpRedirectsResponseIterator(final ListHttpRedirectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHttpRedirectsRequest.Builder>(){

            public ListHttpRedirectsRequest.Builder get() {
                return ListHttpRedirectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpRedirectsResponse, String>(){

            public String apply(ListHttpRedirectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpRedirectsRequest.Builder>, ListHttpRedirectsRequest>(){

            public ListHttpRedirectsRequest apply(RequestBuilderAndToken<ListHttpRedirectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListHttpRedirectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpRedirectsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListHttpRedirectsRequest, ListHttpRedirectsResponse>(){

            public ListHttpRedirectsResponse apply(ListHttpRedirectsRequest request) {
                return RedirectPaginators.this.client.listHttpRedirects(request);
            }
        });
    }

    public Iterable<HttpRedirectSummary> listHttpRedirectsRecordIterator(final ListHttpRedirectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHttpRedirectsRequest.Builder>(){

            public ListHttpRedirectsRequest.Builder get() {
                return ListHttpRedirectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpRedirectsResponse, String>(){

            public String apply(ListHttpRedirectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpRedirectsRequest.Builder>, ListHttpRedirectsRequest>(){

            public ListHttpRedirectsRequest apply(RequestBuilderAndToken<ListHttpRedirectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListHttpRedirectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpRedirectsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListHttpRedirectsRequest, ListHttpRedirectsResponse>(){

            public ListHttpRedirectsResponse apply(ListHttpRedirectsRequest request) {
                return RedirectPaginators.this.client.listHttpRedirects(request);
            }
        }, (Function)new Function<ListHttpRedirectsResponse, List<HttpRedirectSummary>>(){

            public List<HttpRedirectSummary> apply(ListHttpRedirectsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public RedirectPaginators(Redirect client) {
        this.client = client;
    }
}

