/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.waas.Waas;
import com.oracle.bmc.waas.WaasPaginators;
import com.oracle.bmc.waas.WaasWaiters;
import com.oracle.bmc.waas.internal.http.AcceptRecommendationsConverter;
import com.oracle.bmc.waas.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.waas.internal.http.ChangeAddressListCompartmentConverter;
import com.oracle.bmc.waas.internal.http.ChangeCertificateCompartmentConverter;
import com.oracle.bmc.waas.internal.http.ChangeCustomProtectionRuleCompartmentConverter;
import com.oracle.bmc.waas.internal.http.ChangeWaasPolicyCompartmentConverter;
import com.oracle.bmc.waas.internal.http.CreateAddressListConverter;
import com.oracle.bmc.waas.internal.http.CreateCertificateConverter;
import com.oracle.bmc.waas.internal.http.CreateCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.CreateWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.DeleteAddressListConverter;
import com.oracle.bmc.waas.internal.http.DeleteCertificateConverter;
import com.oracle.bmc.waas.internal.http.DeleteCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.DeleteWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.GetAddressListConverter;
import com.oracle.bmc.waas.internal.http.GetCertificateConverter;
import com.oracle.bmc.waas.internal.http.GetCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.GetDeviceFingerprintChallengeConverter;
import com.oracle.bmc.waas.internal.http.GetHumanInteractionChallengeConverter;
import com.oracle.bmc.waas.internal.http.GetJsChallengeConverter;
import com.oracle.bmc.waas.internal.http.GetPolicyConfigConverter;
import com.oracle.bmc.waas.internal.http.GetProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.GetProtectionSettingsConverter;
import com.oracle.bmc.waas.internal.http.GetWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.GetWafAddressRateLimitingConverter;
import com.oracle.bmc.waas.internal.http.GetWafConfigConverter;
import com.oracle.bmc.waas.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.waas.internal.http.ListAccessRulesConverter;
import com.oracle.bmc.waas.internal.http.ListAddressListsConverter;
import com.oracle.bmc.waas.internal.http.ListCachingRulesConverter;
import com.oracle.bmc.waas.internal.http.ListCaptchasConverter;
import com.oracle.bmc.waas.internal.http.ListCertificatesConverter;
import com.oracle.bmc.waas.internal.http.ListCustomProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.ListEdgeSubnetsConverter;
import com.oracle.bmc.waas.internal.http.ListGoodBotsConverter;
import com.oracle.bmc.waas.internal.http.ListProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.ListRecommendationsConverter;
import com.oracle.bmc.waas.internal.http.ListThreatFeedsConverter;
import com.oracle.bmc.waas.internal.http.ListWaasPoliciesConverter;
import com.oracle.bmc.waas.internal.http.ListWaasPolicyCustomProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.ListWafBlockedRequestsConverter;
import com.oracle.bmc.waas.internal.http.ListWafLogsConverter;
import com.oracle.bmc.waas.internal.http.ListWafRequestsConverter;
import com.oracle.bmc.waas.internal.http.ListWafTrafficConverter;
import com.oracle.bmc.waas.internal.http.ListWhitelistsConverter;
import com.oracle.bmc.waas.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.waas.internal.http.PurgeCacheConverter;
import com.oracle.bmc.waas.internal.http.UpdateAccessRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateAddressListConverter;
import com.oracle.bmc.waas.internal.http.UpdateCachingRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateCaptchasConverter;
import com.oracle.bmc.waas.internal.http.UpdateCertificateConverter;
import com.oracle.bmc.waas.internal.http.UpdateCustomProtectionRuleConverter;
import com.oracle.bmc.waas.internal.http.UpdateDeviceFingerprintChallengeConverter;
import com.oracle.bmc.waas.internal.http.UpdateGoodBotsConverter;
import com.oracle.bmc.waas.internal.http.UpdateHumanInteractionChallengeConverter;
import com.oracle.bmc.waas.internal.http.UpdateJsChallengeConverter;
import com.oracle.bmc.waas.internal.http.UpdatePolicyConfigConverter;
import com.oracle.bmc.waas.internal.http.UpdateProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateProtectionSettingsConverter;
import com.oracle.bmc.waas.internal.http.UpdateThreatFeedsConverter;
import com.oracle.bmc.waas.internal.http.UpdateWaasPolicyConverter;
import com.oracle.bmc.waas.internal.http.UpdateWaasPolicyCustomProtectionRulesConverter;
import com.oracle.bmc.waas.internal.http.UpdateWafAddressRateLimitingConverter;
import com.oracle.bmc.waas.internal.http.UpdateWafConfigConverter;
import com.oracle.bmc.waas.internal.http.UpdateWhitelistsConverter;
import com.oracle.bmc.waas.requests.AcceptRecommendationsRequest;
import com.oracle.bmc.waas.requests.CancelWorkRequestRequest;
import com.oracle.bmc.waas.requests.ChangeAddressListCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeCertificateCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeCustomProtectionRuleCompartmentRequest;
import com.oracle.bmc.waas.requests.ChangeWaasPolicyCompartmentRequest;
import com.oracle.bmc.waas.requests.CreateAddressListRequest;
import com.oracle.bmc.waas.requests.CreateCertificateRequest;
import com.oracle.bmc.waas.requests.CreateCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.CreateWaasPolicyRequest;
import com.oracle.bmc.waas.requests.DeleteAddressListRequest;
import com.oracle.bmc.waas.requests.DeleteCertificateRequest;
import com.oracle.bmc.waas.requests.DeleteCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.DeleteWaasPolicyRequest;
import com.oracle.bmc.waas.requests.GetAddressListRequest;
import com.oracle.bmc.waas.requests.GetCertificateRequest;
import com.oracle.bmc.waas.requests.GetCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.GetDeviceFingerprintChallengeRequest;
import com.oracle.bmc.waas.requests.GetHumanInteractionChallengeRequest;
import com.oracle.bmc.waas.requests.GetJsChallengeRequest;
import com.oracle.bmc.waas.requests.GetPolicyConfigRequest;
import com.oracle.bmc.waas.requests.GetProtectionRuleRequest;
import com.oracle.bmc.waas.requests.GetProtectionSettingsRequest;
import com.oracle.bmc.waas.requests.GetWaasPolicyRequest;
import com.oracle.bmc.waas.requests.GetWafAddressRateLimitingRequest;
import com.oracle.bmc.waas.requests.GetWafConfigRequest;
import com.oracle.bmc.waas.requests.GetWorkRequestRequest;
import com.oracle.bmc.waas.requests.ListAccessRulesRequest;
import com.oracle.bmc.waas.requests.ListAddressListsRequest;
import com.oracle.bmc.waas.requests.ListCachingRulesRequest;
import com.oracle.bmc.waas.requests.ListCaptchasRequest;
import com.oracle.bmc.waas.requests.ListCertificatesRequest;
import com.oracle.bmc.waas.requests.ListCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListEdgeSubnetsRequest;
import com.oracle.bmc.waas.requests.ListGoodBotsRequest;
import com.oracle.bmc.waas.requests.ListProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListRecommendationsRequest;
import com.oracle.bmc.waas.requests.ListThreatFeedsRequest;
import com.oracle.bmc.waas.requests.ListWaasPoliciesRequest;
import com.oracle.bmc.waas.requests.ListWaasPolicyCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.ListWafBlockedRequestsRequest;
import com.oracle.bmc.waas.requests.ListWafLogsRequest;
import com.oracle.bmc.waas.requests.ListWafRequestsRequest;
import com.oracle.bmc.waas.requests.ListWafTrafficRequest;
import com.oracle.bmc.waas.requests.ListWhitelistsRequest;
import com.oracle.bmc.waas.requests.ListWorkRequestsRequest;
import com.oracle.bmc.waas.requests.PurgeCacheRequest;
import com.oracle.bmc.waas.requests.UpdateAccessRulesRequest;
import com.oracle.bmc.waas.requests.UpdateAddressListRequest;
import com.oracle.bmc.waas.requests.UpdateCachingRulesRequest;
import com.oracle.bmc.waas.requests.UpdateCaptchasRequest;
import com.oracle.bmc.waas.requests.UpdateCertificateRequest;
import com.oracle.bmc.waas.requests.UpdateCustomProtectionRuleRequest;
import com.oracle.bmc.waas.requests.UpdateDeviceFingerprintChallengeRequest;
import com.oracle.bmc.waas.requests.UpdateGoodBotsRequest;
import com.oracle.bmc.waas.requests.UpdateHumanInteractionChallengeRequest;
import com.oracle.bmc.waas.requests.UpdateJsChallengeRequest;
import com.oracle.bmc.waas.requests.UpdatePolicyConfigRequest;
import com.oracle.bmc.waas.requests.UpdateProtectionRulesRequest;
import com.oracle.bmc.waas.requests.UpdateProtectionSettingsRequest;
import com.oracle.bmc.waas.requests.UpdateThreatFeedsRequest;
import com.oracle.bmc.waas.requests.UpdateWaasPolicyCustomProtectionRulesRequest;
import com.oracle.bmc.waas.requests.UpdateWaasPolicyRequest;
import com.oracle.bmc.waas.requests.UpdateWafAddressRateLimitingRequest;
import com.oracle.bmc.waas.requests.UpdateWafConfigRequest;
import com.oracle.bmc.waas.requests.UpdateWhitelistsRequest;
import com.oracle.bmc.waas.responses.AcceptRecommendationsResponse;
import com.oracle.bmc.waas.responses.CancelWorkRequestResponse;
import com.oracle.bmc.waas.responses.ChangeAddressListCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeCertificateCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeCustomProtectionRuleCompartmentResponse;
import com.oracle.bmc.waas.responses.ChangeWaasPolicyCompartmentResponse;
import com.oracle.bmc.waas.responses.CreateAddressListResponse;
import com.oracle.bmc.waas.responses.CreateCertificateResponse;
import com.oracle.bmc.waas.responses.CreateCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.CreateWaasPolicyResponse;
import com.oracle.bmc.waas.responses.DeleteAddressListResponse;
import com.oracle.bmc.waas.responses.DeleteCertificateResponse;
import com.oracle.bmc.waas.responses.DeleteCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.DeleteWaasPolicyResponse;
import com.oracle.bmc.waas.responses.GetAddressListResponse;
import com.oracle.bmc.waas.responses.GetCertificateResponse;
import com.oracle.bmc.waas.responses.GetCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.GetDeviceFingerprintChallengeResponse;
import com.oracle.bmc.waas.responses.GetHumanInteractionChallengeResponse;
import com.oracle.bmc.waas.responses.GetJsChallengeResponse;
import com.oracle.bmc.waas.responses.GetPolicyConfigResponse;
import com.oracle.bmc.waas.responses.GetProtectionRuleResponse;
import com.oracle.bmc.waas.responses.GetProtectionSettingsResponse;
import com.oracle.bmc.waas.responses.GetWaasPolicyResponse;
import com.oracle.bmc.waas.responses.GetWafAddressRateLimitingResponse;
import com.oracle.bmc.waas.responses.GetWafConfigResponse;
import com.oracle.bmc.waas.responses.GetWorkRequestResponse;
import com.oracle.bmc.waas.responses.ListAccessRulesResponse;
import com.oracle.bmc.waas.responses.ListAddressListsResponse;
import com.oracle.bmc.waas.responses.ListCachingRulesResponse;
import com.oracle.bmc.waas.responses.ListCaptchasResponse;
import com.oracle.bmc.waas.responses.ListCertificatesResponse;
import com.oracle.bmc.waas.responses.ListCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListEdgeSubnetsResponse;
import com.oracle.bmc.waas.responses.ListGoodBotsResponse;
import com.oracle.bmc.waas.responses.ListProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListRecommendationsResponse;
import com.oracle.bmc.waas.responses.ListThreatFeedsResponse;
import com.oracle.bmc.waas.responses.ListWaasPoliciesResponse;
import com.oracle.bmc.waas.responses.ListWaasPolicyCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.ListWafBlockedRequestsResponse;
import com.oracle.bmc.waas.responses.ListWafLogsResponse;
import com.oracle.bmc.waas.responses.ListWafRequestsResponse;
import com.oracle.bmc.waas.responses.ListWafTrafficResponse;
import com.oracle.bmc.waas.responses.ListWhitelistsResponse;
import com.oracle.bmc.waas.responses.ListWorkRequestsResponse;
import com.oracle.bmc.waas.responses.PurgeCacheResponse;
import com.oracle.bmc.waas.responses.UpdateAccessRulesResponse;
import com.oracle.bmc.waas.responses.UpdateAddressListResponse;
import com.oracle.bmc.waas.responses.UpdateCachingRulesResponse;
import com.oracle.bmc.waas.responses.UpdateCaptchasResponse;
import com.oracle.bmc.waas.responses.UpdateCertificateResponse;
import com.oracle.bmc.waas.responses.UpdateCustomProtectionRuleResponse;
import com.oracle.bmc.waas.responses.UpdateDeviceFingerprintChallengeResponse;
import com.oracle.bmc.waas.responses.UpdateGoodBotsResponse;
import com.oracle.bmc.waas.responses.UpdateHumanInteractionChallengeResponse;
import com.oracle.bmc.waas.responses.UpdateJsChallengeResponse;
import com.oracle.bmc.waas.responses.UpdatePolicyConfigResponse;
import com.oracle.bmc.waas.responses.UpdateProtectionRulesResponse;
import com.oracle.bmc.waas.responses.UpdateProtectionSettingsResponse;
import com.oracle.bmc.waas.responses.UpdateThreatFeedsResponse;
import com.oracle.bmc.waas.responses.UpdateWaasPolicyCustomProtectionRulesResponse;
import com.oracle.bmc.waas.responses.UpdateWaasPolicyResponse;
import com.oracle.bmc.waas.responses.UpdateWafAddressRateLimitingResponse;
import com.oracle.bmc.waas.responses.UpdateWafConfigResponse;
import com.oracle.bmc.waas.responses.UpdateWhitelistsResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaasClient
implements Waas {
    private static final Logger LOG = LoggerFactory.getLogger(WaasClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("WAAS").serviceEndpointPrefix("waas").serviceEndpointTemplate("https://waas.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final WaasWaiters waiters;
    private final WaasPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public WaasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public WaasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public WaasClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public WaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public WaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public WaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public WaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public WaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected WaasClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Waas-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new WaasWaiters(executorService, this);
        this.paginators = new WaasPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AcceptRecommendationsResponse acceptRecommendations(AcceptRecommendationsRequest request) {
        LOG.trace("Called acceptRecommendations");
        AcceptRecommendationsRequest interceptedRequest = AcceptRecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AcceptRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AcceptRecommendationsResponse> transformer = AcceptRecommendationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (AcceptRecommendationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AcceptRecommendationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getProtectionRuleKeys(), (BmcRequest)retriedRequest);
                return (AcceptRecommendationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        LOG.trace("Called cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CancelWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (CancelWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeAddressListCompartmentResponse changeAddressListCompartment(ChangeAddressListCompartmentRequest request) {
        LOG.trace("Called changeAddressListCompartment");
        ChangeAddressListCompartmentRequest interceptedRequest = ChangeAddressListCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAddressListCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAddressListCompartmentResponse> transformer = ChangeAddressListCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeAddressListCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeAddressListCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeAddressListCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeAddressListCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeCertificateCompartmentResponse changeCertificateCompartment(ChangeCertificateCompartmentRequest request) {
        LOG.trace("Called changeCertificateCompartment");
        ChangeCertificateCompartmentRequest interceptedRequest = ChangeCertificateCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCertificateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeCertificateCompartmentResponse> transformer = ChangeCertificateCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeCertificateCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeCertificateCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeCertificateCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeCertificateCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeCustomProtectionRuleCompartmentResponse changeCustomProtectionRuleCompartment(ChangeCustomProtectionRuleCompartmentRequest request) {
        LOG.trace("Called changeCustomProtectionRuleCompartment");
        ChangeCustomProtectionRuleCompartmentRequest interceptedRequest = ChangeCustomProtectionRuleCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCustomProtectionRuleCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeCustomProtectionRuleCompartmentResponse> transformer = ChangeCustomProtectionRuleCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeCustomProtectionRuleCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeCustomProtectionRuleCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeCustomProtectionRuleCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeCustomProtectionRuleCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeWaasPolicyCompartmentResponse changeWaasPolicyCompartment(ChangeWaasPolicyCompartmentRequest request) {
        LOG.trace("Called changeWaasPolicyCompartment");
        ChangeWaasPolicyCompartmentRequest interceptedRequest = ChangeWaasPolicyCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeWaasPolicyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeWaasPolicyCompartmentResponse> transformer = ChangeWaasPolicyCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeWaasPolicyCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeWaasPolicyCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeWaasPolicyCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeWaasPolicyCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAddressListResponse createAddressList(CreateAddressListRequest request) {
        LOG.trace("Called createAddressList");
        CreateAddressListRequest interceptedRequest = CreateAddressListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAddressListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAddressListResponse> transformer = CreateAddressListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateAddressListResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateAddressListResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateAddressListDetails(), (BmcRequest)retriedRequest);
                return (CreateAddressListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCertificateResponse createCertificate(CreateCertificateRequest request) {
        LOG.trace("Called createCertificate");
        CreateCertificateRequest interceptedRequest = CreateCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCertificateResponse> transformer = CreateCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateCertificateDetails(), (BmcRequest)retriedRequest);
                return (CreateCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCustomProtectionRuleResponse createCustomProtectionRule(CreateCustomProtectionRuleRequest request) {
        LOG.trace("Called createCustomProtectionRule");
        CreateCustomProtectionRuleRequest interceptedRequest = CreateCustomProtectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCustomProtectionRuleResponse> transformer = CreateCustomProtectionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateCustomProtectionRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateCustomProtectionRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateCustomProtectionRuleDetails(), (BmcRequest)retriedRequest);
                return (CreateCustomProtectionRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateWaasPolicyResponse createWaasPolicy(CreateWaasPolicyRequest request) {
        LOG.trace("Called createWaasPolicy");
        CreateWaasPolicyRequest interceptedRequest = CreateWaasPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateWaasPolicyResponse> transformer = CreateWaasPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateWaasPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateWaasPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateWaasPolicyDetails(), (BmcRequest)retriedRequest);
                return (CreateWaasPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAddressListResponse deleteAddressList(DeleteAddressListRequest request) {
        LOG.trace("Called deleteAddressList");
        DeleteAddressListRequest interceptedRequest = DeleteAddressListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAddressListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAddressListResponse> transformer = DeleteAddressListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteAddressListResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteAddressListResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteAddressListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest request) {
        LOG.trace("Called deleteCertificate");
        DeleteCertificateRequest interceptedRequest = DeleteCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCertificateResponse> transformer = DeleteCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCustomProtectionRuleResponse deleteCustomProtectionRule(DeleteCustomProtectionRuleRequest request) {
        LOG.trace("Called deleteCustomProtectionRule");
        DeleteCustomProtectionRuleRequest interceptedRequest = DeleteCustomProtectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCustomProtectionRuleResponse> transformer = DeleteCustomProtectionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteCustomProtectionRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteCustomProtectionRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteCustomProtectionRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteWaasPolicyResponse deleteWaasPolicy(DeleteWaasPolicyRequest request) {
        LOG.trace("Called deleteWaasPolicy");
        DeleteWaasPolicyRequest interceptedRequest = DeleteWaasPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteWaasPolicyResponse> transformer = DeleteWaasPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DeleteWaasPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteWaasPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteWaasPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAddressListResponse getAddressList(GetAddressListRequest request) {
        LOG.trace("Called getAddressList");
        GetAddressListRequest interceptedRequest = GetAddressListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAddressListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAddressListResponse> transformer = GetAddressListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAddressListResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAddressListResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAddressListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCertificateResponse getCertificate(GetCertificateRequest request) {
        LOG.trace("Called getCertificate");
        GetCertificateRequest interceptedRequest = GetCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCertificateResponse> transformer = GetCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCustomProtectionRuleResponse getCustomProtectionRule(GetCustomProtectionRuleRequest request) {
        LOG.trace("Called getCustomProtectionRule");
        GetCustomProtectionRuleRequest interceptedRequest = GetCustomProtectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCustomProtectionRuleResponse> transformer = GetCustomProtectionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetCustomProtectionRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetCustomProtectionRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetCustomProtectionRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDeviceFingerprintChallengeResponse getDeviceFingerprintChallenge(GetDeviceFingerprintChallengeRequest request) {
        LOG.trace("Called getDeviceFingerprintChallenge");
        GetDeviceFingerprintChallengeRequest interceptedRequest = GetDeviceFingerprintChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeviceFingerprintChallengeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDeviceFingerprintChallengeResponse> transformer = GetDeviceFingerprintChallengeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDeviceFingerprintChallengeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDeviceFingerprintChallengeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDeviceFingerprintChallengeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetHumanInteractionChallengeResponse getHumanInteractionChallenge(GetHumanInteractionChallengeRequest request) {
        LOG.trace("Called getHumanInteractionChallenge");
        GetHumanInteractionChallengeRequest interceptedRequest = GetHumanInteractionChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetHumanInteractionChallengeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetHumanInteractionChallengeResponse> transformer = GetHumanInteractionChallengeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetHumanInteractionChallengeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetHumanInteractionChallengeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetHumanInteractionChallengeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJsChallengeResponse getJsChallenge(GetJsChallengeRequest request) {
        LOG.trace("Called getJsChallenge");
        GetJsChallengeRequest interceptedRequest = GetJsChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJsChallengeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJsChallengeResponse> transformer = GetJsChallengeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJsChallengeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJsChallengeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJsChallengeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPolicyConfigResponse getPolicyConfig(GetPolicyConfigRequest request) {
        LOG.trace("Called getPolicyConfig");
        GetPolicyConfigRequest interceptedRequest = GetPolicyConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPolicyConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPolicyConfigResponse> transformer = GetPolicyConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPolicyConfigResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPolicyConfigResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPolicyConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetProtectionRuleResponse getProtectionRule(GetProtectionRuleRequest request) {
        LOG.trace("Called getProtectionRule");
        GetProtectionRuleRequest interceptedRequest = GetProtectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetProtectionRuleResponse> transformer = GetProtectionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetProtectionRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetProtectionRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetProtectionRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetProtectionSettingsResponse getProtectionSettings(GetProtectionSettingsRequest request) {
        LOG.trace("Called getProtectionSettings");
        GetProtectionSettingsRequest interceptedRequest = GetProtectionSettingsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProtectionSettingsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetProtectionSettingsResponse> transformer = GetProtectionSettingsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetProtectionSettingsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetProtectionSettingsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetProtectionSettingsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWaasPolicyResponse getWaasPolicy(GetWaasPolicyRequest request) {
        LOG.trace("Called getWaasPolicy");
        GetWaasPolicyRequest interceptedRequest = GetWaasPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWaasPolicyResponse> transformer = GetWaasPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWaasPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWaasPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWaasPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWafAddressRateLimitingResponse getWafAddressRateLimiting(GetWafAddressRateLimitingRequest request) {
        LOG.trace("Called getWafAddressRateLimiting");
        GetWafAddressRateLimitingRequest interceptedRequest = GetWafAddressRateLimitingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWafAddressRateLimitingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWafAddressRateLimitingResponse> transformer = GetWafAddressRateLimitingConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWafAddressRateLimitingResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWafAddressRateLimitingResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWafAddressRateLimitingResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWafConfigResponse getWafConfig(GetWafConfigRequest request) {
        LOG.trace("Called getWafConfig");
        GetWafConfigRequest interceptedRequest = GetWafConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWafConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWafConfigResponse> transformer = GetWafConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWafConfigResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWafConfigResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWafConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAccessRulesResponse listAccessRules(ListAccessRulesRequest request) {
        LOG.trace("Called listAccessRules");
        ListAccessRulesRequest interceptedRequest = ListAccessRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAccessRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAccessRulesResponse> transformer = ListAccessRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAccessRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAccessRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAccessRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAddressListsResponse listAddressLists(ListAddressListsRequest request) {
        LOG.trace("Called listAddressLists");
        ListAddressListsRequest interceptedRequest = ListAddressListsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAddressListsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAddressListsResponse> transformer = ListAddressListsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAddressListsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAddressListsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAddressListsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCachingRulesResponse listCachingRules(ListCachingRulesRequest request) {
        LOG.trace("Called listCachingRules");
        ListCachingRulesRequest interceptedRequest = ListCachingRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCachingRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCachingRulesResponse> transformer = ListCachingRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCachingRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCachingRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCachingRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCaptchasResponse listCaptchas(ListCaptchasRequest request) {
        LOG.trace("Called listCaptchas");
        ListCaptchasRequest interceptedRequest = ListCaptchasConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCaptchasConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCaptchasResponse> transformer = ListCaptchasConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCaptchasResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCaptchasResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCaptchasResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCertificatesResponse listCertificates(ListCertificatesRequest request) {
        LOG.trace("Called listCertificates");
        ListCertificatesRequest interceptedRequest = ListCertificatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCertificatesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCertificatesResponse> transformer = ListCertificatesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCertificatesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCertificatesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCertificatesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCustomProtectionRulesResponse listCustomProtectionRules(ListCustomProtectionRulesRequest request) {
        LOG.trace("Called listCustomProtectionRules");
        ListCustomProtectionRulesRequest interceptedRequest = ListCustomProtectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCustomProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCustomProtectionRulesResponse> transformer = ListCustomProtectionRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCustomProtectionRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCustomProtectionRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCustomProtectionRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListEdgeSubnetsResponse listEdgeSubnets(ListEdgeSubnetsRequest request) {
        LOG.trace("Called listEdgeSubnets");
        ListEdgeSubnetsRequest interceptedRequest = ListEdgeSubnetsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEdgeSubnetsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListEdgeSubnetsResponse> transformer = ListEdgeSubnetsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListEdgeSubnetsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListEdgeSubnetsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListEdgeSubnetsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListGoodBotsResponse listGoodBots(ListGoodBotsRequest request) {
        LOG.trace("Called listGoodBots");
        ListGoodBotsRequest interceptedRequest = ListGoodBotsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListGoodBotsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListGoodBotsResponse> transformer = ListGoodBotsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListGoodBotsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListGoodBotsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListGoodBotsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListProtectionRulesResponse listProtectionRules(ListProtectionRulesRequest request) {
        LOG.trace("Called listProtectionRules");
        ListProtectionRulesRequest interceptedRequest = ListProtectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListProtectionRulesResponse> transformer = ListProtectionRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListProtectionRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListProtectionRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListProtectionRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRecommendationsResponse listRecommendations(ListRecommendationsRequest request) {
        LOG.trace("Called listRecommendations");
        ListRecommendationsRequest interceptedRequest = ListRecommendationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRecommendationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRecommendationsResponse> transformer = ListRecommendationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRecommendationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRecommendationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRecommendationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListThreatFeedsResponse listThreatFeeds(ListThreatFeedsRequest request) {
        LOG.trace("Called listThreatFeeds");
        ListThreatFeedsRequest interceptedRequest = ListThreatFeedsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListThreatFeedsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListThreatFeedsResponse> transformer = ListThreatFeedsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListThreatFeedsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListThreatFeedsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListThreatFeedsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWaasPoliciesResponse listWaasPolicies(ListWaasPoliciesRequest request) {
        LOG.trace("Called listWaasPolicies");
        ListWaasPoliciesRequest interceptedRequest = ListWaasPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWaasPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWaasPoliciesResponse> transformer = ListWaasPoliciesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWaasPoliciesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWaasPoliciesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWaasPoliciesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWaasPolicyCustomProtectionRulesResponse listWaasPolicyCustomProtectionRules(ListWaasPolicyCustomProtectionRulesRequest request) {
        LOG.trace("Called listWaasPolicyCustomProtectionRules");
        ListWaasPolicyCustomProtectionRulesRequest interceptedRequest = ListWaasPolicyCustomProtectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWaasPolicyCustomProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWaasPolicyCustomProtectionRulesResponse> transformer = ListWaasPolicyCustomProtectionRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWaasPolicyCustomProtectionRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWaasPolicyCustomProtectionRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWaasPolicyCustomProtectionRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWafBlockedRequestsResponse listWafBlockedRequests(ListWafBlockedRequestsRequest request) {
        LOG.trace("Called listWafBlockedRequests");
        ListWafBlockedRequestsRequest interceptedRequest = ListWafBlockedRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWafBlockedRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWafBlockedRequestsResponse> transformer = ListWafBlockedRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWafBlockedRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWafBlockedRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWafBlockedRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWafLogsResponse listWafLogs(ListWafLogsRequest request) {
        LOG.trace("Called listWafLogs");
        ListWafLogsRequest interceptedRequest = ListWafLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWafLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWafLogsResponse> transformer = ListWafLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWafLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWafLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWafLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWafRequestsResponse listWafRequests(ListWafRequestsRequest request) {
        LOG.trace("Called listWafRequests");
        ListWafRequestsRequest interceptedRequest = ListWafRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWafRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWafRequestsResponse> transformer = ListWafRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWafRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWafRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWafRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWafTrafficResponse listWafTraffic(ListWafTrafficRequest request) {
        LOG.trace("Called listWafTraffic");
        ListWafTrafficRequest interceptedRequest = ListWafTrafficConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWafTrafficConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWafTrafficResponse> transformer = ListWafTrafficConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWafTrafficResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWafTrafficResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWafTrafficResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWhitelistsResponse listWhitelists(ListWhitelistsRequest request) {
        LOG.trace("Called listWhitelists");
        ListWhitelistsRequest interceptedRequest = ListWhitelistsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWhitelistsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWhitelistsResponse> transformer = ListWhitelistsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWhitelistsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWhitelistsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWhitelistsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PurgeCacheResponse purgeCache(PurgeCacheRequest request) {
        LOG.trace("Called purgeCache");
        PurgeCacheRequest interceptedRequest = PurgeCacheConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PurgeCacheConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PurgeCacheResponse> transformer = PurgeCacheConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (PurgeCacheResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PurgeCacheResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getPurgeCache(), (BmcRequest)retriedRequest);
                return (PurgeCacheResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAccessRulesResponse updateAccessRules(UpdateAccessRulesRequest request) {
        LOG.trace("Called updateAccessRules");
        UpdateAccessRulesRequest interceptedRequest = UpdateAccessRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAccessRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAccessRulesResponse> transformer = UpdateAccessRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateAccessRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateAccessRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getAccessRules(), (BmcRequest)retriedRequest);
                return (UpdateAccessRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAddressListResponse updateAddressList(UpdateAddressListRequest request) {
        LOG.trace("Called updateAddressList");
        UpdateAddressListRequest interceptedRequest = UpdateAddressListConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAddressListConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAddressListResponse> transformer = UpdateAddressListConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateAddressListResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateAddressListResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateAddressListDetails(), (BmcRequest)retriedRequest);
                return (UpdateAddressListResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCachingRulesResponse updateCachingRules(UpdateCachingRulesRequest request) {
        LOG.trace("Called updateCachingRules");
        UpdateCachingRulesRequest interceptedRequest = UpdateCachingRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCachingRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCachingRulesResponse> transformer = UpdateCachingRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateCachingRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateCachingRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getCachingRulesDetails(), (BmcRequest)retriedRequest);
                return (UpdateCachingRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCaptchasResponse updateCaptchas(UpdateCaptchasRequest request) {
        LOG.trace("Called updateCaptchas");
        UpdateCaptchasRequest interceptedRequest = UpdateCaptchasConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCaptchasConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCaptchasResponse> transformer = UpdateCaptchasConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateCaptchasResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateCaptchasResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getCaptchas(), (BmcRequest)retriedRequest);
                return (UpdateCaptchasResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCertificateResponse updateCertificate(UpdateCertificateRequest request) {
        LOG.trace("Called updateCertificate");
        UpdateCertificateRequest interceptedRequest = UpdateCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCertificateResponse> transformer = UpdateCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateCertificateDetails(), (BmcRequest)retriedRequest);
                return (UpdateCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCustomProtectionRuleResponse updateCustomProtectionRule(UpdateCustomProtectionRuleRequest request) {
        LOG.trace("Called updateCustomProtectionRule");
        UpdateCustomProtectionRuleRequest interceptedRequest = UpdateCustomProtectionRuleConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCustomProtectionRuleConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCustomProtectionRuleResponse> transformer = UpdateCustomProtectionRuleConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateCustomProtectionRuleResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateCustomProtectionRuleResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateCustomProtectionRuleDetails(), (BmcRequest)retriedRequest);
                return (UpdateCustomProtectionRuleResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDeviceFingerprintChallengeResponse updateDeviceFingerprintChallenge(UpdateDeviceFingerprintChallengeRequest request) {
        LOG.trace("Called updateDeviceFingerprintChallenge");
        UpdateDeviceFingerprintChallengeRequest interceptedRequest = UpdateDeviceFingerprintChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeviceFingerprintChallengeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDeviceFingerprintChallengeResponse> transformer = UpdateDeviceFingerprintChallengeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateDeviceFingerprintChallengeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDeviceFingerprintChallengeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDeviceFingerprintChallengeDetails(), (BmcRequest)retriedRequest);
                return (UpdateDeviceFingerprintChallengeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateGoodBotsResponse updateGoodBots(UpdateGoodBotsRequest request) {
        LOG.trace("Called updateGoodBots");
        UpdateGoodBotsRequest interceptedRequest = UpdateGoodBotsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateGoodBotsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateGoodBotsResponse> transformer = UpdateGoodBotsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateGoodBotsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateGoodBotsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getGoodBots(), (BmcRequest)retriedRequest);
                return (UpdateGoodBotsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateHumanInteractionChallengeResponse updateHumanInteractionChallenge(UpdateHumanInteractionChallengeRequest request) {
        LOG.trace("Called updateHumanInteractionChallenge");
        UpdateHumanInteractionChallengeRequest interceptedRequest = UpdateHumanInteractionChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateHumanInteractionChallengeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateHumanInteractionChallengeResponse> transformer = UpdateHumanInteractionChallengeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateHumanInteractionChallengeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateHumanInteractionChallengeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateHumanInteractionChallengeDetails(), (BmcRequest)retriedRequest);
                return (UpdateHumanInteractionChallengeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateJsChallengeResponse updateJsChallenge(UpdateJsChallengeRequest request) {
        LOG.trace("Called updateJsChallenge");
        UpdateJsChallengeRequest interceptedRequest = UpdateJsChallengeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJsChallengeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateJsChallengeResponse> transformer = UpdateJsChallengeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateJsChallengeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateJsChallengeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateJsChallengeDetails(), (BmcRequest)retriedRequest);
                return (UpdateJsChallengeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePolicyConfigResponse updatePolicyConfig(UpdatePolicyConfigRequest request) {
        LOG.trace("Called updatePolicyConfig");
        UpdatePolicyConfigRequest interceptedRequest = UpdatePolicyConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePolicyConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePolicyConfigResponse> transformer = UpdatePolicyConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdatePolicyConfigResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdatePolicyConfigResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdatePolicyConfigDetails(), (BmcRequest)retriedRequest);
                return (UpdatePolicyConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateProtectionRulesResponse updateProtectionRules(UpdateProtectionRulesRequest request) {
        LOG.trace("Called updateProtectionRules");
        UpdateProtectionRulesRequest interceptedRequest = UpdateProtectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateProtectionRulesResponse> transformer = UpdateProtectionRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateProtectionRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateProtectionRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getProtectionRules(), (BmcRequest)retriedRequest);
                return (UpdateProtectionRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateProtectionSettingsResponse updateProtectionSettings(UpdateProtectionSettingsRequest request) {
        LOG.trace("Called updateProtectionSettings");
        UpdateProtectionSettingsRequest interceptedRequest = UpdateProtectionSettingsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProtectionSettingsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateProtectionSettingsResponse> transformer = UpdateProtectionSettingsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateProtectionSettingsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateProtectionSettingsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateProtectionSettingsDetails(), (BmcRequest)retriedRequest);
                return (UpdateProtectionSettingsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateThreatFeedsResponse updateThreatFeeds(UpdateThreatFeedsRequest request) {
        LOG.trace("Called updateThreatFeeds");
        UpdateThreatFeedsRequest interceptedRequest = UpdateThreatFeedsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateThreatFeedsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateThreatFeedsResponse> transformer = UpdateThreatFeedsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateThreatFeedsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateThreatFeedsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getThreatFeeds(), (BmcRequest)retriedRequest);
                return (UpdateThreatFeedsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateWaasPolicyResponse updateWaasPolicy(UpdateWaasPolicyRequest request) {
        LOG.trace("Called updateWaasPolicy");
        UpdateWaasPolicyRequest interceptedRequest = UpdateWaasPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWaasPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateWaasPolicyResponse> transformer = UpdateWaasPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateWaasPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateWaasPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateWaasPolicyDetails(), (BmcRequest)retriedRequest);
                return (UpdateWaasPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateWaasPolicyCustomProtectionRulesResponse updateWaasPolicyCustomProtectionRules(UpdateWaasPolicyCustomProtectionRulesRequest request) {
        LOG.trace("Called updateWaasPolicyCustomProtectionRules");
        UpdateWaasPolicyCustomProtectionRulesRequest interceptedRequest = UpdateWaasPolicyCustomProtectionRulesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWaasPolicyCustomProtectionRulesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateWaasPolicyCustomProtectionRulesResponse> transformer = UpdateWaasPolicyCustomProtectionRulesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateWaasPolicyCustomProtectionRulesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateWaasPolicyCustomProtectionRulesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateCustomProtectionRulesDetails(), (BmcRequest)retriedRequest);
                return (UpdateWaasPolicyCustomProtectionRulesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateWafAddressRateLimitingResponse updateWafAddressRateLimiting(UpdateWafAddressRateLimitingRequest request) {
        LOG.trace("Called updateWafAddressRateLimiting");
        UpdateWafAddressRateLimitingRequest interceptedRequest = UpdateWafAddressRateLimitingConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWafAddressRateLimitingConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateWafAddressRateLimitingResponse> transformer = UpdateWafAddressRateLimitingConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateWafAddressRateLimitingResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateWafAddressRateLimitingResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateWafAddressRateLimitingDetails(), (BmcRequest)retriedRequest);
                return (UpdateWafAddressRateLimitingResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateWafConfigResponse updateWafConfig(UpdateWafConfigRequest request) {
        LOG.trace("Called updateWafConfig");
        UpdateWafConfigRequest interceptedRequest = UpdateWafConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWafConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateWafConfigResponse> transformer = UpdateWafConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateWafConfigResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateWafConfigResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateWafConfigDetails(), (BmcRequest)retriedRequest);
                return (UpdateWafConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateWhitelistsResponse updateWhitelists(UpdateWhitelistsRequest request) {
        LOG.trace("Called updateWhitelists");
        UpdateWhitelistsRequest interceptedRequest = UpdateWhitelistsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateWhitelistsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateWhitelistsResponse> transformer = UpdateWhitelistsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateWhitelistsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateWhitelistsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getWhitelists(), (BmcRequest)retriedRequest);
                return (UpdateWhitelistsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public WaasWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public WaasPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, WaasClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public WaasClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new WaasClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

