/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.waas.model.AccessRuleCriteria;
import com.oracle.bmc.waas.model.HeaderManipulationAction;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AccessRule {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="criteria")
    private final List<AccessRuleCriteria> criteria;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="blockAction")
    private final BlockAction blockAction;
    @JsonProperty(value="blockResponseCode")
    private final Integer blockResponseCode;
    @JsonProperty(value="blockErrorPageMessage")
    private final String blockErrorPageMessage;
    @JsonProperty(value="blockErrorPageCode")
    private final String blockErrorPageCode;
    @JsonProperty(value="blockErrorPageDescription")
    private final String blockErrorPageDescription;
    @JsonProperty(value="bypassChallenges")
    private final List<BypassChallenges> bypassChallenges;
    @JsonProperty(value="redirectUrl")
    private final String redirectUrl;
    @JsonProperty(value="redirectResponseCode")
    private final RedirectResponseCode redirectResponseCode;
    @JsonProperty(value="captchaTitle")
    private final String captchaTitle;
    @JsonProperty(value="captchaHeader")
    private final String captchaHeader;
    @JsonProperty(value="captchaFooter")
    private final String captchaFooter;
    @JsonProperty(value="captchaSubmitLabel")
    private final String captchaSubmitLabel;
    @JsonProperty(value="responseHeaderManipulation")
    private final List<HeaderManipulationAction> responseHeaderManipulation;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().name(this.name).criteria(this.criteria).action(this.action).blockAction(this.blockAction).blockResponseCode(this.blockResponseCode).blockErrorPageMessage(this.blockErrorPageMessage).blockErrorPageCode(this.blockErrorPageCode).blockErrorPageDescription(this.blockErrorPageDescription).bypassChallenges(this.bypassChallenges).redirectUrl(this.redirectUrl).redirectResponseCode(this.redirectResponseCode).captchaTitle(this.captchaTitle).captchaHeader(this.captchaHeader).captchaFooter(this.captchaFooter).captchaSubmitLabel(this.captchaSubmitLabel).responseHeaderManipulation(this.responseHeaderManipulation);
    }

    public String getName() {
        return this.name;
    }

    public List<AccessRuleCriteria> getCriteria() {
        return this.criteria;
    }

    public Action getAction() {
        return this.action;
    }

    public BlockAction getBlockAction() {
        return this.blockAction;
    }

    public Integer getBlockResponseCode() {
        return this.blockResponseCode;
    }

    public String getBlockErrorPageMessage() {
        return this.blockErrorPageMessage;
    }

    public String getBlockErrorPageCode() {
        return this.blockErrorPageCode;
    }

    public String getBlockErrorPageDescription() {
        return this.blockErrorPageDescription;
    }

    public List<BypassChallenges> getBypassChallenges() {
        return this.bypassChallenges;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public RedirectResponseCode getRedirectResponseCode() {
        return this.redirectResponseCode;
    }

    public String getCaptchaTitle() {
        return this.captchaTitle;
    }

    public String getCaptchaHeader() {
        return this.captchaHeader;
    }

    public String getCaptchaFooter() {
        return this.captchaFooter;
    }

    public String getCaptchaSubmitLabel() {
        return this.captchaSubmitLabel;
    }

    public List<HeaderManipulationAction> getResponseHeaderManipulation() {
        return this.responseHeaderManipulation;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessRule)) {
            return false;
        }
        AccessRule other = (AccessRule)o;
        Integer this$blockResponseCode = this.getBlockResponseCode();
        Integer other$blockResponseCode = other.getBlockResponseCode();
        if (this$blockResponseCode == null ? other$blockResponseCode != null : !((Object)this$blockResponseCode).equals(other$blockResponseCode)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<AccessRuleCriteria> this$criteria = this.getCriteria();
        List<AccessRuleCriteria> other$criteria = other.getCriteria();
        if (this$criteria == null ? other$criteria != null : !((Object)this$criteria).equals(other$criteria)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        BlockAction this$blockAction = this.getBlockAction();
        BlockAction other$blockAction = other.getBlockAction();
        if (this$blockAction == null ? other$blockAction != null : !((Object)((Object)this$blockAction)).equals((Object)other$blockAction)) {
            return false;
        }
        String this$blockErrorPageMessage = this.getBlockErrorPageMessage();
        String other$blockErrorPageMessage = other.getBlockErrorPageMessage();
        if (this$blockErrorPageMessage == null ? other$blockErrorPageMessage != null : !this$blockErrorPageMessage.equals(other$blockErrorPageMessage)) {
            return false;
        }
        String this$blockErrorPageCode = this.getBlockErrorPageCode();
        String other$blockErrorPageCode = other.getBlockErrorPageCode();
        if (this$blockErrorPageCode == null ? other$blockErrorPageCode != null : !this$blockErrorPageCode.equals(other$blockErrorPageCode)) {
            return false;
        }
        String this$blockErrorPageDescription = this.getBlockErrorPageDescription();
        String other$blockErrorPageDescription = other.getBlockErrorPageDescription();
        if (this$blockErrorPageDescription == null ? other$blockErrorPageDescription != null : !this$blockErrorPageDescription.equals(other$blockErrorPageDescription)) {
            return false;
        }
        List<BypassChallenges> this$bypassChallenges = this.getBypassChallenges();
        List<BypassChallenges> other$bypassChallenges = other.getBypassChallenges();
        if (this$bypassChallenges == null ? other$bypassChallenges != null : !((Object)this$bypassChallenges).equals(other$bypassChallenges)) {
            return false;
        }
        String this$redirectUrl = this.getRedirectUrl();
        String other$redirectUrl = other.getRedirectUrl();
        if (this$redirectUrl == null ? other$redirectUrl != null : !this$redirectUrl.equals(other$redirectUrl)) {
            return false;
        }
        RedirectResponseCode this$redirectResponseCode = this.getRedirectResponseCode();
        RedirectResponseCode other$redirectResponseCode = other.getRedirectResponseCode();
        if (this$redirectResponseCode == null ? other$redirectResponseCode != null : !((Object)((Object)this$redirectResponseCode)).equals((Object)other$redirectResponseCode)) {
            return false;
        }
        String this$captchaTitle = this.getCaptchaTitle();
        String other$captchaTitle = other.getCaptchaTitle();
        if (this$captchaTitle == null ? other$captchaTitle != null : !this$captchaTitle.equals(other$captchaTitle)) {
            return false;
        }
        String this$captchaHeader = this.getCaptchaHeader();
        String other$captchaHeader = other.getCaptchaHeader();
        if (this$captchaHeader == null ? other$captchaHeader != null : !this$captchaHeader.equals(other$captchaHeader)) {
            return false;
        }
        String this$captchaFooter = this.getCaptchaFooter();
        String other$captchaFooter = other.getCaptchaFooter();
        if (this$captchaFooter == null ? other$captchaFooter != null : !this$captchaFooter.equals(other$captchaFooter)) {
            return false;
        }
        String this$captchaSubmitLabel = this.getCaptchaSubmitLabel();
        String other$captchaSubmitLabel = other.getCaptchaSubmitLabel();
        if (this$captchaSubmitLabel == null ? other$captchaSubmitLabel != null : !this$captchaSubmitLabel.equals(other$captchaSubmitLabel)) {
            return false;
        }
        List<HeaderManipulationAction> this$responseHeaderManipulation = this.getResponseHeaderManipulation();
        List<HeaderManipulationAction> other$responseHeaderManipulation = other.getResponseHeaderManipulation();
        if (this$responseHeaderManipulation == null ? other$responseHeaderManipulation != null : !((Object)this$responseHeaderManipulation).equals(other$responseHeaderManipulation)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $blockResponseCode = this.getBlockResponseCode();
        result = result * 59 + ($blockResponseCode == null ? 43 : ((Object)$blockResponseCode).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<AccessRuleCriteria> $criteria = this.getCriteria();
        result = result * 59 + ($criteria == null ? 43 : ((Object)$criteria).hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        BlockAction $blockAction = this.getBlockAction();
        result = result * 59 + ($blockAction == null ? 43 : ((Object)((Object)$blockAction)).hashCode());
        String $blockErrorPageMessage = this.getBlockErrorPageMessage();
        result = result * 59 + ($blockErrorPageMessage == null ? 43 : $blockErrorPageMessage.hashCode());
        String $blockErrorPageCode = this.getBlockErrorPageCode();
        result = result * 59 + ($blockErrorPageCode == null ? 43 : $blockErrorPageCode.hashCode());
        String $blockErrorPageDescription = this.getBlockErrorPageDescription();
        result = result * 59 + ($blockErrorPageDescription == null ? 43 : $blockErrorPageDescription.hashCode());
        List<BypassChallenges> $bypassChallenges = this.getBypassChallenges();
        result = result * 59 + ($bypassChallenges == null ? 43 : ((Object)$bypassChallenges).hashCode());
        String $redirectUrl = this.getRedirectUrl();
        result = result * 59 + ($redirectUrl == null ? 43 : $redirectUrl.hashCode());
        RedirectResponseCode $redirectResponseCode = this.getRedirectResponseCode();
        result = result * 59 + ($redirectResponseCode == null ? 43 : ((Object)((Object)$redirectResponseCode)).hashCode());
        String $captchaTitle = this.getCaptchaTitle();
        result = result * 59 + ($captchaTitle == null ? 43 : $captchaTitle.hashCode());
        String $captchaHeader = this.getCaptchaHeader();
        result = result * 59 + ($captchaHeader == null ? 43 : $captchaHeader.hashCode());
        String $captchaFooter = this.getCaptchaFooter();
        result = result * 59 + ($captchaFooter == null ? 43 : $captchaFooter.hashCode());
        String $captchaSubmitLabel = this.getCaptchaSubmitLabel();
        result = result * 59 + ($captchaSubmitLabel == null ? 43 : $captchaSubmitLabel.hashCode());
        List<HeaderManipulationAction> $responseHeaderManipulation = this.getResponseHeaderManipulation();
        result = result * 59 + ($responseHeaderManipulation == null ? 43 : ((Object)$responseHeaderManipulation).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "AccessRule(name=" + this.getName() + ", criteria=" + this.getCriteria() + ", action=" + (Object)((Object)this.getAction()) + ", blockAction=" + (Object)((Object)this.getBlockAction()) + ", blockResponseCode=" + this.getBlockResponseCode() + ", blockErrorPageMessage=" + this.getBlockErrorPageMessage() + ", blockErrorPageCode=" + this.getBlockErrorPageCode() + ", blockErrorPageDescription=" + this.getBlockErrorPageDescription() + ", bypassChallenges=" + this.getBypassChallenges() + ", redirectUrl=" + this.getRedirectUrl() + ", redirectResponseCode=" + (Object)((Object)this.getRedirectResponseCode()) + ", captchaTitle=" + this.getCaptchaTitle() + ", captchaHeader=" + this.getCaptchaHeader() + ", captchaFooter=" + this.getCaptchaFooter() + ", captchaSubmitLabel=" + this.getCaptchaSubmitLabel() + ", responseHeaderManipulation=" + this.getResponseHeaderManipulation() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"name", "criteria", "action", "blockAction", "blockResponseCode", "blockErrorPageMessage", "blockErrorPageCode", "blockErrorPageDescription", "bypassChallenges", "redirectUrl", "redirectResponseCode", "captchaTitle", "captchaHeader", "captchaFooter", "captchaSubmitLabel", "responseHeaderManipulation"})
    @Deprecated
    public AccessRule(String name, List<AccessRuleCriteria> criteria, Action action, BlockAction blockAction, Integer blockResponseCode, String blockErrorPageMessage, String blockErrorPageCode, String blockErrorPageDescription, List<BypassChallenges> bypassChallenges, String redirectUrl, RedirectResponseCode redirectResponseCode, String captchaTitle, String captchaHeader, String captchaFooter, String captchaSubmitLabel, List<HeaderManipulationAction> responseHeaderManipulation) {
        this.name = name;
        this.criteria = criteria;
        this.action = action;
        this.blockAction = blockAction;
        this.blockResponseCode = blockResponseCode;
        this.blockErrorPageMessage = blockErrorPageMessage;
        this.blockErrorPageCode = blockErrorPageCode;
        this.blockErrorPageDescription = blockErrorPageDescription;
        this.bypassChallenges = bypassChallenges;
        this.redirectUrl = redirectUrl;
        this.redirectResponseCode = redirectResponseCode;
        this.captchaTitle = captchaTitle;
        this.captchaHeader = captchaHeader;
        this.captchaFooter = captchaFooter;
        this.captchaSubmitLabel = captchaSubmitLabel;
        this.responseHeaderManipulation = responseHeaderManipulation;
    }

    public static enum RedirectResponseCode {
        MovedPermanently("MOVED_PERMANENTLY"),
        Found("FOUND"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RedirectResponseCode> map;

        private RedirectResponseCode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RedirectResponseCode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RedirectResponseCode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RedirectResponseCode.class);
            map = new HashMap<String, RedirectResponseCode>();
            for (RedirectResponseCode v : RedirectResponseCode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BypassChallenges {
        JsChallenge("JS_CHALLENGE"),
        DeviceFingerprintChallenge("DEVICE_FINGERPRINT_CHALLENGE"),
        HumanInteractionChallenge("HUMAN_INTERACTION_CHALLENGE"),
        Captcha("CAPTCHA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BypassChallenges> map;

        private BypassChallenges(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BypassChallenges create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BypassChallenges', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BypassChallenges.class);
            map = new HashMap<String, BypassChallenges>();
            for (BypassChallenges v : BypassChallenges.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BlockAction {
        SetResponseCode("SET_RESPONSE_CODE"),
        ShowErrorPage("SHOW_ERROR_PAGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BlockAction> map;

        private BlockAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BlockAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BlockAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BlockAction.class);
            map = new HashMap<String, BlockAction>();
            for (BlockAction v : BlockAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Action {
        Allow("ALLOW"),
        Detect("DETECT"),
        Block("BLOCK"),
        Bypass("BYPASS"),
        Redirect("REDIRECT"),
        ShowCaptcha("SHOW_CAPTCHA"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="criteria")
        private List<AccessRuleCriteria> criteria;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="blockAction")
        private BlockAction blockAction;
        @JsonProperty(value="blockResponseCode")
        private Integer blockResponseCode;
        @JsonProperty(value="blockErrorPageMessage")
        private String blockErrorPageMessage;
        @JsonProperty(value="blockErrorPageCode")
        private String blockErrorPageCode;
        @JsonProperty(value="blockErrorPageDescription")
        private String blockErrorPageDescription;
        @JsonProperty(value="bypassChallenges")
        private List<BypassChallenges> bypassChallenges;
        @JsonProperty(value="redirectUrl")
        private String redirectUrl;
        @JsonProperty(value="redirectResponseCode")
        private RedirectResponseCode redirectResponseCode;
        @JsonProperty(value="captchaTitle")
        private String captchaTitle;
        @JsonProperty(value="captchaHeader")
        private String captchaHeader;
        @JsonProperty(value="captchaFooter")
        private String captchaFooter;
        @JsonProperty(value="captchaSubmitLabel")
        private String captchaSubmitLabel;
        @JsonProperty(value="responseHeaderManipulation")
        private List<HeaderManipulationAction> responseHeaderManipulation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder criteria(List<AccessRuleCriteria> criteria) {
            this.criteria = criteria;
            this.__explicitlySet__.add("criteria");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder blockAction(BlockAction blockAction) {
            this.blockAction = blockAction;
            this.__explicitlySet__.add("blockAction");
            return this;
        }

        public Builder blockResponseCode(Integer blockResponseCode) {
            this.blockResponseCode = blockResponseCode;
            this.__explicitlySet__.add("blockResponseCode");
            return this;
        }

        public Builder blockErrorPageMessage(String blockErrorPageMessage) {
            this.blockErrorPageMessage = blockErrorPageMessage;
            this.__explicitlySet__.add("blockErrorPageMessage");
            return this;
        }

        public Builder blockErrorPageCode(String blockErrorPageCode) {
            this.blockErrorPageCode = blockErrorPageCode;
            this.__explicitlySet__.add("blockErrorPageCode");
            return this;
        }

        public Builder blockErrorPageDescription(String blockErrorPageDescription) {
            this.blockErrorPageDescription = blockErrorPageDescription;
            this.__explicitlySet__.add("blockErrorPageDescription");
            return this;
        }

        public Builder bypassChallenges(List<BypassChallenges> bypassChallenges) {
            this.bypassChallenges = bypassChallenges;
            this.__explicitlySet__.add("bypassChallenges");
            return this;
        }

        public Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            this.__explicitlySet__.add("redirectUrl");
            return this;
        }

        public Builder redirectResponseCode(RedirectResponseCode redirectResponseCode) {
            this.redirectResponseCode = redirectResponseCode;
            this.__explicitlySet__.add("redirectResponseCode");
            return this;
        }

        public Builder captchaTitle(String captchaTitle) {
            this.captchaTitle = captchaTitle;
            this.__explicitlySet__.add("captchaTitle");
            return this;
        }

        public Builder captchaHeader(String captchaHeader) {
            this.captchaHeader = captchaHeader;
            this.__explicitlySet__.add("captchaHeader");
            return this;
        }

        public Builder captchaFooter(String captchaFooter) {
            this.captchaFooter = captchaFooter;
            this.__explicitlySet__.add("captchaFooter");
            return this;
        }

        public Builder captchaSubmitLabel(String captchaSubmitLabel) {
            this.captchaSubmitLabel = captchaSubmitLabel;
            this.__explicitlySet__.add("captchaSubmitLabel");
            return this;
        }

        public Builder responseHeaderManipulation(List<HeaderManipulationAction> responseHeaderManipulation) {
            this.responseHeaderManipulation = responseHeaderManipulation;
            this.__explicitlySet__.add("responseHeaderManipulation");
            return this;
        }

        public AccessRule build() {
            AccessRule __instance__ = new AccessRule(this.name, this.criteria, this.action, this.blockAction, this.blockResponseCode, this.blockErrorPageMessage, this.blockErrorPageCode, this.blockErrorPageDescription, this.bypassChallenges, this.redirectUrl, this.redirectResponseCode, this.captchaTitle, this.captchaHeader, this.captchaFooter, this.captchaSubmitLabel, this.responseHeaderManipulation);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(AccessRule o) {
            Builder copiedBuilder = this.name(o.getName()).criteria(o.getCriteria()).action(o.getAction()).blockAction(o.getBlockAction()).blockResponseCode(o.getBlockResponseCode()).blockErrorPageMessage(o.getBlockErrorPageMessage()).blockErrorPageCode(o.getBlockErrorPageCode()).blockErrorPageDescription(o.getBlockErrorPageDescription()).bypassChallenges(o.getBypassChallenges()).redirectUrl(o.getRedirectUrl()).redirectResponseCode(o.getRedirectResponseCode()).captchaTitle(o.getCaptchaTitle()).captchaHeader(o.getCaptchaHeader()).captchaFooter(o.getCaptchaFooter()).captchaSubmitLabel(o.getCaptchaSubmitLabel()).responseHeaderManipulation(o.getResponseHeaderManipulation());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "AccessRule.Builder(name=" + this.name + ", criteria=" + this.criteria + ", action=" + (Object)((Object)this.action) + ", blockAction=" + (Object)((Object)this.blockAction) + ", blockResponseCode=" + this.blockResponseCode + ", blockErrorPageMessage=" + this.blockErrorPageMessage + ", blockErrorPageCode=" + this.blockErrorPageCode + ", blockErrorPageDescription=" + this.blockErrorPageDescription + ", bypassChallenges=" + this.bypassChallenges + ", redirectUrl=" + this.redirectUrl + ", redirectResponseCode=" + (Object)((Object)this.redirectResponseCode) + ", captchaTitle=" + this.captchaTitle + ", captchaHeader=" + this.captchaHeader + ", captchaFooter=" + this.captchaFooter + ", captchaSubmitLabel=" + this.captchaSubmitLabel + ", responseHeaderManipulation=" + this.responseHeaderManipulation + ")";
        }
    }
}

