/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteHttpRedirectRequest
extends BmcRequest<Void> {
    private String httpRedirectId;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    @ConstructorProperties(value={"httpRedirectId", "opcRequestId", "opcRetryToken", "ifMatch"})
    DeleteHttpRedirectRequest(String httpRedirectId, String opcRequestId, String opcRetryToken, String ifMatch) {
        this.httpRedirectId = httpRedirectId;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getHttpRedirectId() {
        return this.httpRedirectId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteHttpRedirectRequest, Void> {
        private String httpRedirectId;
        private String opcRequestId;
        private String opcRetryToken;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteHttpRedirectRequest o) {
            this.httpRedirectId(o.getHttpRedirectId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteHttpRedirectRequest build() {
            DeleteHttpRedirectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder httpRedirectId(String httpRedirectId) {
            this.httpRedirectId = httpRedirectId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteHttpRedirectRequest buildWithoutInvocationCallback() {
            return new DeleteHttpRedirectRequest(this.httpRedirectId, this.opcRequestId, this.opcRetryToken, this.ifMatch);
        }

        public String toString() {
            return "DeleteHttpRedirectRequest.Builder(httpRedirectId=" + this.httpRedirectId + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

