/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListProtectionRulesRequest
extends BmcRequest<Void> {
    private String waasPolicyId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private List<String> modSecurityRuleId;
    private List<Action> action;

    @ConstructorProperties(value={"waasPolicyId", "opcRequestId", "limit", "page", "modSecurityRuleId", "action"})
    ListProtectionRulesRequest(String waasPolicyId, String opcRequestId, Integer limit, String page, List<String> modSecurityRuleId, List<Action> action) {
        this.waasPolicyId = waasPolicyId;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.modSecurityRuleId = modSecurityRuleId;
        this.action = action;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public List<String> getModSecurityRuleId() {
        return this.modSecurityRuleId;
    }

    public List<Action> getAction() {
        return this.action;
    }

    public static class Builder
    implements BmcRequest.Builder<ListProtectionRulesRequest, Void> {
        private String waasPolicyId;
        private String opcRequestId;
        private Integer limit;
        private String page;
        private List<String> modSecurityRuleId;
        private List<Action> action;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListProtectionRulesRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.modSecurityRuleId(o.getModSecurityRuleId());
            this.action(o.getAction());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListProtectionRulesRequest build() {
            ListProtectionRulesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder modSecurityRuleId(List<String> modSecurityRuleId) {
            this.modSecurityRuleId = modSecurityRuleId;
            return this;
        }

        public Builder action(List<Action> action) {
            this.action = action;
            return this;
        }

        public ListProtectionRulesRequest buildWithoutInvocationCallback() {
            return new ListProtectionRulesRequest(this.waasPolicyId, this.opcRequestId, this.limit, this.page, this.modSecurityRuleId, this.action);
        }

        public String toString() {
            return "ListProtectionRulesRequest.Builder(waasPolicyId=" + this.waasPolicyId + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", modSecurityRuleId=" + this.modSecurityRuleId + ", action=" + this.action + ")";
        }
    }

    public static enum Action {
        Off("OFF"),
        Detect("DETECT"),
        Block("BLOCK");

        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Action: " + key);
        }

        static {
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

