/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListWafBlockedRequestsRequest
extends BmcRequest<Void> {
    private String waasPolicyId;
    private String opcRequestId;
    private Date timeObservedGreaterThanOrEqualTo;
    private Date timeObservedLessThan;
    private Integer limit;
    private String page;
    private List<WafFeature> wafFeature;

    @ConstructorProperties(value={"waasPolicyId", "opcRequestId", "timeObservedGreaterThanOrEqualTo", "timeObservedLessThan", "limit", "page", "wafFeature"})
    ListWafBlockedRequestsRequest(String waasPolicyId, String opcRequestId, Date timeObservedGreaterThanOrEqualTo, Date timeObservedLessThan, Integer limit, String page, List<WafFeature> wafFeature) {
        this.waasPolicyId = waasPolicyId;
        this.opcRequestId = opcRequestId;
        this.timeObservedGreaterThanOrEqualTo = timeObservedGreaterThanOrEqualTo;
        this.timeObservedLessThan = timeObservedLessThan;
        this.limit = limit;
        this.page = page;
        this.wafFeature = wafFeature;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Date getTimeObservedGreaterThanOrEqualTo() {
        return this.timeObservedGreaterThanOrEqualTo;
    }

    public Date getTimeObservedLessThan() {
        return this.timeObservedLessThan;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public List<WafFeature> getWafFeature() {
        return this.wafFeature;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWafBlockedRequestsRequest, Void> {
        private String waasPolicyId;
        private String opcRequestId;
        private Date timeObservedGreaterThanOrEqualTo;
        private Date timeObservedLessThan;
        private Integer limit;
        private String page;
        private List<WafFeature> wafFeature;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWafBlockedRequestsRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.timeObservedGreaterThanOrEqualTo(o.getTimeObservedGreaterThanOrEqualTo());
            this.timeObservedLessThan(o.getTimeObservedLessThan());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.wafFeature(o.getWafFeature());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWafBlockedRequestsRequest build() {
            ListWafBlockedRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder timeObservedGreaterThanOrEqualTo(Date timeObservedGreaterThanOrEqualTo) {
            this.timeObservedGreaterThanOrEqualTo = timeObservedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeObservedLessThan(Date timeObservedLessThan) {
            this.timeObservedLessThan = timeObservedLessThan;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder wafFeature(List<WafFeature> wafFeature) {
            this.wafFeature = wafFeature;
            return this;
        }

        public ListWafBlockedRequestsRequest buildWithoutInvocationCallback() {
            return new ListWafBlockedRequestsRequest(this.waasPolicyId, this.opcRequestId, this.timeObservedGreaterThanOrEqualTo, this.timeObservedLessThan, this.limit, this.page, this.wafFeature);
        }

        public String toString() {
            return "ListWafBlockedRequestsRequest.Builder(waasPolicyId=" + this.waasPolicyId + ", opcRequestId=" + this.opcRequestId + ", timeObservedGreaterThanOrEqualTo=" + this.timeObservedGreaterThanOrEqualTo + ", timeObservedLessThan=" + this.timeObservedLessThan + ", limit=" + this.limit + ", page=" + this.page + ", wafFeature=" + this.wafFeature + ")";
        }
    }

    public static enum WafFeature {
        ProtectionRules("PROTECTION_RULES"),
        JsChallenge("JS_CHALLENGE"),
        AccessRules("ACCESS_RULES"),
        ThreatFeeds("THREAT_FEEDS"),
        HumanInteractionChallenge("HUMAN_INTERACTION_CHALLENGE"),
        DeviceFingerprintChallenge("DEVICE_FINGERPRINT_CHALLENGE"),
        Captcha("CAPTCHA"),
        AddressRateLimiting("ADDRESS_RATE_LIMITING");

        private final String value;
        private static Map<String, WafFeature> map;

        private WafFeature(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static WafFeature create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid WafFeature: " + key);
        }

        static {
            map = new HashMap<String, WafFeature>();
            for (WafFeature v : WafFeature.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

