/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.EventListener;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.aq.AQNotificationListener;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.NTFJMSEvent;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.JMSNotificationEvent;
import oracle.jdbc.internal.JMSNotificationListener;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CHANGE_NOTIFICATION})
abstract class NTFRegistration {
    private final boolean jdbcGetsNotification;
    private final String clientHost;
    private final int clientTCPPort;
    private final Properties options;
    private final boolean isPurgeOnNTF;
    private final String username;
    private final int namespace;
    private final int jdbcRegId;
    private final String dbName;
    private final short databaseVersion;
    private NotificationRegistration.RegistrationState state;
    private NTFEventListener[] listeners;
    private NTFEventListener notificationExceptionListener;
    private final Exception[] connectionCreationExceptionArr;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    NTFRegistration(int _jdbcRegId, int _namespace, boolean _jdbcGetsNotification, String _dbName, String _clientHost, int _clientTCPPort, Properties _options, String _username, short _databaseVersion, Exception[] _connectionCreationExceptionArr) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, NTFRegistration.class, $$$methodRef$$$19, null, _jdbcRegId, _namespace, _jdbcGetsNotification, _dbName, _clientHost, _clientTCPPort, _options, _username, _databaseVersion, _connectionCreationExceptionArr);
            }
            this.listeners = new NTFEventListener[0];
            this.namespace = _namespace;
            this.clientHost = _clientHost;
            this.clientTCPPort = _clientTCPPort;
            this.options = _options;
            this.jdbcRegId = _jdbcRegId;
            this.username = _username;
            this.jdbcGetsNotification = _jdbcGetsNotification;
            this.dbName = _dbName;
            this.state = NotificationRegistration.RegistrationState.ACTIVE;
            this.isPurgeOnNTF = this.options != null && this.options.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0;
            this.databaseVersion = _databaseVersion;
            this.connectionCreationExceptionArr = _connectionCreationExceptionArr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, NTFRegistration.class, $$$methodRef$$$19, null);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, NTFRegistration.class, $$$methodRef$$$19, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, NTFRegistration.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    short getDatabaseVersion() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFRegistration.class, $$$methodRef$$$0, this, new Object[0]);
            }
            short s2 = this.databaseVersion;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFRegistration.class, $$$methodRef$$$0, this, s2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFRegistration.class, $$$methodRef$$$0, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFRegistration.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setNotificationExceptionListener(NTFEventListener nTFEventListener) throws SQLException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void lsnr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFRegistration.class, $$$methodRef$$$1, this, nTFEventListener);
            }
            if (this.state == NotificationRegistration.RegistrationState.CLOSED) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(251).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NTFRegistration.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            this.notificationExceptionListener = lsnr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFRegistration.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFRegistration.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFRegistration.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    NTFEventListener getNotificationExceptionListener() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFRegistration.class, $$$methodRef$$$2, this, new Object[0]);
            }
            NTFEventListener nTFEventListener = this.notificationExceptionListener;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFRegistration.class, $$$methodRef$$$2, this, nTFEventListener);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFRegistration.class, $$$methodRef$$$2, this, null);
            }
            return nTFEventListener;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFRegistration.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void addListener(NTFEventListener nTFEventListener) throws SQLException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void l2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFRegistration.class, $$$methodRef$$$3, this, nTFEventListener);
            }
            if (this.state == NotificationRegistration.RegistrationState.CLOSED) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(251).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFRegistration.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            if (!this.jdbcGetsNotification) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 247).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFRegistration.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            int length = this.listeners.length;
            for (int i2 = 0; i2 < length; ++i2) {
                if (this.listeners[i2].getListener() != l2.getListener()) continue;
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 248).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFRegistration.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            NTFEventListener[] listeners2 = new NTFEventListener[length + 1];
            System.arraycopy(this.listeners, 0, listeners2, 0, length);
            listeners2[length] = l2;
            this.listeners = listeners2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFRegistration.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFRegistration.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFRegistration.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void removeListener(EventListener eventListener) throws SQLException {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void l2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFRegistration.class, $$$methodRef$$$4, this, eventListener);
            }
            int i2 = 0;
            int length = this.listeners.length;
            for (i2 = 0; i2 < length && this.listeners[i2].getListener() != l2; ++i2) {
            }
            if (i2 == length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 249).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, NTFRegistration.class, $$$methodRef$$$4, this, sQLException);
                }
                throw sQLException;
            }
            NTFEventListener[] listeners2 = new NTFEventListener[length - 1];
            int offset = 0;
            for (i2 = 0; i2 < length; ++i2) {
                if (this.listeners[i2].getListener() == l2) continue;
                listeners2[offset++] = this.listeners[i2];
            }
            this.listeners = listeners2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFRegistration.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFRegistration.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFRegistration.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void notify(NTFDCNEvent nTFDCNEvent) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void event;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NTFRegistration.class, $$$methodRef$$$5, this, nTFDCNEvent);
            }
            long start = 0L;
            NTFEventListener[] localListeners = this.listeners;
            int length = localListeners.length;
            for (int i2 = 0; i2 < length; ++i2) {
                Executor exec = localListeners[i2].getExecutor();
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFRegistration.notify: listener=" + localListeners[i2] + " with executor=" + exec);
                }
                if (exec != null) {
                    final DatabaseChangeListener l2 = localListeners[i2].getDCNListener();
                    exec.execute(new Runnable((NTFDCNEvent)event){
                        final /* synthetic */ NTFDCNEvent val$event;
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        {
                            this.val$event = nTFDCNEvent;
                        }

                        @Override
                        public void run() {
                            l2.onDatabaseChangeNotification(this.val$event);
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredConstructor(NTFRegistration.class, DatabaseChangeListener.class, NTFDCNEvent.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        }
                    });
                } else {
                    localListeners[i2].getDCNListener().onDatabaseChangeNotification((DatabaseChangeEvent)event);
                }
                if (!bl) continue;
                OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "NTFRegistration.notify: listener=" + localListeners[i2] + " took " + (double)(System.nanoTime() - start) / 1000000.0 + "ms");
            }
            if (event.isDeregistrationEvent() || this.isPurgeOnNTF) {
                PhysicalConnection.ntfManager.removeRegistration(this);
                PhysicalConnection.ntfManager.freeJdbcRegId(this.getJdbcRegId());
                PhysicalConnection.ntfManager.cleanListenersT4C(this.getClientTCPPort());
                this.state = NotificationRegistration.RegistrationState.CLOSED;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFRegistration.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFRegistration.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFRegistration.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void notify(NTFAQEvent nTFAQEvent) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void event;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NTFRegistration.class, $$$methodRef$$$6, this, nTFAQEvent);
            }
            long start = 0L;
            NTFEventListener[] localListeners = this.listeners;
            int length = localListeners.length;
            for (int i2 = 0; i2 < length; ++i2) {
                Executor exec = localListeners[i2].getExecutor();
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$6, Level.FINEST, this.getClass(), $$$methodRef$$$6, "NTFRegistration.notify: listener=" + localListeners[i2] + " with executor=" + exec);
                }
                if (exec != null) {
                    final AQNotificationListener l2 = localListeners[i2].getAQListener();
                    exec.execute(new Runnable((NTFAQEvent)event){
                        final /* synthetic */ NTFAQEvent val$event;
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        {
                            this.val$event = nTFAQEvent;
                        }

                        @Override
                        public void run() {
                            l2.onAQNotification(this.val$event);
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 2.class.getDeclaredConstructor(NTFRegistration.class, AQNotificationListener.class, NTFAQEvent.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                            try {
                                $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        }
                    });
                } else {
                    localListeners[i2].getAQListener().onAQNotification((AQNotificationEvent)event);
                }
                if (!bl) continue;
                OracleLog.debug($$$loggerRef$$$6, Level.FINEST, this.getClass(), $$$methodRef$$$6, "NTFRegistration.notify: listener=" + localListeners[i2] + " took " + (double)(System.nanoTime() - start) / 1000000.0 + "ms");
            }
            if (event.getEventType() == AQNotificationEvent.EventType.DEREG || this.isPurgeOnNTF) {
                PhysicalConnection.ntfManager.removeRegistration(this);
                PhysicalConnection.ntfManager.freeJdbcRegId(this.getJdbcRegId());
                PhysicalConnection.ntfManager.cleanListenersT4C(this.getClientTCPPort());
                this.state = NotificationRegistration.RegistrationState.CLOSED;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NTFRegistration.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFRegistration.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFRegistration.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void notify(NTFJMSEvent nTFJMSEvent) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NTFRegistration.class, $$$methodRef$$$7, this, nTFJMSEvent);
            }
            long start = 0L;
            NTFEventListener[] localListeners = this.listeners;
            int length = localListeners.length;
            for (int i2 = 0; i2 < length; ++i2) {
                void event;
                Executor exec = localListeners[i2].getExecutor();
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$7, Level.FINEST, this.getClass(), $$$methodRef$$$7, "NTFRegistration.notify: listener=" + localListeners[i2] + " with executor=" + exec);
                }
                if (exec != null) {
                    final JMSNotificationListener l2 = localListeners[i2].getJMSListener();
                    exec.execute(new Runnable((NTFJMSEvent)event){
                        final /* synthetic */ NTFJMSEvent val$event;
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        {
                            this.val$event = nTFJMSEvent;
                        }

                        @Override
                        public void run() {
                            l2.onJMSNotification(this.val$event);
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 3.class.getDeclaredConstructor(NTFRegistration.class, JMSNotificationListener.class, NTFJMSEvent.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                            try {
                                $$$methodRef$$$0 = 3.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        }
                    });
                } else {
                    localListeners[i2].getJMSListener().onJMSNotification((JMSNotificationEvent)event);
                }
                if (!bl) continue;
                OracleLog.debug($$$loggerRef$$$7, Level.FINEST, this.getClass(), $$$methodRef$$$7, "NTFRegistration.notify: listener=" + localListeners[i2] + " took " + (double)(System.nanoTime() - start) / 1000000.0 + "ms");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NTFRegistration.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFRegistration.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFRegistration.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    public Properties getRegistrationOptions() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NTFRegistration.class, $$$methodRef$$$8, this, new Object[0]);
            }
            Properties properties = this.options;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NTFRegistration.class, $$$methodRef$$$8, this, properties);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFRegistration.class, $$$methodRef$$$8, this, null);
            }
            return properties;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFRegistration.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    int getJdbcRegId() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NTFRegistration.class, $$$methodRef$$$9, this, new Object[0]);
            }
            int n2 = this.jdbcRegId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NTFRegistration.class, $$$methodRef$$$9, this, n2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFRegistration.class, $$$methodRef$$$9, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFRegistration.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getUserName() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NTFRegistration.class, $$$methodRef$$$10, this, new Object[0]);
            }
            String string = this.username;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NTFRegistration.class, $$$methodRef$$$10, this, string);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFRegistration.class, $$$methodRef$$$10, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFRegistration.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    String getClientHost() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NTFRegistration.class, $$$methodRef$$$11, this, new Object[0]);
            }
            String string = this.clientHost;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFRegistration.class, $$$methodRef$$$11, this, string);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFRegistration.class, $$$methodRef$$$11, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFRegistration.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    int getClientTCPPort() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NTFRegistration.class, $$$methodRef$$$12, this, new Object[0]);
            }
            int n2 = this.clientTCPPort;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NTFRegistration.class, $$$methodRef$$$12, this, n2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFRegistration.class, $$$methodRef$$$12, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFRegistration.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getDatabaseName() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NTFRegistration.class, $$$methodRef$$$13, this, new Object[0]);
            }
            String string = this.dbName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NTFRegistration.class, $$$methodRef$$$13, this, string);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFRegistration.class, $$$methodRef$$$13, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NTFRegistration.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    public NotificationRegistration.RegistrationState getState() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NTFRegistration.class, $$$methodRef$$$14, this, new Object[0]);
            }
            NotificationRegistration.RegistrationState registrationState = this.state;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NTFRegistration.class, $$$methodRef$$$14, this, (Object)registrationState);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NTFRegistration.class, $$$methodRef$$$14, this, null);
            }
            return registrationState;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NTFRegistration.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setState(NotificationRegistration.RegistrationState registrationState) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _state;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, NTFRegistration.class, $$$methodRef$$$15, this, new Object[]{registrationState});
            }
            this.state = _state;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, NTFRegistration.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NTFRegistration.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NTFRegistration.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    int getNamespace() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, NTFRegistration.class, $$$methodRef$$$16, this, new Object[0]);
            }
            int n2 = this.namespace;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, NTFRegistration.class, $$$methodRef$$$16, this, n2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NTFRegistration.class, $$$methodRef$$$16, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NTFRegistration.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, NTFRegistration.class, $$$methodRef$$$17, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, NTFRegistration.class, $$$methodRef$$$17, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NTFRegistration.class, $$$methodRef$$$17, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NTFRegistration.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    public Exception getRegistrationException() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, NTFRegistration.class, $$$methodRef$$$18, this, new Object[0]);
            }
            if (this.connectionCreationExceptionArr != null && this.connectionCreationExceptionArr.length > 0) {
                Exception exception = this.connectionCreationExceptionArr[0];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, NTFRegistration.class, $$$methodRef$$$18, this, exception);
                    ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NTFRegistration.class, $$$methodRef$$$18, this, null);
                }
                return exception;
            }
            Exception exception = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, NTFRegistration.class, $$$methodRef$$$18, this, exception);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NTFRegistration.class, $$$methodRef$$$18, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NTFRegistration.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$19 = NTFRegistration.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Boolean.TYPE, String.class, String.class, Integer.TYPE, Properties.class, String.class, Short.TYPE, Exception[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = NTFRegistration.class.getDeclaredMethod("getRegistrationException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = NTFRegistration.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = NTFRegistration.class.getDeclaredMethod("getNamespace", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = NTFRegistration.class.getDeclaredMethod("setState", NotificationRegistration.RegistrationState.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = NTFRegistration.class.getDeclaredMethod("getState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = NTFRegistration.class.getDeclaredMethod("getDatabaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NTFRegistration.class.getDeclaredMethod("getClientTCPPort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFRegistration.class.getDeclaredMethod("getClientHost", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFRegistration.class.getDeclaredMethod("getUserName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFRegistration.class.getDeclaredMethod("getJdbcRegId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFRegistration.class.getDeclaredMethod("getRegistrationOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFRegistration.class.getDeclaredMethod("notify", NTFJMSEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFRegistration.class.getDeclaredMethod("notify", NTFAQEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFRegistration.class.getDeclaredMethod("notify", NTFDCNEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFRegistration.class.getDeclaredMethod("removeListener", EventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFRegistration.class.getDeclaredMethod("addListener", NTFEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFRegistration.class.getDeclaredMethod("getNotificationExceptionListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFRegistration.class.getDeclaredMethod("setNotificationExceptionListener", NTFEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFRegistration.class.getDeclaredMethod("getDatabaseVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

