/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class RefTypeAccessor
extends TypeAccessor {
    static final int MAXLENGTH = -1;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    RefTypeAccessor(OracleStatement stmt, String typeName, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.REF_TYPE, stmt, -1, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$6, null, stmt, typeName, form, external_type, forBind);
            }
            this.init(stmt, 111, 111, form, forBind);
            this.initForDataAccess(external_type, 0, typeName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    RefTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, String typeName) throws SQLException {
        super(Representation.REF_TYPE, stmt, -1, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$7, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            }
            this.init(stmt, 111, 111, form, false);
            this.initForDescribe(111, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            this.initForDataAccess(0, max_len, typeName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    RefTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, String typeName, OracleType otype) throws SQLException {
        super(Representation.REF_TYPE, stmt, -1, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$8, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName, otype);
            }
            this.init(stmt, 111, 111, form, false);
            this.describeOtype = otype;
            this.initForDescribe(111, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
            this.internalOtype = otype;
            this.initForDataAccess(0, max_len, typeName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OracleType otypeFromName(String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void typeName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$0, this, string);
            }
            if (!this.outBind) {
                OracleNamedType oracleNamedType = TypeDescriptor.getTypeDescriptor((String)typeName, this.statement.connection).getPickler();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$0, this, oracleNamedType);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$0, this, null);
                }
                return oracleNamedType;
            }
            OracleTypeADT oracleTypeADT = StructDescriptor.createDescriptor((String)typeName, (Connection)this.statement.connection).getOracleTypeADT();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$0, this, oracleTypeADT);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$0, this, null);
            }
            return oracleTypeADT;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void typeName;
            void max_len;
            void external_type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$1, this, n2, n3, string);
            }
            super.initForDataAccess((int)external_type, (int)max_len, (String)typeName);
            this.byteLength = this.statement.connection.refTypeAccessorByteLen;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    REF getREF(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                REF rEF = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$2, this, rEF);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$2, this, null);
                }
                return null;
            }
            byte[] data = this.pickledBytes((int)currentRow);
            OracleTypeADT otype = (OracleTypeADT)this.internalOtype;
            REF rEF = new REF(otype.getFullName(), (Connection)this.statement.connection, data);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$2, this, rEF);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$2, this, null);
            }
            return rEF;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$3, this, n2);
            }
            Object object = this.getObject((int)currentRow, this.statement.connection.getTypeMap());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$3, this, object);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$3, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$4, this, n2);
            }
            REF rEF = this.getREF((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$4, this, rEF);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$4, this, null);
            }
            return rEF;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void map2;
            void currentRow;
            REF ref;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$5, this, n2, map);
            }
            if ((ref = this.getREF((int)currentRow)) == null) {
                Object var5_5 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$5, this, var5_5);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            Object object = ref.toJdbc((Map)map2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$5, this, object);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$5, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, RefTypeAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$8 = RefTypeAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, String.class, OracleType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = RefTypeAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = RefTypeAccessor.class.getDeclaredConstructor(OracleStatement.class, String.class, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = RefTypeAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = RefTypeAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = RefTypeAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = RefTypeAccessor.class.getDeclaredMethod("getREF", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = RefTypeAccessor.class.getDeclaredMethod("initForDataAccess", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = RefTypeAccessor.class.getDeclaredMethod("otypeFromName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

