/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class TimestampltzAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 11;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    TimestampltzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.TIMESTAMPLTZ, stmt, 11, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$14, null, stmt, max_len, form, external_type, forBind);
            }
            this.init(stmt, 231, 231, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    TimestampltzAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.TIMESTAMPLTZ, stmt, 11, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$15, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.init(stmt, 231, 231, form, false);
            this.initForDescribe(231, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$0, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$0, this, string);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$0, this, null);
                }
                return null;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            TimeZone zone = TimeZone.getTimeZone(sessTzStr);
            Calendar sessTzCal = Calendar.getInstance(zone);
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            int year = this.oracleYear(this.tmpBytes);
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(this.tmpBytes));
            dbTzCal.set(5, this.oracleDay(this.tmpBytes));
            dbTzCal.set(11, this.oracleHour(this.tmpBytes));
            dbTzCal.set(12, this.oracleMin(this.tmpBytes));
            dbTzCal.set(13, this.oracleSec(this.tmpBytes));
            dbTzCal.set(14, 0);
            oracle.sql.TIMESTAMPLTZ.TimeZoneAdjust(this.statement.connection, dbTzCal, sessTzCal);
            year = sessTzCal.get(1);
            int month = sessTzCal.get(2) + 1;
            int date = sessTzCal.get(5);
            int hour = sessTzCal.get(11);
            int minute = sessTzCal.get(12);
            int second = sessTzCal.get(13);
            int nanos = 0;
            boolean am2 = hour < 12;
            String regname = sessTzCal.getTimeZone().getID();
            if (regname.length() > 3 && regname.startsWith("GMT")) {
                regname = regname.substring(3);
            }
            if (this.getLength((int)currentRow) == 11) {
                nanos = this.oracleNanos(this.tmpBytes);
            }
            String string = this.toText(year, month, date, hour, minute, second, nanos, am2, regname);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$0, this, string);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$0, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Date getDate(int n2, Calendar calendar) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$1, this, n2, calendar);
            }
            Date date = this.getDate((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$1, this, date);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$1, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Date getDate(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                Date date = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$2, this, date);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$2, this, null);
                }
                return null;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            int year = this.oracleYear(this.tmpBytes);
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(this.tmpBytes));
            dbTzCal.set(5, this.oracleDay(this.tmpBytes));
            dbTzCal.set(11, this.oracleHour(this.tmpBytes));
            dbTzCal.set(12, this.oracleMin(this.tmpBytes));
            dbTzCal.set(13, this.oracleSec(this.tmpBytes));
            dbTzCal.set(14, 0);
            long millis = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, dbTzCal);
            Date date = new Date(millis);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$2, this, date);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$2, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Time getTime(int n2, Calendar calendar) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$3, this, n2, calendar);
            }
            Time time = this.getTime((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$3, this, time);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$3, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Time getTime(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$4, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                Time time = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$4, this, time);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$4, this, null);
                }
                return null;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$4, this, sQLException);
                }
                throw sQLException;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            int year = this.oracleYear(this.tmpBytes);
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(this.tmpBytes));
            dbTzCal.set(5, this.oracleDay(this.tmpBytes));
            dbTzCal.set(11, this.oracleHour(this.tmpBytes));
            dbTzCal.set(12, this.oracleMin(this.tmpBytes));
            dbTzCal.set(13, this.oracleSec(this.tmpBytes));
            dbTzCal.set(14, 0);
            long millis = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, dbTzCal);
            Time time = new Time(millis);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$4, this, time);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$4, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$5, this, n2, calendar);
            }
            Timestamp timestamp = this.getTimestamp((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$5, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$5, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$6, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                Timestamp timestamp = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$6, this, timestamp);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$6, this, null);
                }
                return null;
            }
            Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
            String sessTzStr = this.statement.connection.getSessionTimeZone();
            if (sessTzStr == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$6, this, sQLException);
                }
                throw sQLException;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            int year = this.oracleYear(this.tmpBytes);
            dbTzCal.set(1, year);
            dbTzCal.set(2, this.oracleMonth(this.tmpBytes));
            dbTzCal.set(5, this.oracleDay(this.tmpBytes));
            dbTzCal.set(11, this.oracleHour(this.tmpBytes));
            dbTzCal.set(12, this.oracleMin(this.tmpBytes));
            dbTzCal.set(13, this.oracleSec(this.tmpBytes));
            dbTzCal.set(14, 0);
            long millis = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, dbTzCal);
            Timestamp result = new Timestamp(millis);
            if (this.getLength((int)currentRow) == 11) {
                result.setNanos(this.oracleNanos(this.tmpBytes));
            }
            Timestamp timestamp = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$6, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$6, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$7, this, n2);
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = this.getTIMESTAMPLTZ((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$7, this, tIMESTAMPLTZ);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$7, this, null);
            }
            return tIMESTAMPLTZ;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$8, this, n2);
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = this.getTIMESTAMPLTZ((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$8, this, tIMESTAMPLTZ);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$8, this, null);
            }
            return tIMESTAMPLTZ;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$9, this, n2, map);
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = this.getTIMESTAMPLTZ((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$9, this, tIMESTAMPLTZ);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$9, this, null);
            }
            return tIMESTAMPLTZ;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$10, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                TIMESTAMPLTZ tIMESTAMPLTZ = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$10, this, tIMESTAMPLTZ);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$10, this, null);
                }
                return null;
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = new TIMESTAMPLTZ(this.getBytesInternal((int)currentRow));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$10, this, tIMESTAMPLTZ);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$10, this, null);
            }
            return tIMESTAMPLTZ;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$11, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                TIMESTAMPTZ tIMESTAMPTZ = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$11, this, tIMESTAMPTZ);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$11, this, null);
                }
                return null;
            }
            TIMESTAMPTZ tIMESTAMPTZ = oracle.sql.TIMESTAMPLTZ.toTIMESTAMPTZ(this.statement.connection, this.getBytesInternal((int)currentRow));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$11, this, tIMESTAMPTZ);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$11, this, null);
            }
            return tIMESTAMPTZ;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$12, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                TIMESTAMP tIMESTAMP = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$12, this, tIMESTAMP);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$12, this, null);
                }
                return null;
            }
            TIMESTAMPTZ tmtz = this.getTIMESTAMPTZ((int)currentRow);
            TIMESTAMP tIMESTAMP = oracle.sql.TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, tmtz.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$12, this, tIMESTAMP);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$12, this, null);
            }
            return tIMESTAMP;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    DATE getDATE(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$13, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                DATE dATE = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$13, this, dATE);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$13, this, null);
                }
                return null;
            }
            TIMESTAMPTZ tmtz = this.getTIMESTAMPTZ((int)currentRow);
            DATE dATE = oracle.sql.TIMESTAMPTZ.toDATE(this.statement.connection, tmtz.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$13, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$13, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TimestampltzAccessor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$15 = TimestampltzAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TimestampltzAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TimestampltzAccessor.class.getDeclaredMethod("getDATE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TimestampltzAccessor.class.getDeclaredMethod("getTIMESTAMP", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TimestampltzAccessor.class.getDeclaredMethod("getTIMESTAMPTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TimestampltzAccessor.class.getDeclaredMethod("getTIMESTAMPLTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TimestampltzAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TimestampltzAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TimestampltzAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TimestampltzAccessor.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TimestampltzAccessor.class.getDeclaredMethod("getTimestamp", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimestampltzAccessor.class.getDeclaredMethod("getTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimestampltzAccessor.class.getDeclaredMethod("getTime", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimestampltzAccessor.class.getDeclaredMethod("getDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimestampltzAccessor.class.getDeclaredMethod("getDate", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimestampltzAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

