/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.transaction.xa.XAResource;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleConnectionCacheEntry;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
public class OraclePooledConnection
implements oracle.jdbc.datasource.OraclePooledConnection,
Serializable {
    static final long serialVersionUID = -203725628718322873L;
    public static final String url_string = "connection_url";
    public static final String pool_auto_commit_string = "pool_auto_commit";
    public static final String object_type_map = "obj_type_map";
    public static final String transaction_isolation = "trans_isolation";
    public static final String statement_cache_size = "stmt_cache_size";
    public static final String isClearMetaData = "stmt_cache_clear_metadata";
    public static final String ImplicitStatementCachingEnabled = "ImplicitStatementCachingEnabled";
    public static final String ExplicitStatementCachingEnabled = "ExplicitStatementCachingEnabled";
    public static final String LoginTimeout = "LoginTimeout";
    public static final String connect_auto_commit_string = "connect_auto_commit";
    public static final String implicit_caching_enabled = "implicit_cache_enabled";
    public static final String explicit_caching_enabled = "explict_cache_enabled";
    public static final String connection_properties_string = "connection_properties";
    public static final String event_listener_string = "event_listener";
    public static final String sql_exception_string = "sql_exception";
    public static final String close_callback_string = "close_callback";
    public static final String private_data = "private_data";
    static final int CONNECTION_CLOSED_EVENT = 101;
    static final int CONNECTION_ERROROCCURED_EVENT = 102;
    private Hashtable eventListeners;
    private SQLException sqlException;
    protected boolean autoCommit;
    private ConnectionEventListener iccEventListener;
    protected transient OracleConnection logicalHandle;
    protected transient OracleConnection physicalConn;
    protected transient OracleConnection replayConn;
    private Hashtable connectionProperty;
    public Properties cachedConnectionAttributes;
    public Properties unMatchedCachedConnAttr;
    public int closeOption;
    private String pcKey;
    private OracleCloseCallback closeCallback;
    private Object privateData;
    private long lastAccessedTime;
    protected String dataSourceInstanceNameKey;
    protected String dataSourceHostNameKey;
    protected String dataSourceDbUniqNameKey;
    protected boolean connectionMarkedDown;
    protected boolean needToAbort;
    protected transient OracleDriver oracleDriver;
    boolean localTxnCommitOnClose;
    public static final String NO_IMPLICIT_BEGIN_REQUEST_PROPERTY = "oracle.jdbc.noImplicitBeginRequest";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;

    public OraclePooledConnection() {
        this((Connection)null);
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$46, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$46, null);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$46, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$46, null, throwable2);
            }
            throw throwable;
        }
    }

    public OraclePooledConnection(String url) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$47, null, url);
            }
            this.eventListeners = null;
            this.sqlException = null;
            this.autoCommit = true;
            this.iccEventListener = null;
            this.logicalHandle = null;
            this.physicalConn = null;
            this.replayConn = null;
            this.connectionProperty = null;
            this.cachedConnectionAttributes = null;
            this.unMatchedCachedConnAttr = null;
            this.closeOption = 0;
            this.pcKey = null;
            this.closeCallback = null;
            this.privateData = null;
            this.lastAccessedTime = 0L;
            this.dataSourceInstanceNameKey = null;
            this.dataSourceHostNameKey = null;
            this.dataSourceDbUniqNameKey = null;
            this.connectionMarkedDown = false;
            this.needToAbort = false;
            this.oracleDriver = new OracleDriver();
            this.localTxnCommitOnClose = false;
            Connection conn = this.oracleDriver.connect(url, new Properties());
            if (conn == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$47, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$47, null, sQLException);
                }
                throw sQLException;
            }
            this.initialize(conn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$47, null);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$47, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$47, null, throwable2);
            }
            throw throwable;
        }
    }

    public OraclePooledConnection(String url, String user, @Blind String passwd) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$48, null, url, user, "*****");
            }
            this.eventListeners = null;
            this.sqlException = null;
            this.autoCommit = true;
            this.iccEventListener = null;
            this.logicalHandle = null;
            this.physicalConn = null;
            this.replayConn = null;
            this.connectionProperty = null;
            this.cachedConnectionAttributes = null;
            this.unMatchedCachedConnAttr = null;
            this.closeOption = 0;
            this.pcKey = null;
            this.closeCallback = null;
            this.privateData = null;
            this.lastAccessedTime = 0L;
            this.dataSourceInstanceNameKey = null;
            this.dataSourceHostNameKey = null;
            this.dataSourceDbUniqNameKey = null;
            this.connectionMarkedDown = false;
            this.needToAbort = false;
            this.oracleDriver = new OracleDriver();
            this.localTxnCommitOnClose = false;
            Properties props = new Properties();
            props.put("user", user);
            props.put("password", passwd);
            Connection conn = this.oracleDriver.connect(url, props);
            if (conn == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$48, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$48, null, sQLException);
                }
                throw sQLException;
            }
            this.initialize(conn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$48, null);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$48, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$48, null, throwable2);
            }
            throw throwable;
        }
    }

    public OraclePooledConnection(Connection pc) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$49, null, pc);
            }
            this.eventListeners = null;
            this.sqlException = null;
            this.autoCommit = true;
            this.iccEventListener = null;
            this.logicalHandle = null;
            this.physicalConn = null;
            this.replayConn = null;
            this.connectionProperty = null;
            this.cachedConnectionAttributes = null;
            this.unMatchedCachedConnAttr = null;
            this.closeOption = 0;
            this.pcKey = null;
            this.closeCallback = null;
            this.privateData = null;
            this.lastAccessedTime = 0L;
            this.dataSourceInstanceNameKey = null;
            this.dataSourceHostNameKey = null;
            this.dataSourceDbUniqNameKey = null;
            this.connectionMarkedDown = false;
            this.needToAbort = false;
            this.oracleDriver = new OracleDriver();
            this.localTxnCommitOnClose = false;
            this.initialize(pc);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$49, null);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$49, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$49, null, throwable2);
            }
            throw throwable;
        }
    }

    public OraclePooledConnection(Connection pc, boolean ac2) {
        this(pc);
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$50, null, pc, ac2);
            }
            this.autoCommit = ac2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$50, null);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$50, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$50, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initialize(Connection connection) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void pc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$0, this, connection);
            }
            this.physicalConn = (OracleConnection)pc;
            this.eventListeners = new Hashtable(10);
            this.closeCallback = null;
            this.privateData = null;
            this.lastAccessedTime = 0L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$1, this, connectionEventListener);
            }
            if (this.eventListeners == null) {
                this.sqlException = new SQLException("Listener Hashtable Null");
            } else {
                void cel;
                this.eventListeners.put(cel, cel);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (this.closeCallback != null) {
                this.closeCallback.beforeClose(this.physicalConn, this.privateData);
            }
            if (this.physicalConn != null) {
                block10: {
                    try {
                        this.physicalConn.close();
                    }
                    catch (SQLException ea) {
                        if (!bl) break block10;
                        this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OraclePooledConnection.close():" + this.physicalConn + ": Error while closing the connection " + ea.getMessage());
                    }
                }
                this.physicalConn = null;
            }
            if (this.closeCallback != null) {
                this.closeCallback.afterClose(this.privateData);
            }
            this.lastAccessedTime = 0L;
            this.iccEventListener = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.physicalConn == null) {
                this.sqlException = new SQLException("Physical Connection doesn't exist");
                this.callListener(102);
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(8).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            try {
                if (this.logicalHandle != null) {
                    this.logicalHandle.closeInternal(false);
                }
                OracleConnection pconn = this.replayConn != null ? this.replayConn : this.physicalConn;
                this.logicalHandle = (OracleConnection)pconn.getLogicalConnection(this, this.autoCommit);
                String propVal = OraclePooledConnection.getSystemProperty(NO_IMPLICIT_BEGIN_REQUEST_PROPERTY, "false");
                if (propVal.equalsIgnoreCase("false") && !pconn.isDRCPEnabled()) {
                    pconn.beginRequest();
                }
            }
            catch (SQLException se) {
                this.sqlException = se;
                this.callListener(102);
                this.callImplicitCacheListener(102);
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(8, "OraclePooledConnection.getConnection() - SQLException Ocurred:" + se.getMessage()).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            OracleConnection oracleConnection = this.logicalHandle;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getSystemProperty(String string, String string2) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void defaultValue;
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, string, string2);
            }
            if (str != null) {
                final String fstr = str;
                void fdefaultValue = defaultValue;
                final String[] rets = new String[]{defaultValue};
                AccessController.doPrivileged(new PrivilegedAction((String)fdefaultValue){
                    final /* synthetic */ String val$fdefaultValue;
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    {
                        this.val$fdefaultValue = string2;
                    }

                    public Object run() {
                        rets[0] = System.getProperty(fstr, this.val$fdefaultValue);
                        return null;
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(String[].class, String.class, String.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
                String string3 = rets[0];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, string3);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, null);
                }
                return string3;
            }
            void var6_7 = defaultValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, var6_7);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, null);
            }
            return var6_7;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Connection getLogicalHandle() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$5, this, new Object[0]);
            }
            OracleConnection oracleConnection = this.logicalHandle;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$5, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$5, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    public Connection getPhysicalHandle() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleConnection oracleConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$6, this, new Object[0]);
            }
            OracleConnection oracleConnection2 = oracleConnection = this.replayConn != null ? this.replayConn : this.physicalConn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$6, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$6, this, null);
            }
            return oracleConnection2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setLastAccessedTime(long l2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void lastAccessedTime;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$7, this, l2);
            }
            this.lastAccessedTime = lastAccessedTime;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getLastAccessedTime() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$8, this, new Object[0]);
            }
            long l2 = this.lastAccessedTime;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$8, this, l2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$8, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void privData;
            void occ;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$9, this, oracleCloseCallback, object);
            }
            this.closeCallback = occ;
            this.privateData = privData;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$10, this, connectionEventListener);
            }
            if (this.eventListeners == null) {
                this.sqlException = new SQLException("Listener Hashtable Null");
            } else {
                void cel;
                this.eventListeners.remove(cel);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void registerImplicitCacheConnectionEventListener(ConnectionEventListener connectionEventListener) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$11, this, connectionEventListener);
            }
            if (this.iccEventListener != null) {
                this.sqlException = new SQLException("Implicit cache listeneralready registered");
            } else {
                void cel;
                this.iccEventListener = cel;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    public void logicalCloseForImplicitConnectionCache() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$12, this, new Object[0]);
            }
            if (this.closeOption == 4096) {
                this.callImplicitCacheListener(102);
            } else {
                this.callImplicitCacheListener(101);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    public void logicalClose() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$13, this, new Object[0]);
            }
            this.logicalClose(true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logicalClose(boolean bl) {
        boolean bl2 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$14, this, bl);
            }
            if (this.cachedConnectionAttributes != null) {
                this.logicalCloseForImplicitConnectionCache();
            } else {
                void isUsable;
                this.callListener(isUsable != false ? 101 : 102);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callListener(int n2) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void callcode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$15, this, n2);
            }
            if (bl) {
                this.debug($$$loggerRef$$$15, Level.FINEST, $$$methodRef$$$15, "OraclePooledConnection.callListener(" + (int)callcode + "): eventListeners=" + this.eventListeners);
            }
            if (this.eventListeners == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$15, this);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$15, this, null);
                }
                return;
            }
            Enumeration listeners = this.eventListeners.keys();
            ConnectionEvent ce = new ConnectionEvent(this, this.sqlException);
            while (listeners.hasMoreElements()) {
                ConnectionEventListener listKey = (ConnectionEventListener)listeners.nextElement();
                ConnectionEventListener cev = (ConnectionEventListener)this.eventListeners.get(listKey);
                if (callcode == 101) {
                    cev.connectionClosed(ce);
                    continue;
                }
                if (callcode != 102) continue;
                cev.connectionErrorOccurred(ce);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callImplicitCacheListener(int n2) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void callcode;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this, n2);
            }
            if (bl) {
                this.debug($$$loggerRef$$$16, Level.FINEST, $$$methodRef$$$16, "OraclePooledConnection.callImplicitCacheListener(" + (int)callcode + "): iccEventListener=" + this.iccEventListener);
            }
            if (this.iccEventListener == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this, null);
                }
                return;
            }
            ConnectionEvent ce = new ConnectionEvent(this, this.sqlException);
            switch (callcode) {
                case 101: {
                    this.iccEventListener.connectionClosed(ce);
                    break;
                }
                case 102: {
                    this.iccEventListener.connectionErrorOccurred(ce);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setStmtCacheSize(int n2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void size;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$17, this, n2);
            }
            this.setStmtCacheSize((int)size, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void size;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$18, this, n2, bl);
            }
            if (size < 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$18, this, sQLException);
                }
                throw sQLException;
            }
            if (this.physicalConn != null) {
                void clearMetaData;
                this.physicalConn.setStmtCacheSize((int)size, (boolean)clearMetaData);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    public synchronized int getStmtCacheSize() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, new Object[0]);
            }
            if (this.physicalConn != null) {
                int n2 = this.physicalConn.getStmtCacheSize();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, null);
                }
                return n2;
            }
            int n3 = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, n3);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, null);
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStatementCacheSize(int n2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$20, this, n2);
            }
            if (this.physicalConn != null) {
                void size;
                this.physicalConn.setStatementCacheSize((int)size);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getStatementCacheSize() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$21, Level.FINEST, $$$methodRef$$$21, "OraclePooledConnection.getStatementCacheSize(): physicalConn=" + this.physicalConn);
            }
            if (this.physicalConn != null) {
                int n2 = this.physicalConn.getStatementCacheSize();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, null);
                }
                return n2;
            }
            int n3 = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, n3);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, null);
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$22, this, bl);
            }
            if (bl2) {
                this.debug($$$loggerRef$$$22, Level.FINEST, $$$methodRef$$$22, "OraclePooledConnection.setImplicitCachingEnabled(" + (boolean)cache + "): physicalConn=" + this.physicalConn);
            }
            if (this.physicalConn != null) {
                this.physicalConn.setImplicitCachingEnabled((boolean)cache);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$23, Level.FINEST, $$$methodRef$$$23, "OraclePooledConnection.getImplicitCachingEnabled(): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                boolean bl2 = this.physicalConn.getImplicitCachingEnabled();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, null);
                }
                return bl2;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$24, this, bl);
            }
            if (bl2) {
                this.debug($$$loggerRef$$$24, Level.FINEST, $$$methodRef$$$24, "OraclePooledConnection.setExplicitCachingEnabled(" + (boolean)cache + ") : physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                this.physicalConn.setExplicitCachingEnabled((boolean)cache);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$25, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$25, Level.FINEST, $$$methodRef$$$25, "OraclePooledConnection.getExplicitCachingEnabled(): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                boolean bl2 = this.physicalConn.getExplicitCachingEnabled();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$25, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$25, this, null);
                }
                return bl2;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$25, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$25, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void purgeImplicitCache() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$26, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$26, Level.FINEST, $$$methodRef$$$26, "OraclePooledConnection.purgeImplicitCache(): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                this.physicalConn.purgeImplicitCache();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void purgeExplicitCache() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$27, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$27, Level.FINEST, $$$methodRef$$$27, "OraclePooledConnection.purgeExplicitCache(): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                this.physicalConn.purgeExplicitCache();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PreparedStatement getStatementWithKey(String string) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, string);
            }
            if (bl) {
                this.debug($$$loggerRef$$$28, Level.FINEST, $$$methodRef$$$28, "OraclePooledConnection.getStatementWithKey(key): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                void key;
                PreparedStatement preparedStatement = this.physicalConn.getStatementWithKey((String)key);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, preparedStatement);
                    ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, null);
                }
                return preparedStatement;
            }
            PreparedStatement preparedStatement = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, preparedStatement);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CallableStatement getCallWithKey(String string) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$29, this, string);
            }
            if (bl) {
                this.debug($$$loggerRef$$$29, Level.FINEST, $$$methodRef$$$29, "OraclePooledConnection.getCallWithKey(key): physicalConn = " + this.physicalConn);
            }
            if (this.physicalConn != null) {
                void key;
                CallableStatement callableStatement = this.physicalConn.getCallWithKey((String)key);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$29, this, callableStatement);
                    ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$29, this, null);
                }
                return callableStatement;
            }
            CallableStatement callableStatement = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$29, this, callableStatement);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$29, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isStatementCacheInitialized() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$30, this, new Object[0]);
            }
            if (this.physicalConn != null) {
                boolean bl2 = this.physicalConn.isStatementCacheInitialized();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$30, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$30, this, null);
                }
                return bl2;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$30, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$30, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setProperties(Hashtable hashtable) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$31, this, hashtable);
            }
            this.connectionProperty = prop;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setUserName(String string, String string2) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _pcKey;
            void userName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$32, this, string, string2);
            }
            this.pcKey = OraclePooledConnection.generateKey((String)userName, (String)_pcKey);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final String generateKey(String string, String string2) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void s2;
            String s1;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$33, null, string, string2);
            }
            String string3 = (s1 != null ? s1.toUpperCase() : null) + (String)s2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$33, null, string3);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$33, null, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$33, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final OracleConnectionCacheEntry addToImplicitCache(HashMap hashMap, OracleConnectionCacheEntry oracleConnectionCacheEntry) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void userConnEntry;
            void userMap;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$34, this, hashMap, oracleConnectionCacheEntry);
            }
            OracleConnectionCacheEntry oracleConnectionCacheEntry2 = (OracleConnectionCacheEntry)userMap.put(this.pcKey, userConnEntry);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$34, this, oracleConnectionCacheEntry2);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$34, this, null);
            }
            return oracleConnectionCacheEntry2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final OracleConnectionCacheEntry removeFromImplictCache(HashMap hashMap) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void userMap;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$35, this, hashMap);
            }
            OracleConnectionCacheEntry oracleConnectionCacheEntry = (OracleConnectionCacheEntry)userMap.get(this.pcKey);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$35, this, oracleConnectionCacheEntry);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$35, this, null);
            }
            return oracleConnectionCacheEntry;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean isSameUser(String string, @Blind String string2) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void passwd;
            void user;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$36, this, string, "*****");
            }
            boolean bl3 = bl2 = user != null && passwd != null && this.pcKey.equalsIgnoreCase((String)user + (String)passwd);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$36, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$36, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$37, this, new Object[0]);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$37, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$37, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block11: {
                void out;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$38, this, objectOutputStream);
                }
                out.defaultWriteObject();
                try {
                    this.physicalConn.getPropertyForPooledConnection(this);
                    if (this.eventListeners != null) {
                        this.connectionProperty.put(event_listener_string, this.eventListeners);
                    }
                    if (this.sqlException != null) {
                        this.connectionProperty.put(sql_exception_string, this.sqlException);
                    }
                    this.connectionProperty.put(pool_auto_commit_string, "" + this.autoCommit);
                    if (this.closeCallback != null) {
                        this.connectionProperty.put(close_callback_string, this.closeCallback);
                    }
                    if (this.privateData != null) {
                        this.connectionProperty.put(private_data, this.privateData);
                    }
                    out.writeObject(this.connectionProperty);
                    this.physicalConn.close();
                }
                catch (SQLException ea) {
                    if (!bl) break block11;
                    this.debug($$$loggerRef$$$38, Level.FINEST, $$$methodRef$$$38, "OraclePooledConnection : writeObject(ObjectInputStream) - Exception Occurred :" + ea.getMessage());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$38, this);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$38, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block13: {
                void in;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$39, this, objectInputStream);
                }
                in.defaultReadObject();
                this.connectionProperty = (Hashtable)in.readObject();
                try {
                    Properties prop = (Properties)this.connectionProperty.get(connection_properties_string);
                    String l_url = prop.getProperty(url_string);
                    this.oracleDriver = new OracleDriver();
                    Connection conn = this.oracleDriver.connect(l_url, prop);
                    this.initialize(conn);
                    this.eventListeners = (Hashtable)this.connectionProperty.get(event_listener_string);
                    this.sqlException = (SQLException)this.connectionProperty.get(sql_exception_string);
                    this.autoCommit = ((String)this.connectionProperty.get(pool_auto_commit_string)).equals("true");
                    this.closeCallback = (OracleCloseCallback)this.connectionProperty.get(close_callback_string);
                    this.privateData = this.connectionProperty.get(private_data);
                    Map l_map = (Map)this.connectionProperty.get(object_type_map);
                    if (l_map != null) {
                        ((OracleConnection)conn).setTypeMap(l_map);
                    }
                    String l_tmp = prop.getProperty(transaction_isolation);
                    conn.setTransactionIsolation(Integer.parseInt(l_tmp));
                    l_tmp = prop.getProperty(statement_cache_size);
                    int l_statementCacheSize = Integer.parseInt(l_tmp);
                    if (l_statementCacheSize != -1) {
                        this.setStatementCacheSize(l_statementCacheSize);
                        l_tmp = prop.getProperty(implicit_caching_enabled);
                        if (l_tmp != null && l_tmp.equalsIgnoreCase("true")) {
                            this.setImplicitCachingEnabled(true);
                        } else {
                            this.setImplicitCachingEnabled(false);
                        }
                        l_tmp = prop.getProperty(explicit_caching_enabled);
                        if (l_tmp != null && l_tmp.equalsIgnoreCase("true")) {
                            this.setExplicitCachingEnabled(true);
                        } else {
                            this.setExplicitCachingEnabled(false);
                        }
                    }
                    this.physicalConn.setAutoCommit(((String)prop.get(connect_auto_commit_string)).equals("true"));
                }
                catch (Exception ea) {
                    if (!bl) break block13;
                    this.debug($$$loggerRef$$$39, Level.FINEST, $$$methodRef$$$39, "OraclePooledConnection : readObject(ObjectInputStream) - Exception Occurred :" + ea.getMessage());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$39, this);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$39, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$40, this, statementEventListener);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$40, this);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$40, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$41, this, statementEventListener);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$41, this);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$41, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rconn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$42, this, oracleConnection);
            }
            this.physicalConn = rconn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$42, this);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$42, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2, int n2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timeout;
            void superShardingKey;
            void shardingKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$43, this, oracleShardingKey, oracleShardingKey2, n2);
            }
            boolean bl2 = this.physicalConn.setShardingKeyIfValid((OracleShardingKey)shardingKey, (OracleShardingKey)superShardingKey, (int)timeout);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$43, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$43, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setShardingKey(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            void superShardingKey;
            void shardingKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$44, this, oracleShardingKey, oracleShardingKey2);
            }
            this.physicalConn.setShardingKey((OracleShardingKey)shardingKey, (OracleShardingKey)superShardingKey);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$44, this);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$44, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$45, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$45, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$45, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OraclePooledConnection.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$50 = OraclePooledConnection.class.getDeclaredConstructor(Connection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OraclePooledConnection.class.getDeclaredConstructor(Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OraclePooledConnection.class.getDeclaredConstructor(String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OraclePooledConnection.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OraclePooledConnection.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OraclePooledConnection.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OraclePooledConnection.class.getDeclaredMethod("setShardingKey", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OraclePooledConnection.class.getDeclaredMethod("setShardingKeyIfValid", OracleShardingKey.class, OracleShardingKey.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OraclePooledConnection.class.getDeclaredMethod("setConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OraclePooledConnection.class.getDeclaredMethod("removeStatementEventListener", StatementEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OraclePooledConnection.class.getDeclaredMethod("addStatementEventListener", StatementEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OraclePooledConnection.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OraclePooledConnection.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OraclePooledConnection.class.getDeclaredMethod("getXAResource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OraclePooledConnection.class.getDeclaredMethod("isSameUser", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OraclePooledConnection.class.getDeclaredMethod("removeFromImplictCache", HashMap.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OraclePooledConnection.class.getDeclaredMethod("addToImplicitCache", HashMap.class, OracleConnectionCacheEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OraclePooledConnection.class.getDeclaredMethod("generateKey", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OraclePooledConnection.class.getDeclaredMethod("setUserName", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OraclePooledConnection.class.getDeclaredMethod("setProperties", Hashtable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OraclePooledConnection.class.getDeclaredMethod("isStatementCacheInitialized", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OraclePooledConnection.class.getDeclaredMethod("getCallWithKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OraclePooledConnection.class.getDeclaredMethod("getStatementWithKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OraclePooledConnection.class.getDeclaredMethod("purgeExplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OraclePooledConnection.class.getDeclaredMethod("purgeImplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OraclePooledConnection.class.getDeclaredMethod("getExplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OraclePooledConnection.class.getDeclaredMethod("setExplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OraclePooledConnection.class.getDeclaredMethod("getImplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OraclePooledConnection.class.getDeclaredMethod("setImplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OraclePooledConnection.class.getDeclaredMethod("getStatementCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OraclePooledConnection.class.getDeclaredMethod("setStatementCacheSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OraclePooledConnection.class.getDeclaredMethod("getStmtCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OraclePooledConnection.class.getDeclaredMethod("setStmtCacheSize", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OraclePooledConnection.class.getDeclaredMethod("setStmtCacheSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OraclePooledConnection.class.getDeclaredMethod("callImplicitCacheListener", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OraclePooledConnection.class.getDeclaredMethod("callListener", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OraclePooledConnection.class.getDeclaredMethod("logicalClose", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OraclePooledConnection.class.getDeclaredMethod("logicalClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OraclePooledConnection.class.getDeclaredMethod("logicalCloseForImplicitConnectionCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OraclePooledConnection.class.getDeclaredMethod("registerImplicitCacheConnectionEventListener", ConnectionEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OraclePooledConnection.class.getDeclaredMethod("removeConnectionEventListener", ConnectionEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OraclePooledConnection.class.getDeclaredMethod("registerCloseCallback", OracleCloseCallback.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OraclePooledConnection.class.getDeclaredMethod("getLastAccessedTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OraclePooledConnection.class.getDeclaredMethod("setLastAccessedTime", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OraclePooledConnection.class.getDeclaredMethod("getPhysicalHandle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OraclePooledConnection.class.getDeclaredMethod("getLogicalHandle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OraclePooledConnection.class.getDeclaredMethod("getSystemProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OraclePooledConnection.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OraclePooledConnection.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OraclePooledConnection.class.getDeclaredMethod("addConnectionEventListener", ConnectionEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OraclePooledConnection.class.getDeclaredMethod("initialize", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

