/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.driver.NonTxnReplayableArray;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableBfile;
import oracle.jdbc.replay.driver.NonTxnReplayableBlob;
import oracle.jdbc.replay.driver.NonTxnReplayableClob;
import oracle.jdbc.replay.driver.NonTxnReplayableConnection;
import oracle.jdbc.replay.driver.NonTxnReplayableNClob;
import oracle.jdbc.replay.driver.NonTxnReplayableOpaque;
import oracle.jdbc.replay.driver.NonTxnReplayableOthers;
import oracle.jdbc.replay.driver.NonTxnReplayableRef;
import oracle.jdbc.replay.driver.NonTxnReplayableResultSet;
import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
import oracle.jdbc.replay.driver.NonTxnReplayableStruct;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;
import oracle.jdbc.replay.driver.TxnReplayableArray;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableBfile;
import oracle.jdbc.replay.driver.TxnReplayableBlob;
import oracle.jdbc.replay.driver.TxnReplayableClob;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableNClob;
import oracle.jdbc.replay.driver.TxnReplayableOpaque;
import oracle.jdbc.replay.driver.TxnReplayableOthers;
import oracle.jdbc.replay.driver.TxnReplayableRef;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.jdbc.replay.driver.TxnReplayableSqlxml;
import oracle.jdbc.replay.driver.TxnReplayableStatement;
import oracle.jdbc.replay.driver.TxnReplayableStruct;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public class OracleDataSourceImpl
implements OracleDataSource,
Serializable,
Referenceable,
ObjectFactory {
    private static final long serialVersionUID = 5634196469087099680L;
    private static ProxyFactory PROXY_FACTORY;
    private static ProxyFactory NON_TXN_PROXY_FACTORY;
    private static final Object proxyFactoryLock;
    protected oracle.jdbc.pool.OracleDataSource ods;
    protected oracle.jdbc.pool.OracleDataSource odsReconnectOnly;
    protected String user;
    protected OpaqueString password;
    private String url;
    private String serverName;
    private int portNumber;
    private String databaseName;
    private String dataSourceName;
    private String description;
    private String networkProtocol;
    private String roleName;
    protected Properties connectionProperties;
    protected Properties reconnectionProperties;
    private int maxStatements;
    private boolean implicitCachingEnabled;
    private boolean explicitCachingEnabled;
    private ConnectionInitializationCallback connectionInitializationCallback;
    protected AtomicBoolean isFirstConnection;
    protected static final String RECONNECT_DELAY_PROPERTY = "AUTH_FAILOVER_DELAY";
    protected static final String RECONNECT_RETRIES_PROPERTY = "AUTH_FAILOVER_RETRIES";
    protected int reconnectDelay;
    protected int reconnectRetries;
    protected static final String FAILOVER_TYPE_PROPERTY = "AUTH_FAILOVER_TYPE";
    protected static final int FAILOVER_TYPE_TRANSACTION = 8;
    protected static final int SESSION_STATE_CONSISTENCY_STATIC = 16;
    protected static final int FAILOVER_TYPE_AUTO = 32;
    protected boolean isTransactionReplayEnabled;
    protected boolean isAutoACEnabled;
    protected static final String SESSION_STATE_PROPERTY = "AUTH_SESSION_STATE_CONSISTENCY";
    protected boolean isReplayInDynamicMode;
    protected static final String FAILOVER_RESTORE_PROPERTY = "AUTH_FAILOVER_RESTORE";
    protected static final int FAILOVER_RESTORE_NONE = 0;
    protected static final int FAILOVER_RESTORE_LEVEL1 = 1;
    protected static final int FAILOVER_RESTORE_AUTO = 2;
    protected boolean isStateRestorationEnabled;
    protected boolean isStateRestorationAuto;
    protected static final String INITIATION_TIMEOUT_PROPERTY = "AUTH_FAILOVER_REPLAYTIMEOUT";
    protected int replayInitiationTimeout;
    protected static final String CHECKSUM_PROPERTY = "oracle.jdbc.calculateChecksum";
    protected final String clientChecksum12x;
    protected final String clientChecksum11203x;
    protected static final String IGNORE_AC_CONTEXT_PROPERTY = "oracle.jdbc.ignoreReplayContextFromAuthentication";
    private static final String AC_11203_COMPATIBLE_SYSTEM_PROPERTY = "oracle.jdbc.AC11203Compatible";
    private static final String IMPLICIT_BEGIN_REQUEST_SYSTEM_PROPERTY = "oracle.jdbc.beginRequestAtConnectionCreation";
    private LinkedList<oracle.jdbc.replay.internal.ReplayStatistics> acStatistics;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;

    public OracleDataSourceImpl() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$58, null, new Object[0]);
                }
                this.ods = null;
                this.odsReconnectOnly = null;
                this.user = null;
                this.password = null;
                this.url = null;
                this.serverName = null;
                this.portNumber = 0;
                this.databaseName = null;
                this.dataSourceName = null;
                this.description = null;
                this.networkProtocol = null;
                this.roleName = null;
                this.connectionProperties = null;
                this.reconnectionProperties = null;
                this.maxStatements = 0;
                this.implicitCachingEnabled = false;
                this.explicitCachingEnabled = false;
                this.connectionInitializationCallback = null;
                this.isFirstConnection = new AtomicBoolean(true);
                this.reconnectDelay = 10;
                this.reconnectRetries = 30;
                this.isTransactionReplayEnabled = false;
                this.isAutoACEnabled = false;
                this.isReplayInDynamicMode = true;
                this.isStateRestorationEnabled = false;
                this.isStateRestorationAuto = false;
                this.replayInitiationTimeout = 300;
                this.clientChecksum12x = OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS.toString();
                this.clientChecksum11203x = OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL.toString();
                this.acStatistics = new LinkedList();
                try {
                    this.ods = new oracle.jdbc.pool.OracleDataSource();
                    this.odsReconnectOnly = new oracle.jdbc.pool.OracleDataSource();
                }
                catch (SQLException sqlexc) {
                    if (!bl) break block7;
                    OracleLog.log($$$loggerRef$$$58, Level.SEVERE, this.getClass(), $$$methodRef$$$58, "AC is disabled, because replay data source construction failed.");
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$58, null);
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$58, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$58, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$0, this, new Object[0]);
            }
            String pwd = null;
            if (this.password != null) {
                pwd = this.password.get();
            }
            Connection connection = this.getConnection(this.user, pwd);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$0, this, connection);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$0, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void passwd;
            void username;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$1, this, string, string2);
            }
            Connection connection = this.getConnectionInternal(this.createConnectionBuilder().user((String)username).password((String)passwd), true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$1, this, connection);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$1, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Connection getConnection(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void connBldr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$2, this, oracleConnectionBuilderImpl);
            }
            Connection connection = this.getConnectionInternal((OracleConnectionBuilderImpl)connBldr, true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$2, this, connection);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$2, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Connection getConnectionNoProxy(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$3, this, oracleConnectionBuilderImpl);
            }
            int retries = 1;
            Connection conn = null;
            Exception exc = null;
            do {
                block20: {
                    Connection connection;
                    block21: {
                        try {
                            void connBuilder;
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$3, Level.FINER, this.getClass(), $$$methodRef$$$3, "Reconnecting: RETRY {0}", retries);
                            }
                            exc = null;
                            connBuilder.instanceName(null);
                            conn = this.getConnectionInternal((OracleConnectionBuilderImpl)connBuilder, false);
                            OracleConnection oconn = (OracleConnection)conn;
                            if (oconn.isDRCPEnabled()) {
                                oconn.attachServerConnection();
                                if (bl) {
                                    OracleLog.log($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "DRCP attach completed");
                                }
                            }
                            if (conn == null || exc != null) break block20;
                            connection = conn;
                            if (!bl) break block21;
                        }
                        catch (Exception e2) {
                            block22: {
                                Connection connection2;
                                block23: {
                                    try {
                                        conn = null;
                                        exc = e2;
                                        if (bl) {
                                            OracleLog.log($$$loggerRef$$$3, Level.FINER, this.getClass(), $$$methodRef$$$3, "Reconnect FAILED, exception: {0}", e2);
                                        }
                                        if (conn == null || exc != null) break block22;
                                        connection2 = conn;
                                        if (!bl) break block23;
                                    }
                                    catch (Throwable throwable) {
                                        if (conn != null && exc == null) {
                                            Connection connection3 = conn;
                                            if (bl) {
                                                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$3, this, connection3);
                                                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$3, this, null);
                                            }
                                            return connection3;
                                        }
                                        ++retries;
                                        Throwable throwable2 = throwable;
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$3, this, throwable2);
                                        }
                                        throw throwable2;
                                    }
                                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$3, this, connection2);
                                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$3, this, null);
                                }
                                return connection2;
                            }
                            ++retries;
                        }
                        ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$3, this, connection);
                        ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$3, this, null);
                    }
                    return connection;
                }
                ++retries;
                try {
                    if (this.reconnectDelay <= 0) continue;
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$3, Level.FINER, this.getClass(), $$$methodRef$$$3, "Reconnecting: DELAY for {0} seconds", this.reconnectDelay);
                    }
                    Thread.sleep(this.reconnectDelay * 1000);
                }
                catch (InterruptedException sleepExc) {
                    if (!bl) continue;
                    OracleLog.log($$$loggerRef$$$3, Level.FINER, this.getClass(), $$$methodRef$$$3, "Reconnect threw exception during DELAY: {0}", sleepExc);
                }
            } while (retries <= this.reconnectRetries);
            Connection connection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$3, this, connection);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$3, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$3, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Connection getConnectionInternal(OracleConnectionBuilderImpl oracleConnectionBuilderImpl, boolean bl) throws SQLException {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void builder;
            void useProxy;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$4, this, oracleConnectionBuilderImpl, bl);
            }
            Connection conn = null;
            this.setupACSpecificProperties();
            if (useProxy != false) {
                conn = this.ods.getConnection((OracleConnectionBuilderImpl)builder);
                conn = this.enableACAndProxifyIfNecessary(conn, (OracleConnectionBuilderImpl)builder);
            } else {
                conn = this.odsReconnectOnly.getConnection((OracleConnectionBuilderImpl)builder);
            }
            this.isFirstConnection.set(false);
            Connection connection = conn;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$4, this, connection);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$4, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void setupACSpecificProperties() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (this.isFirstConnection.get()) {
                this.setConnectionProperty(CHECKSUM_PROPERTY, this.clientChecksum12x);
                this.reconnectionProperties.setProperty(IGNORE_AC_CONTEXT_PROPERTY, "true");
                this.odsReconnectOnly.setConnectionProperties(this.reconnectionProperties);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected Connection enableACAndProxifyIfNecessary(Connection connection, OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void connBuilder;
            String initiationTimeout;
            String failoverRestore;
            String failoverType;
            String failoverRetries;
            Connection conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$6, this, connection, oracleConnectionBuilderImpl);
            }
            boolean useProxy = true;
            short dbVersion = 0;
            OracleConnection oconn = (OracleConnection)conn;
            Properties sessionProperties = oconn.getServerSessionInfo();
            String failoverDelay = sessionProperties.getProperty(RECONNECT_DELAY_PROPERTY);
            if (failoverDelay != null && !"".equals(failoverDelay)) {
                int _delay = Integer.parseInt(failoverDelay);
                if (_delay > 0) {
                    this.reconnectDelay = _delay;
                } else if (bl) {
                    OracleLog.log($$$loggerRef$$$6, Level.CONFIG, this.getClass(), $$$methodRef$$$6, "Server FAILOVER_DELAY: {0}, using driver default {1} seconds instead", new Object[]{_delay, 10});
                }
            }
            if ((failoverRetries = sessionProperties.getProperty(RECONNECT_RETRIES_PROPERTY)) != null && !"".equals(failoverRetries)) {
                int _retries = Integer.parseInt(failoverRetries);
                if (_retries > 0) {
                    this.reconnectRetries = _retries;
                } else if (bl) {
                    OracleLog.log($$$loggerRef$$$6, Level.CONFIG, this.getClass(), $$$methodRef$$$6, "Server FAILOVER_RETRIES: {0}, using driver default {1} instead", new Object[]{_retries, 18});
                }
            }
            if ((failoverType = sessionProperties.getProperty(FAILOVER_TYPE_PROPERTY)) != null && !"".equals(failoverType)) {
                int wiredValue;
                try {
                    wiredValue = Integer.parseInt(failoverType);
                }
                catch (NumberFormatException exc) {
                    wiredValue = 0;
                }
                this.isAutoACEnabled = (wiredValue & 0x20) == 32;
                this.isTransactionReplayEnabled = this.isAutoACEnabled || (wiredValue & 8) == 8;
                boolean bl2 = this.isReplayInDynamicMode = (wiredValue & 0x10) == 0;
            }
            if ((failoverRestore = sessionProperties.getProperty(FAILOVER_RESTORE_PROPERTY)) != null && !"".equals(failoverRestore)) {
                int _restore = Integer.parseInt(failoverRestore);
                if (_restore > 0) {
                    this.isStateRestorationEnabled = "thin".equals(oconn.getProtocolType());
                    boolean bl3 = this.isStateRestorationAuto = this.isStateRestorationEnabled && _restore > 1;
                    if (this.isAutoACEnabled && !this.isStateRestorationAuto) {
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$6, Level.WARNING, this.getClass(), $$$methodRef$$$6, "AC is disabled on {0}, because FAILOVER_TYPE at server is AUTO, while FAILOVER_RESTORE is not", conn);
                        }
                        useProxy = false;
                    }
                } else if (bl) {
                    OracleLog.log($$$loggerRef$$$6, Level.CONFIG, this.getClass(), $$$methodRef$$$6, "Server FAILOVER_RESTORE: {0}, disabling driver AC state restoration", _restore);
                }
            }
            if ((initiationTimeout = sessionProperties.getProperty(INITIATION_TIMEOUT_PROPERTY)) != null && !"".equals(initiationTimeout)) {
                this.replayInitiationTimeout = Integer.parseInt(initiationTimeout);
            }
            if ((dbVersion = oconn.getVersionNumber()) < 11203) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$6, Level.WARNING, this.getClass(), $$$methodRef$$$6, "AC is disabled on {0}, because server version does not support AC.", conn);
                }
                useProxy = false;
            } else if (dbVersion >= 12100 && !this.isTransactionReplayEnabled) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$6, Level.WARNING, this.getClass(), $$$methodRef$$$6, "AC is disabled on {0}, because FAILOVER_TYPE service attribute is not set to TRANSACTION in server", conn);
                }
                useProxy = false;
            } else if (dbVersion >= 11203 && dbVersion < 12100) {
                boolean enableAC11203 = "true".equalsIgnoreCase(OracleDataSourceImpl.getSystemProperty(AC_11203_COMPATIBLE_SYSTEM_PROPERTY, "false"));
                if (enableAC11203) {
                    conn.close();
                    this.setConnectionProperty(CHECKSUM_PROPERTY, this.clientChecksum11203x);
                    conn = this.ods.getConnection((OracleConnectionBuilderImpl)connBuilder);
                    Object object = proxyFactoryLock;
                    synchronized (object) {
                        try {
                            PROXY_FACTORY = NON_TXN_PROXY_FACTORY;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[0, 16, 17, 19, 3, 5, 22] lbl71 : MonitorExitStatement: MONITOREXIT : var13_20
                            Throwable throwable2 = throwable;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$6, this, throwable2);
                            }
                            throw throwable2;
                        }
                    }
                } else {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$6, Level.WARNING, this.getClass(), $$$methodRef$$$6, "AC is disabled on {0}, because server version does not support AC.", conn);
                    }
                    useProxy = false;
                }
            }
            if (useProxy) {
                Connection connProxy = (Connection)PROXY_FACTORY.proxyFor(conn);
                ReplayableConnection rconn = (ReplayableConnection)((Object)connProxy);
                rconn.initialize(this, (OracleConnectionBuilderImpl)connBuilder);
                if (dbVersion >= 12100) {
                    rconn.setReplayInitiationTimeout(this.replayInitiationTimeout);
                    rconn.setAutoAC(this.isAutoACEnabled);
                    rconn.setSessionStateConsistency(!this.isReplayInDynamicMode);
                    rconn.setSessionStateRestoration(this.isStateRestorationEnabled);
                }
                ((OracleConnection)conn).getReplayContext();
                boolean enableImplicitBeginRequest = "true".equalsIgnoreCase(OracleDataSourceImpl.getSystemProperty(IMPLICIT_BEGIN_REQUEST_SYSTEM_PROPERTY, "true"));
                if (this.isAutoACEnabled && enableImplicitBeginRequest) {
                    rconn.beginRequest();
                }
                Connection connection2 = connProxy;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$6, this, connection2);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$6, this, null);
                }
                return connection2;
            }
            void var16_26 = conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$6, this, var16_26);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$6, this, null);
            }
            return var16_26;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$6, this, throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$7, this, new Object[0]);
            }
            PrintWriter printWriter = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$7, this, printWriter);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$7, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$8, this, printWriter);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void setLoginTimeout(int n2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$9, this, n2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$10, this, new Object[0]);
            }
            int n2 = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$10, this, n2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$10, this, null);
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getUser() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$11, this, new Object[0]);
            }
            String string = this.user;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$11, this, string);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$11, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setUser(String string) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void username;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$12, this, string);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$12, Level.CONFIG, this.getClass(), $$$methodRef$$$12, "user: {0}", username);
            }
            this.user = username;
            this.ods.setUser((String)username);
            this.odsReconnectOnly.setUser((String)username);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPassword(String string) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void passwd;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$13, this, string);
            }
            this.password = OpaqueString.newOpaqueString((String)passwd);
            this.ods.setPassword((String)passwd);
            this.odsReconnectOnly.setPassword((String)passwd);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getURL() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$14, this, new Object[0]);
            }
            String string = this.url;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$14, this, string);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$14, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setURL(String string) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void url;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$15, this, string);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$15, Level.CONFIG, this.getClass(), $$$methodRef$$$15, "URL: {0}", url);
            }
            this.url = url;
            this.ods.setURL((String)url);
            this.odsReconnectOnly.setURL((String)url);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setServerName(String string) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void serverName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$16, this, string);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$16, Level.CONFIG, this.getClass(), $$$methodRef$$$16, "Server Name: {0}", serverName);
            }
            this.serverName = serverName;
            this.ods.setServerName((String)serverName);
            this.odsReconnectOnly.setServerName((String)serverName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getServerName() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$17, this, new Object[0]);
            }
            String string = this.serverName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$17, this, string);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$17, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPortNumber(int n2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void portNumber;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$18, this, n2);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$18, Level.CONFIG, this.getClass(), $$$methodRef$$$18, "Port Number: {0}", (int)portNumber);
            }
            this.portNumber = portNumber;
            this.ods.setPortNumber((int)portNumber);
            this.odsReconnectOnly.setPortNumber((int)portNumber);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getPortNumber() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$19, this, new Object[0]);
            }
            int n2 = this.portNumber;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$19, this, n2);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$19, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDatabaseName(String string) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void databaseName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$20, this, string);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$20, Level.CONFIG, this.getClass(), $$$methodRef$$$20, "Database Name : {0}", databaseName);
            }
            this.databaseName = databaseName;
            this.ods.setDatabaseName((String)databaseName);
            this.odsReconnectOnly.setDatabaseName((String)databaseName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getDatabaseName() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$21, this, new Object[0]);
            }
            String string = this.databaseName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$21, this, string);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$21, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDataSourceName(String string) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void dataSourceName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$22, this, string);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$22, Level.CONFIG, this.getClass(), $$$methodRef$$$22, "DataSourceName : {0}", dataSourceName);
            }
            this.dataSourceName = dataSourceName;
            this.ods.setDataSourceName((String)dataSourceName);
            this.odsReconnectOnly.setDataSourceName((String)dataSourceName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getDataSourceName() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$23, this, new Object[0]);
            }
            String string = this.dataSourceName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$23, this, string);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$23, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDescription(String string) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void description;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$24, this, string);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$24, Level.CONFIG, this.getClass(), $$$methodRef$$$24, "Description : {0}", description);
            }
            this.description = description;
            this.ods.setDescription((String)description);
            this.odsReconnectOnly.setDescription((String)description);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getDescription() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$25, this, new Object[0]);
            }
            String string = this.description;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$25, this, string);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$25, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setNetworkProtocol(String string) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void networkProtocol;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$26, this, string);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$26, Level.CONFIG, this.getClass(), $$$methodRef$$$26, "networkProtocol : {0}", networkProtocol);
            }
            this.networkProtocol = networkProtocol;
            this.ods.setNetworkProtocol((String)networkProtocol);
            this.odsReconnectOnly.setNetworkProtocol((String)networkProtocol);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getNetworkProtocol() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$27, this, new Object[0]);
            }
            String string = this.networkProtocol;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$27, this, string);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$27, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setRoleName(String string) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void roleName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$28, this, string);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$28, Level.CONFIG, this.getClass(), $$$methodRef$$$28, "RoleName : {0}", roleName);
            }
            this.roleName = roleName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getRoleName() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$29, this, new Object[0]);
            }
            String string = this.roleName;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$29, this, string);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$29, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerConnectionInitializationCallback(ConnectionInitializationCallback connectionInitializationCallback) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cbk;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$30, this, connectionInitializationCallback);
            }
            if (cbk == null) {
                SQLException sQLException = DatabaseError.createSqlException(68);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$30, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$30, this, sQLException);
                }
                throw sQLException;
            }
            this.connectionInitializationCallback = cbk;
            if (bl) {
                OracleLog.log($$$loggerRef$$$30, Level.CONFIG, this.getClass(), $$$methodRef$$$30, "Connection Initialization Callback registered: {0}", cbk);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unregisterConnectionInitializationCallback(ConnectionInitializationCallback connectionInitializationCallback) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cbk;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$31, this, connectionInitializationCallback);
            }
            if (cbk == null || this.connectionInitializationCallback != cbk) {
                SQLException sQLException = DatabaseError.createSqlException(68);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$31, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$31, this, sQLException);
                }
                throw sQLException;
            }
            this.connectionInitializationCallback = null;
            if (bl) {
                OracleLog.log($$$loggerRef$$$31, Level.CONFIG, this.getClass(), $$$methodRef$$$31, "Connection Initialization Callback removed: {0}", cbk);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ConnectionInitializationCallback getConnectionInitializationCallback() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$32, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$32, Level.FINEST, this.getClass(), $$$methodRef$$$32, "connection initialization callback obtained: {0}", this.connectionInitializationCallback);
            }
            ConnectionInitializationCallback connectionInitializationCallback = this.connectionInitializationCallback;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$32, this, connectionInitializationCallback);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$32, this, null);
            }
            return connectionInitializationCallback;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Properties getConnectionProperties() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$33, this, new Object[0]);
            }
            Properties properties = this.connectionProperties;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$33, this, properties);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$33, this, null);
            }
            return properties;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getConnectionProperty(String string) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void propertyName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$34, this, string);
            }
            String string2 = this.connectionProperties.getProperty((String)propertyName);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$34, this, string2);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$34, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConnectionProperty(String string, String string2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void name;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$35, this, string, string2);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$35, Level.CONFIG, this.getClass(), $$$methodRef$$$35, "name: {0}, value: {1}", new Object[]{name, value});
            }
            if (value == null || value.equals("")) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$35, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$35, this, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            if (this.connectionProperties == null) {
                this.connectionProperties = new Properties();
            }
            if (this.reconnectionProperties == null) {
                this.reconnectionProperties = new Properties();
            }
            this.connectionProperties.setProperty((String)name, (String)value);
            this.reconnectionProperties.setProperty((String)name, (String)value);
            this.ods.setConnectionProperties(this.connectionProperties);
            this.odsReconnectOnly.setConnectionProperties(this.reconnectionProperties);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$35, this);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$35, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConnectionProperties(Properties properties) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void connProperties;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$36, this, properties);
            }
            if (connProperties == null) {
                this.connectionProperties = null;
                this.reconnectionProperties = null;
            } else {
                this.connectionProperties = (Properties)connProperties.clone();
                this.reconnectionProperties = (Properties)connProperties.clone();
            }
            this.setConnectionProperty(CHECKSUM_PROPERTY, this.clientChecksum12x);
            this.reconnectionProperties.setProperty(IGNORE_AC_CONTEXT_PROPERTY, "true");
            this.odsReconnectOnly.setConnectionProperties(this.reconnectionProperties);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$36, this);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$36, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaxStatements(int n2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void max;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$37, this, n2);
            }
            this.maxStatements = max;
            this.ods.setMaxStatements((int)max);
            this.odsReconnectOnly.setMaxStatements((int)max);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$37, this);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$38, this, new Object[0]);
            }
            int n2 = this.maxStatements;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$38, this, n2);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$38, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$39, this, bl);
            }
            this.implicitCachingEnabled = cache;
            this.ods.setImplicitCachingEnabled((boolean)cache);
            this.odsReconnectOnly.setImplicitCachingEnabled((boolean)cache);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$39, this);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$39, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$40, this, new Object[0]);
            }
            boolean bl2 = this.implicitCachingEnabled;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$40, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$40, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$41, this, bl);
            }
            this.explicitCachingEnabled = cache;
            this.ods.setExplicitCachingEnabled((boolean)cache);
            this.odsReconnectOnly.setExplicitCachingEnabled((boolean)cache);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$41, this);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$41, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$42, this, new Object[0]);
            }
            boolean bl2 = this.explicitCachingEnabled;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$42, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$42, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplayStatistics getReplayStatistics() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$43, this, new Object[0]);
            }
            long totalRequests = 0L;
            long totalCompletedRequests = 0L;
            long totalCalls = 0L;
            long totalProtectedCalls = 0L;
            long totalCallsAffectedByOutages = 0L;
            long totalCallsTriggeringReplay = 0L;
            long totalCallsAffectedByOutagesDuringReplay = 0L;
            long successfulReplayCount = 0L;
            long failedReplayCount = 0L;
            long replayDisablingCount = 0L;
            long totalReplayAttempts = 0L;
            LinkedList<oracle.jdbc.replay.internal.ReplayStatistics> linkedList = this.acStatistics;
            synchronized (linkedList) {
                try {
                    for (oracle.jdbc.replay.internal.ReplayStatistics stats : this.acStatistics) {
                        totalRequests += stats.getTotalRequests();
                        totalCompletedRequests += stats.getTotalCompletedRequests();
                        totalCalls += stats.getTotalCalls();
                        totalProtectedCalls += stats.getTotalProtectedCalls();
                        totalCallsAffectedByOutages += stats.getTotalCallsAffectedByOutages();
                        totalCallsTriggeringReplay += stats.getTotalCallsTriggeringReplay();
                        totalCallsAffectedByOutagesDuringReplay += stats.getTotalCallsAffectedByOutagesDuringReplay();
                        successfulReplayCount += stats.getSuccessfulReplayCount();
                        failedReplayCount += stats.getFailedReplayCount();
                        replayDisablingCount += stats.getReplayDisablingCount();
                        totalReplayAttempts += stats.getTotalReplayAttempts();
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl37 : MonitorExitStatement: MONITOREXIT : var23_13
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$43, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            ReplayStatisticsImpl replayStatisticsImpl = new ReplayStatisticsImpl(totalRequests, totalCompletedRequests, totalCalls, totalProtectedCalls, totalCallsAffectedByOutages, totalCallsTriggeringReplay, totalCallsAffectedByOutagesDuringReplay, successfulReplayCount, failedReplayCount, replayDisablingCount, totalReplayAttempts);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$43, this, replayStatisticsImpl);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$43, this, null);
            }
            return replayStatisticsImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$43, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearReplayStatistics() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$44, this, new Object[0]);
            }
            LinkedList<oracle.jdbc.replay.internal.ReplayStatistics> linkedList = this.acStatistics;
            synchronized (linkedList) {
                try {
                    for (oracle.jdbc.replay.internal.ReplayStatistics stats : this.acStatistics) {
                        stats.clear();
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl16 : MonitorExitStatement: MONITOREXIT : var1_2
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$44, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$44, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$44, this);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$44, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$44, this, throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$45, this, new Object[0]);
            }
            Reference ref = new Reference(this.getClass().getName(), "oracle.jdbc.replay.OracleDataSourceImpl", null);
            if (this.user != null) {
                ref.add(new StringRefAddr("user", this.user));
            }
            if (this.password != null && !this.password.isNull()) {
                ref.add(new StringRefAddr("password", this.password.get()));
            }
            if (this.url != null) {
                ref.add(new StringRefAddr("url", this.url));
            }
            if (this.serverName != null) {
                ref.add(new StringRefAddr("serverName", this.serverName));
            }
            ref.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
            if (this.databaseName != null) {
                ref.add(new StringRefAddr("databaseName", this.databaseName));
            }
            if (this.dataSourceName != null) {
                ref.add(new StringRefAddr("dataSourceName", this.dataSourceName.toString()));
            }
            if (this.description != null) {
                ref.add(new StringRefAddr("description", this.description.toString()));
            }
            if (this.networkProtocol != null) {
                ref.add(new StringRefAddr("networkProtocol", this.networkProtocol.toString()));
            }
            if (this.roleName != null) {
                ref.add(new StringRefAddr("roleName", this.roleName));
            }
            if (this.connectionProperties.size() > 0) {
                ref.add(new StringRefAddr("connectionProperties", this.connectionProperties.toString()));
            }
            if (this.maxStatements != 0) {
                ref.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
            }
            if (this.implicitCachingEnabled) {
                ref.add(new StringRefAddr("implicitCachingEnabled", "true"));
            }
            if (this.explicitCachingEnabled) {
                ref.add(new StringRefAddr("explicitCachingEnabled", "true"));
            }
            Reference reference = ref;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$45, this, reference);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$45, this, null);
            }
            return reference;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void out;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$46, this, objectOutputStream);
            }
            out.defaultWriteObject();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$46, this);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$46, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void in;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$47, this, objectInputStream);
            }
            in.defaultReadObject();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$47, this);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$47, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            String ie;
            void refObj;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$48, this, object, name, context, hashtable);
            }
            Reference ref = (Reference)refObj;
            String cn = ref.getClassName();
            OracleDataSourceImpl pd = null;
            if (cn.equals("oracle.jdbc.replay.OracleDataSource") || cn.equals("oracle.jdbc.replay.OracleDataSourceImpl")) {
                pd = new OracleDataSourceImpl();
            }
            if (pd == null) {
                Object var18_9 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$48, this, var18_9);
                    ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$48, this, null);
                }
                return null;
            }
            StringRefAddr ra = (StringRefAddr)ref.get("user");
            if (ra != null) {
                pd.setUser((String)ra.getContent());
            }
            if ((ra = (StringRefAddr)ref.get("password")) != null) {
                pd.setPassword((String)ra.getContent());
            }
            if ((ra = (StringRefAddr)ref.get("url")) != null) {
                pd.setURL((String)ra.getContent());
            }
            if ((ra = (StringRefAddr)ref.get("serverName")) != null) {
                pd.setServerName((String)ra.getContent());
            }
            if ((ra = (StringRefAddr)ref.get("portNumber")) != null) {
                pd.setPortNumber(Integer.parseInt((String)ra.getContent()));
            }
            if ((ra = (StringRefAddr)ref.get("databaseName")) != null) {
                pd.setDatabaseName((String)ra.getContent());
            }
            if ((ra = (StringRefAddr)ref.get("dataSourceName")) != null) {
                pd.setDataSourceName((String)ra.getContent());
            }
            if ((ra = (StringRefAddr)ref.get("description")) != null) {
                pd.setDescription((String)ra.getContent());
            }
            if ((ra = (StringRefAddr)ref.get("networkProtocol")) != null) {
                pd.setNetworkProtocol((String)ra.getContent());
            }
            if ((ra = (StringRefAddr)ref.get("roleName")) != null) {
                pd.setRoleName((String)ra.getContent());
            }
            if ((ra = (StringRefAddr)ref.get("connectionProperties")) != null) {
                String[] propStrs;
                String connPropsStr = (String)ra.getContent();
                Properties connProps = new Properties();
                for (String onePropStr : propStrs = connPropsStr.substring(1, connPropsStr.length() - 1).split(", ")) {
                    String[] nvPair = onePropStr.split("=");
                    connProps.setProperty(nvPair[0], nvPair[1]);
                }
                pd.setConnectionProperties(connProps);
            }
            if ((ra = (StringRefAddr)ref.get("maxStatements")) != null) {
                pd.setMaxStatements(Integer.parseInt((String)ra.getContent()));
            }
            if ((ra = (StringRefAddr)ref.get("implicitCachingEnabled")) != null) {
                ie = (String)ra.getContent();
                if (ie.equalsIgnoreCase("true")) {
                    pd.setImplicitCachingEnabled(true);
                } else {
                    pd.setImplicitCachingEnabled(false);
                }
            }
            if ((ra = (StringRefAddr)ref.get("explicitCachingEnabled")) != null) {
                ie = (String)ra.getContent();
                if (ie.equalsIgnoreCase("true")) {
                    pd.setExplicitCachingEnabled(true);
                } else {
                    pd.setExplicitCachingEnabled(false);
                }
            }
            OracleDataSourceImpl oracleDataSourceImpl = pd;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$48, this, oracleDataSourceImpl);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$48, this, null);
            }
            return oracleDataSourceImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$49, this, clazz);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$49, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$49, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void iface;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$50, this, clazz);
            }
            if (iface.isInterface() && iface.isInstance(this)) {
                OracleDataSourceImpl oracleDataSourceImpl = this;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$50, this, oracleDataSourceImpl);
                    ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$50, this, null);
                }
                return (T)oracleDataSourceImpl;
            }
            T t2 = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$50, this, t2);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$50, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$51, this, new Object[0]);
            }
            Logger logger = Logger.getLogger("oracle");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$51, this, logger);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$51, this, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getSystemProperty(String string, String string2) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void defaultValue;
            String property;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$52, null, string, string2);
            }
            if (property != null) {
                final String propStr = property;
                void propDefVal = defaultValue;
                final String[] rets = new String[]{defaultValue};
                AccessController.doPrivileged(new PrivilegedAction((String)propDefVal){
                    final /* synthetic */ String val$propDefVal;
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    {
                        this.val$propDefVal = string2;
                    }

                    public Object run() {
                        rets[0] = System.getProperty(propStr, this.val$propDefVal);
                        return null;
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(String[].class, String.class, String.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
                String string3 = rets[0];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$52, null, string3);
                    ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$52, null, null);
                }
                return string3;
            }
            void var6_7 = defaultValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$52, null, var6_7);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$52, null, null);
            }
            return var6_7;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$52, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void updateReplayStatistics(oracle.jdbc.replay.internal.ReplayStatistics replayStatistics) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$53, this, replayStatistics);
            }
            LinkedList<oracle.jdbc.replay.internal.ReplayStatistics> linkedList = this.acStatistics;
            synchronized (linkedList) {
                try {
                    void newStats;
                    this.acStatistics.add((oracle.jdbc.replay.internal.ReplayStatistics)newStats);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : var2_3
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$53, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$53, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$53, this);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$53, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$53, this, throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public ProxyFactory getProxyFactory() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$54, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$54, Level.FINEST, this.getClass(), $$$methodRef$$$54, "PROXY FACTORY obtained: {0}", PROXY_FACTORY);
            }
            ProxyFactory proxyFactory = PROXY_FACTORY;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$54, this, proxyFactory);
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$54, this, null);
            }
            return proxyFactory;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$54, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleConnectionBuilderImpl createConnectionBuilder() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$55, this, new Object[0]);
            }
            OracleConnectionBuilderImpl oracleConnectionBuilderImpl = new OracleConnectionBuilderImpl(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public OracleConnection build() throws SQLException {
                    return (OracleConnection)OracleDataSourceImpl.access$000(OracleDataSourceImpl.this, this, true);
                }

                static {
                    try {
                        $$$methodRef$$$2 = 2.class.getDeclaredConstructor(OracleDataSourceImpl.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("build", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$55, this, oracleConnectionBuilderImpl);
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$55, this, null);
            }
            return oracleConnectionBuilderImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$55, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Connection access$000(OracleDataSourceImpl oracleDataSourceImpl, OracleConnectionBuilderImpl oracleConnectionBuilderImpl, boolean bl) throws SQLException {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void x2;
            void x1;
            OracleDataSourceImpl x0;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$57, null, oracleDataSourceImpl, oracleConnectionBuilderImpl, bl);
            }
            Connection connection = x0.getConnectionInternal((OracleConnectionBuilderImpl)x1, (boolean)x2);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$57, null, connection);
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$57, null, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, OracleDataSourceImpl.class, $$$methodRef$$$57, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            $$$methodRef$$$58 = OracleDataSourceImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$57 = OracleDataSourceImpl.class.getDeclaredMethod("access$000", OracleDataSourceImpl.class, OracleConnectionBuilderImpl.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$56 = OracleDataSourceImpl.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$55 = OracleDataSourceImpl.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$54 = OracleDataSourceImpl.class.getDeclaredMethod("getProxyFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$53 = OracleDataSourceImpl.class.getDeclaredMethod("updateReplayStatistics", oracle.jdbc.replay.internal.ReplayStatistics.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$52 = OracleDataSourceImpl.class.getDeclaredMethod("getSystemProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$51 = OracleDataSourceImpl.class.getDeclaredMethod("getParentLogger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$50 = OracleDataSourceImpl.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$49 = OracleDataSourceImpl.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$48 = OracleDataSourceImpl.class.getDeclaredMethod("getObjectInstance", Object.class, Name.class, Context.class, Hashtable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$47 = OracleDataSourceImpl.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$46 = OracleDataSourceImpl.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$45 = OracleDataSourceImpl.class.getDeclaredMethod("getReference", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$44 = OracleDataSourceImpl.class.getDeclaredMethod("clearReplayStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$43 = OracleDataSourceImpl.class.getDeclaredMethod("getReplayStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$42 = OracleDataSourceImpl.class.getDeclaredMethod("getExplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$41 = OracleDataSourceImpl.class.getDeclaredMethod("setExplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$40 = OracleDataSourceImpl.class.getDeclaredMethod("getImplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$39 = OracleDataSourceImpl.class.getDeclaredMethod("setImplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$38 = OracleDataSourceImpl.class.getDeclaredMethod("getMaxStatements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$37 = OracleDataSourceImpl.class.getDeclaredMethod("setMaxStatements", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$36 = OracleDataSourceImpl.class.getDeclaredMethod("setConnectionProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$35 = OracleDataSourceImpl.class.getDeclaredMethod("setConnectionProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$34 = OracleDataSourceImpl.class.getDeclaredMethod("getConnectionProperty", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$33 = OracleDataSourceImpl.class.getDeclaredMethod("getConnectionProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$32 = OracleDataSourceImpl.class.getDeclaredMethod("getConnectionInitializationCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$31 = OracleDataSourceImpl.class.getDeclaredMethod("unregisterConnectionInitializationCallback", ConnectionInitializationCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$30 = OracleDataSourceImpl.class.getDeclaredMethod("registerConnectionInitializationCallback", ConnectionInitializationCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$29 = OracleDataSourceImpl.class.getDeclaredMethod("getRoleName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$28 = OracleDataSourceImpl.class.getDeclaredMethod("setRoleName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$27 = OracleDataSourceImpl.class.getDeclaredMethod("getNetworkProtocol", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = OracleDataSourceImpl.class.getDeclaredMethod("setNetworkProtocol", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = OracleDataSourceImpl.class.getDeclaredMethod("getDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = OracleDataSourceImpl.class.getDeclaredMethod("setDescription", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = OracleDataSourceImpl.class.getDeclaredMethod("getDataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = OracleDataSourceImpl.class.getDeclaredMethod("setDataSourceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = OracleDataSourceImpl.class.getDeclaredMethod("getDatabaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = OracleDataSourceImpl.class.getDeclaredMethod("setDatabaseName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = OracleDataSourceImpl.class.getDeclaredMethod("getPortNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = OracleDataSourceImpl.class.getDeclaredMethod("setPortNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = OracleDataSourceImpl.class.getDeclaredMethod("getServerName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = OracleDataSourceImpl.class.getDeclaredMethod("setServerName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = OracleDataSourceImpl.class.getDeclaredMethod("setURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = OracleDataSourceImpl.class.getDeclaredMethod("getURL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = OracleDataSourceImpl.class.getDeclaredMethod("setPassword", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = OracleDataSourceImpl.class.getDeclaredMethod("setUser", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = OracleDataSourceImpl.class.getDeclaredMethod("getUser", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = OracleDataSourceImpl.class.getDeclaredMethod("getLoginTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = OracleDataSourceImpl.class.getDeclaredMethod("setLoginTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = OracleDataSourceImpl.class.getDeclaredMethod("setLogWriter", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = OracleDataSourceImpl.class.getDeclaredMethod("getLogWriter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = OracleDataSourceImpl.class.getDeclaredMethod("enableACAndProxifyIfNecessary", Connection.class, OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = OracleDataSourceImpl.class.getDeclaredMethod("setupACSpecificProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = OracleDataSourceImpl.class.getDeclaredMethod("getConnectionInternal", OracleConnectionBuilderImpl.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = OracleDataSourceImpl.class.getDeclaredMethod("getConnectionNoProxy", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = OracleDataSourceImpl.class.getDeclaredMethod("getConnection", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = OracleDataSourceImpl.class.getDeclaredMethod("getConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = OracleDataSourceImpl.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        PROXY_FACTORY = null;
        NON_TXN_PROXY_FACTORY = null;
        Object object = proxyFactoryLock = new Object();
        synchronized (object) {
            if (PROXY_FACTORY == null) {
                NON_TXN_PROXY_FACTORY = ProxyFactory.createProxyFactory(NonTxnReplayableBase.class, NonTxnReplayableConnection.class, NonTxnReplayableStatement.class, NonTxnReplayableResultSet.class, NonTxnReplayableArray.class, NonTxnReplayableBfile.class, NonTxnReplayableBlob.class, NonTxnReplayableClob.class, NonTxnReplayableNClob.class, NonTxnReplayableOpaque.class, NonTxnReplayableRef.class, NonTxnReplayableStruct.class, NonTxnReplayableOthers.class);
                PROXY_FACTORY = ProxyFactory.createProxyFactory(TxnReplayableBase.class, TxnReplayableConnection.class, TxnReplayableStatement.class, TxnReplayableResultSet.class, TxnReplayableArray.class, TxnReplayableBfile.class, TxnReplayableBlob.class, TxnReplayableClob.class, TxnReplayableNClob.class, TxnReplayableOpaque.class, TxnReplayableRef.class, TxnReplayableSqlxml.class, TxnReplayableStruct.class, TxnReplayableOthers.class);
            }
        }
    }
}

