/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import oracle.net.ns.ConnectPacket;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.NTAdapter;

final class NIOConnectPacket
extends NIOPacket {
    static final boolean DEBUG = false;
    static final int ntCharacteristics = 20376;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    NIOConnectPacket(SessionAtts session) {
        super(session);
    }

    final void writeToSocketChannel(String connectData, boolean sendAttention, boolean useVIO, boolean isUrgentSupported, int sdu, int tdu, int anoFlags) throws IOException {
        if (sdu < 512) {
            sdu = 512;
        }
        if (tdu < 255) {
            tdu = 255;
        }
        if (sdu > 0x200000) {
            sdu = 0x200000;
        }
        if (tdu > 0x200000) {
            tdu = 0x200000;
        }
        if (tdu < sdu) {
            tdu = sdu;
        }
        if (connectData != null) {
            connectData = ConnectPacket.makeConnectionStringUseIPAddresses(connectData, this.session.nt.getInetAddress());
        }
        int dataLen = connectData == null ? 0 : connectData.length();
        boolean connDataOflow = dataLen > 230;
        this.session.prepareWriteBuffer();
        this.session.payloadBufferForWrite.order(ByteOrder.BIG_ENDIAN);
        this.session.payloadBufferForWrite.putShort((short)318);
        this.session.payloadBufferForWrite.putShort((short)300);
        int connFlag2 = 0;
        int opt = 1;
        if (sendAttention && isUrgentSupported) {
            opt |= 0xC00;
            if (this.session.anoEnabled && this.session.networkType != NTAdapter.NetworkAdapterType.MSGQ) {
                connFlag2 = 1;
            }
        }
        if (useVIO) {
            opt |= 0x40;
        }
        this.session.payloadBufferForWrite.putShort((short)opt);
        if (sdu < 65535) {
            this.session.payloadBufferForWrite.putShort((short)sdu);
        } else {
            this.session.payloadBufferForWrite.putShort((short)-1);
        }
        if (tdu < 65535) {
            this.session.payloadBufferForWrite.putShort((short)tdu);
        } else {
            this.session.payloadBufferForWrite.putShort((short)-1);
        }
        this.session.payloadBufferForWrite.putShort((short)20376);
        this.session.payloadBufferForWrite.putShort((short)0);
        this.session.payloadBufferForWrite.putShort((short)1);
        this.session.payloadBufferForWrite.putShort((short)dataLen);
        this.session.payloadBufferForWrite.putShort((short)74);
        this.session.payloadBufferForWrite.putInt(0);
        if (!this.session.anoEnabled) {
            this.session.payloadBufferForWrite.put((byte)-124);
            this.session.payloadBufferForWrite.put((byte)-124);
        } else {
            this.session.payloadBufferForWrite.put((byte)(anoFlags | 0x80));
            this.session.payloadBufferForWrite.put((byte)(anoFlags | 0x80));
        }
        this.session.payloadBufferForWrite.position(42);
        this.session.payloadBufferForWrite.putShort((short)0);
        this.session.payloadBufferForWrite.putShort((short)0);
        this.session.payloadBufferForWrite.putShort((short)0);
        this.session.payloadBufferForWrite.putShort((short)0);
        this.session.payloadBufferForWrite.putInt(sdu);
        this.session.payloadBufferForWrite.putInt(tdu);
        int compressionFieldBuilder = 0;
        if (this.session.networkCompression.equals("on") || this.session.networkCompression.equals("auto")) {
            compressionFieldBuilder = Integer.MIN_VALUE;
            if (this.session.networkCompression.equals("auto")) {
                compressionFieldBuilder |= 0x40000000;
            }
            if (!this.session.cOption.protocol.equalsIgnoreCase("tcp")) {
                compressionFieldBuilder |= 2;
            }
            int schemeShiftCounter = 26;
            for (String level : this.session.networkCompressionLevelsArray) {
                if (level.equals("low")) {
                    compressionFieldBuilder |= 1 << schemeShiftCounter;
                } else if (level.equals("high")) {
                    compressionFieldBuilder |= 2 << schemeShiftCounter;
                }
                schemeShiftCounter -= 4;
            }
        }
        this.session.payloadBufferForWrite.putInt(compressionFieldBuilder);
        this.session.payloadBufferForWrite.putInt(connFlag2);
        this.session.payloadBufferForWrite.position(66);
        if (!connDataOflow && dataLen > 0) {
            this.session.payloadBufferForWrite.put(connectData.getBytes("ASCII"));
        }
        this.header.type = 1;
        this.header.flags = this.session.redirecting ? 2 : 0;
        this.session.redirecting = false;
        this.writeToSocketChannel();
        if (connDataOflow) {
            byte[] connectDataBytes = connectData.getBytes("ASCII");
            this.session.dataChannel.writeDataToSocketChannel(connectDataBytes);
        }
    }

    @Override
    void readPayloadBuffer() throws IOException {
        throw new UnsupportedOperationException("Attempting to read from a one way packet sent by client");
    }

    static {
        try {
            $$$methodRef$$$2 = NIOConnectPacket.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NIOConnectPacket.class.getDeclaredMethod("readPayloadBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NIOConnectPacket.class.getDeclaredMethod("writeToSocketChannel", String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

